/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationIndexer;

public abstract class AbstractPersistentCollection
implements PersistentCollection {
    private boolean initialized;
    private Serializable associationKey;
    private Session session;
    private AssociationIndexer indexer;
    private Collection keys;
    private Class childType;
    private boolean dirty = false;
    protected final Collection collection;

    protected AbstractPersistentCollection(Class childType, Session session, Collection collection) {
        this.childType = childType;
        this.collection = collection;
        this.session = session;
    }

    protected AbstractPersistentCollection(Collection keys, Class childType, Session session, Collection collection) {
        this.session = session;
        this.keys = keys;
        this.childType = childType;
        this.collection = collection;
    }

    protected AbstractPersistentCollection(Serializable associationKey, Session session, AssociationIndexer indexer, Collection collection) {
        this.session = session;
        this.associationKey = associationKey;
        this.indexer = indexer;
        this.collection = collection;
    }

    public Iterator iterator() {
        this.initialize();
        final Iterator iterator = this.collection.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return iterator.next();
            }

            public void remove() {
                iterator.remove();
                AbstractPersistentCollection.this.markDirty();
            }
        };
    }

    public int size() {
        this.initialize();
        return this.collection.size();
    }

    public boolean isEmpty() {
        this.initialize();
        return this.collection.isEmpty();
    }

    public boolean contains(Object o) {
        this.initialize();
        return this.collection.contains(o);
    }

    public boolean add(Object o) {
        this.initialize();
        boolean added = this.collection.add(o);
        if (added) {
            this.markDirty();
        }
        return added;
    }

    public boolean remove(Object o) {
        this.initialize();
        boolean remove = this.collection.remove(o);
        if (remove) {
            this.markDirty();
        }
        return remove;
    }

    public void clear() {
        this.initialize();
        this.collection.clear();
        this.markDirty();
    }

    public boolean equals(Object o) {
        this.initialize();
        return ((Object)this.collection).equals(o);
    }

    public int hashCode() {
        this.initialize();
        return ((Object)this.collection).hashCode();
    }

    public String toString() {
        this.initialize();
        return this.collection.toString();
    }

    public boolean removeAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.removeAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public Object[] toArray() {
        this.initialize();
        return this.collection.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.initialize();
        return this.collection.toArray(a);
    }

    public boolean containsAll(Collection c) {
        this.initialize();
        return this.collection.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.addAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        this.initialize();
        boolean changed = this.collection.retainAll(c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.associationKey == null) {
            if (this.keys != null) {
                this.addAll((Collection)this.session.retrieveAll(this.childType, this.keys));
            }
        } else {
            List results = this.indexer.query(this.associationKey);
            this.addAll((Collection)this.session.retrieveAll(this.indexer.getIndexedEntity().getJavaClass(), results));
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }
}

