/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConstantPoolChecker2 {
    private static final boolean DEBUG = false;
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_NameAndType = 12;
    static long total = 0L;
    private Object[] cpdata;
    private int cpsize;
    private int[] type;
    private List<String> referencedClasses = new ArrayList<String>();
    private List<String> referencedMethods = new ArrayList<String>();
    private String slashedclassname;

    public static void main(String[] args) throws Exception {
        File[] fs = new File("./bin").listFiles();
        ConstantPoolChecker2.checkThemAll(fs);
        System.out.println("total=" + (double)total / 1000000.0);
    }

    private static void checkThemAll(File[] fs) throws Exception {
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                ConstantPoolChecker2.checkThemAll(f.listFiles());
            } else if (f.getName().endsWith(".class")) {
                System.out.println(f);
                byte[] data = Utils.loadFromStream(new FileInputStream(f));
                long stime = System.nanoTime();
                References refs = ConstantPoolChecker2.getReferences(data);
                total += System.nanoTime() - stime;
                System.out.println(refs.referencedClasses);
                System.out.println(refs.referencedMethods);
            }
            ++n2;
        }
    }

    static References getReferences(byte[] bytes) {
        ConstantPoolChecker2 cpc2 = new ConstantPoolChecker2(bytes);
        return new References(cpc2.slashedclassname, cpc2.referencedClasses, cpc2.referencedMethods);
    }

    private ConstantPoolChecker2(byte[] bytes) {
        this.readConstantPool(bytes);
        this.computeReferences();
    }

    public void computeReferences() {
        int i = 0;
        while (i < this.cpsize) {
            switch (this.type[i]) {
                case 7: {
                    int classindex = (Integer)this.cpdata[i];
                    String classname = (String)this.cpdata[classindex];
                    if (classname == null) {
                        throw new IllegalStateException();
                    }
                    this.referencedClasses.add(classname);
                    break;
                }
                case 10: {
                    int[] indexes = (int[])this.cpdata[i];
                    int classindex2 = indexes[0];
                    int nameAndTypeIndex = indexes[1];
                    StringBuilder s = new StringBuilder();
                    String theClassName = (String)this.cpdata[(Integer)this.cpdata[classindex2]];
                    if (theClassName.charAt(0) != 'j') break;
                    s.append(theClassName);
                    s.append(".");
                    s.append((String)this.cpdata[(Integer)this.cpdata[nameAndTypeIndex]]);
                    this.referencedMethods.add(s.toString());
                }
            }
            ++i;
        }
    }

    public void readConstantPool(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new IllegalStateException("not bytecode, magic was 0x" + Integer.toString(magic, 16));
            }
            dis.skip(4L);
            this.cpsize = dis.readShort();
            this.cpdata = new Object[this.cpsize];
            this.type = new int[this.cpsize];
            int cpentry = 1;
            while (cpentry < this.cpsize) {
                boolean doubleSlot = this.processConstantPoolEntry(cpentry, dis);
                if (doubleSlot) {
                    ++cpentry;
                }
                ++cpentry;
            }
            dis.skip(2L);
            short thisclassname = dis.readShort();
            int classindex = (Integer)this.cpdata[thisclassname];
            this.slashedclassname = (String)this.cpdata[classindex];
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected problem processing bytes for class", e);
        }
    }

    private boolean processConstantPoolEntry(int index, DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        switch (b) {
            case 1: {
                this.cpdata[index] = dis.readUTF();
                break;
            }
            case 3: {
                dis.skip(4L);
                break;
            }
            case 4: {
                dis.skip(4L);
                break;
            }
            case 5: {
                dis.skip(8L);
                return true;
            }
            case 6: {
                dis.skip(8L);
                return true;
            }
            case 7: {
                this.type[index] = b;
                this.cpdata[index] = (int)dis.readShort();
                break;
            }
            case 8: {
                dis.skip(2L);
                break;
            }
            case 9: {
                dis.skip(4L);
                break;
            }
            case 10: {
                this.type[index] = b;
                this.cpdata[index] = new int[]{dis.readShort(), dis.readShort()};
                break;
            }
            case 11: {
                dis.skip(4L);
                break;
            }
            case 12: {
                this.cpdata[index] = (int)dis.readShort();
                dis.skip(2L);
                break;
            }
            default: {
                throw new IllegalStateException("Entry: " + index + " " + Byte.toString(b));
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class References {
        String slashedClassName;
        List<String> referencedClasses;
        List<String> referencedMethods;

        References(String slashedClassName, List<String> rc, List<String> rm) {
            this.slashedClassName = slashedClassName;
            this.referencedClasses = rc;
            this.referencedMethods = rm;
        }
    }
}

