/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentElementHolder;
import org.hibernate.collection.PersistentMapElementHolder;
import org.hibernate.collection.PersistentSortedMap;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.MapType;
import org.hibernate.type.TypeFactory;

public class SortedMapType
extends MapType {
    private final Comparator comparator;

    public SortedMapType(TypeFactory.TypeScope typeScope, String role, String propertyRef, Comparator comparator, boolean isEmbeddedInXML) {
        super(typeScope, role, propertyRef, isEmbeddedInXML);
        this.comparator = comparator;
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister, Serializable key) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentMapElementHolder(session, persister, key);
        }
        PersistentSortedMap map = new PersistentSortedMap(session);
        map.setComparator(this.comparator);
        return map;
    }

    public Class getReturnedClass() {
        return SortedMap.class;
    }

    public Object instantiate(int anticipatedSize) {
        return new TreeMap(this.comparator);
    }

    public PersistentCollection wrap(SessionImplementor session, Object collection) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(session, (Element)collection);
        }
        return new PersistentSortedMap(session, (SortedMap)collection);
    }
}

