/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.PluginBuildSettings;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.util.List;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.codehaus.groovy.grails.cli.UaaIntegrationSupport;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.resolve.GrailsRepoResolver;
import org.springframework.uaa.client.UaaService;
import org.springframework.uaa.client.UaaServiceFactory;
import org.springframework.uaa.client.VersionHelper;
import org.springframework.uaa.client.protobuf.UaaClient;

public class UaaIntegration {
    private static final String MESSAGE = "##########################################################.\nGrails would like to send information to VMware domains to improve your experience. We include anonymous usage information as part of these downloads.\n\nThe Grails team gathers anonymous usage information to improve your Grails experience, not for marketing purposes. The information is used to discover which Grails plugins are most popular and is published on the plugin portal.\n\nWe also use this information to help guide our roadmap, prioritizing the features and Grails plugins most valued by the community and enabling us to optimize the compatibility of technologies frequently used together.\n\nPlease see the Grails User Agent Analysis (UAA) Terms of Use at http://www.springsource.org/uaa/terms_of_use for more information on what information is collected and how such information is used. There is also an FAQ at http://www.springsource.org/uaa/faq for your convenience.\n\nTo consent to the Terms of Use, please enter 'Y'. Enter 'N' to indicate your do not consent and anonymous data collection will remain disabled.\n##########################################################.\nEnter Y or N:";
    private static boolean enabled = false;
    public static final int ONE_MINUTE = 1800;

    public static boolean isAvailable() {
        try {
            return UaaIntegration.class.getClassLoader().loadClass("org.springframework.uaa.client.UaaServiceFactory") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void enable(final BuildSettings settings, final PluginBuildSettings pluginSettings, boolean interactive) {
        UaaClient.Privacy.PrivacyLevel privacyLevel;
        UaaService uaaService;
        block3: {
            uaaService = UaaServiceFactory.getUaaService();
            privacyLevel = uaaService.getPrivacyLevel();
            if (!uaaService.isUaaTermsOfUseAccepted() && interactive && privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU)) {
                String selection;
                do {
                    GrailsConsole console;
                    if (!"y".equalsIgnoreCase(selection = (console = GrailsConsole.getInstance()).userInput(MESSAGE, new String[]{"y", "n"}))) continue;
                    uaaService.setPrivacyLevel(UaaClient.Privacy.PrivacyLevel.ENABLE_UAA);
                    break block3;
                } while (!"n".equalsIgnoreCase(selection));
                uaaService.setPrivacyLevel(UaaClient.Privacy.PrivacyLevel.DECLINE_TOU);
            }
        }
        if (UaaIntegration.isUaaAccepted(privacyLevel)) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1800L);
                        UaaClient.Product product = VersionHelper.getProduct((String)"Grails", (String)settings.getGrailsVersion());
                        uaaService.registerProductUsage(product);
                        ChainResolver chainResolver = settings.getDependencyManager().getChainResolver();
                        GrailsRepoResolver centralRepo = UaaIntegration.findCentralRepoResolver(chainResolver);
                        if (centralRepo != null) {
                            GrailsPluginInfo[] pluginInfos;
                            GPathResult pluginList = centralRepo.getPluginList(new File(settings.getGrailsWorkDir() + "/plugin-list-" + centralRepo.getName() + ".xml"));
                            for (GrailsPluginInfo pluginInfo : pluginInfos = pluginSettings.getPluginInfos(pluginSettings.getPluginDirPath())) {
                                boolean registerUsage = false;
                                if (settings.getDefaultPluginSet().contains(pluginInfo.getName())) {
                                    registerUsage = true;
                                } else {
                                    Object plugin = UaaIntegrationSupport.findPlugin(pluginList, pluginInfo.getName());
                                    if (plugin != null) {
                                        registerUsage = true;
                                    }
                                }
                                if (!registerUsage) continue;
                                uaaService.registerFeatureUsage(product, VersionHelper.getFeatureUse((String)pluginInfo.getName(), (String)pluginInfo.getVersion()));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(r).start();
            enabled = true;
        }
    }

    private static GrailsRepoResolver findCentralRepoResolver(ChainResolver chainResolver) {
        List resolvers = chainResolver.getResolvers();
        for (Object resolver : resolvers) {
            GrailsRepoResolver grailsRepoResolver;
            String resolverName;
            if (!(resolver instanceof GrailsRepoResolver) || (resolverName = (grailsRepoResolver = (GrailsRepoResolver)((Object)resolver)).getName()) == null || !resolverName.equals("grailsCentral")) continue;
            return grailsRepoResolver;
        }
        return null;
    }

    private static boolean isUaaAccepted(UaaClient.Privacy.PrivacyLevel privacyLevel) {
        return privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.ENABLE_UAA) || privacyLevel.equals((Object)UaaClient.Privacy.PrivacyLevel.LIMITED_DATA);
    }
}

