/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractAttributeStoringSession
implements Session {
    protected Map<Integer, Map<String, Object>> attributes = new ConcurrentHashMap<Integer, Map<String, Object>>();
    private boolean connected = true;

    public void setAttribute(Object entity, String attributeName, Object value) {
        if (entity == null) {
            return;
        }
        int id = System.identityHashCode(entity);
        Map<String, Object> attrs = this.attributes.get(id);
        if (attrs == null) {
            attrs = new ConcurrentHashMap<String, Object>();
            this.attributes.put(id, attrs);
        }
        if (attributeName != null && value != null) {
            attrs.put(attributeName, value);
        }
    }

    public Object getAttribute(Object entity, String attributeName) {
        if (entity == null) {
            return null;
        }
        Map<String, Object> attrs = this.attributes.get(System.identityHashCode(entity));
        if (attrs == null || attributeName == null) {
            return null;
        }
        return attrs.get(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.connected = false;
        try {
            this.clear();
            this.attributes.clear();
        }
        finally {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getDatastore()));
            if (sessionHolder != null) {
                sessionHolder.removeSession(this);
                if (sessionHolder.isEmpty()) {
                    try {
                        TransactionSynchronizationManager.unbindResource((Object)this.getDatastore());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

