/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.springframework.uaa.client.protobuf.UaaClient;
import org.springframework.uaa.client.util.Base64;
import org.springframework.uaa.client.util.HexUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtils {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String toString(UaaClient.UaaEnvelope ue) {
        if (ue == null) {
            return "";
        }
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        o.put("installation_id", new UUID(ue.getInstallationIdentifierMostSignificantBits(), ue.getInstallationIdentifierLeastSignificantBits()).toString());
        o.put("privacy_level", ue.getPrivacy().getPrivacyLevel().toString());
        o.put("privacy_level_last_changed", sdf.format(new Date(ue.getPrivacy().getDateLastChanged())));
        UaaClient.Privacy.PrivacyLevel pl = ue.getPrivacy().getPrivacyLevel();
        if (pl != UaaClient.Privacy.PrivacyLevel.DECLINE_TOU && pl != UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU) {
            o.put("usage_data", StringUtils.getUserAgent(ue.getUserAgent()));
        }
        StringWriter out = new StringWriter();
        try {
            JSONValue.writeJSONString(o, (Writer)out);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return out.toString();
    }

    private static Map<String, Object> getUserAgent(UaaClient.UserAgent ua) {
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        if (ua == null) {
            return o;
        }
        o.put("user_country", ua.getUserCountry());
        o.put("user_language", ua.getUserLanguage());
        if (ua.getProductUseCount() > 0) {
            JSONArray a = new JSONArray();
            ArrayList<UaaClient.ProductUse> productUseList = new ArrayList<UaaClient.ProductUse>(ua.getProductUseList());
            Collections.sort(productUseList, new Comparator<UaaClient.ProductUse>(){

                @Override
                public int compare(UaaClient.ProductUse o1, UaaClient.ProductUse o2) {
                    return o1.getProduct().getName().compareTo(o2.getProduct().getName());
                }
            });
            for (int i = 0; i < productUseList.size(); ++i) {
                UaaClient.ProductUse pu = (UaaClient.ProductUse)((Object)productUseList.get(i));
                a.add(StringUtils.getProductUse(pu));
            }
            o.put("product_use", a);
        }
        return o;
    }

    private static Map<String, Object> getProductUse(UaaClient.ProductUse pu) {
        int x;
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        o.put("product_name", JSONObject.escape((String)pu.getProduct().getName()));
        if (pu.getDateLastUsed() > 0L) {
            o.put("product_last_used", sdf.format(new Date(pu.getDateLastUsed())));
        }
        o.put("product_major_version", pu.getProduct().getMajorVersion());
        o.put("product_minor_version", pu.getProduct().getMinorVersion());
        o.put("product_patch_version", pu.getProduct().getPatchVersion());
        o.put("product_release_qualifier", JSONObject.escape((String)pu.getProduct().getReleaseQualifier()));
        o.put("product_source_control_id", JSONObject.escape((String)pu.getProduct().getSourceControlIdentifier()));
        if (!pu.getProductData().isEmpty()) {
            ByteDataContainer c = StringUtils.getByteDataForDisplay(pu.getProductData().toByteArray());
            o.put("product_data_" + c.getKey(), c.getValue());
        }
        if (pu.getFeatureUseCount() > 0) {
            List<UaaClient.FeatureUse> featureUseList = pu.getFeatureUseList();
            JSONArray a = new JSONArray();
            for (x = 0; x < featureUseList.size(); ++x) {
                UaaClient.FeatureUse fu = featureUseList.get(x);
                a.add(StringUtils.getFeatureUse(fu));
            }
            o.put("feature_use", a);
        }
        if (pu.getProjectsUsingCount() > 0) {
            JSONArray a = new JSONArray();
            List<UaaClient.Project> projectsUsingList = pu.getProjectsUsingList();
            for (x = 0; x < projectsUsingList.size(); ++x) {
                UaaClient.Project p = projectsUsingList.get(x);
                a.add(StringUtils.getProjectUse(p));
            }
            o.put("projects_using", a);
        }
        return o;
    }

    private static Map<String, Object> getFeatureUse(UaaClient.FeatureUse fu) {
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        o.put("feature_name", JSONObject.escape((String)fu.getName()));
        if (fu.getDateLastUsed() > 0L) {
            o.put("feature_last_used", sdf.format(new Date(fu.getDateLastUsed())));
        }
        o.put("feature_major_version", fu.getMajorVersion());
        o.put("feature_minor_version", fu.getMinorVersion());
        o.put("feature_patch_version", fu.getPatchVersion());
        o.put("feature_release_qualifier", JSONObject.escape((String)fu.getReleaseQualifier()));
        o.put("feature_source_control_id", JSONObject.escape((String)fu.getSourceControlIdentifier()));
        if (!fu.getFeatureData().isEmpty()) {
            ByteDataContainer c = StringUtils.getByteDataForDisplay(fu.getFeatureData().toByteArray());
            o.put("feature_data_" + c.getKey(), c.getValue());
        }
        return o;
    }

    private static Map<String, Object> getProjectUse(UaaClient.Project p) {
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        o.put("project_sha256_hash", HexUtils.toHex(p.getProjectSha256Hash().toByteArray()));
        o.put("project_last_used", sdf.format(new Date(p.getDateLastUsed())));
        return o;
    }

    private static ByteDataContainer getByteDataForDisplay(byte[] bytes) {
        ByteDataContainer result = new ByteDataContainer();
        if (StringUtils.isAscii(bytes)) {
            String data = new String(bytes);
            try {
                JSONParser parser = new JSONParser();
                result.key = "json";
                result.valueAsParsedByJson = parser.parse(data);
            }
            catch (Exception e) {
                result.key = "ascii";
                result.valueAsString = new String(bytes);
            }
        } else {
            result.key = "base64";
            result.valueAsString = Base64.encodeBytes(bytes);
        }
        return result;
    }

    static boolean isAscii(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    private static class ByteDataContainer {
        private String key = null;
        private Object valueAsParsedByJson = null;
        private String valueAsString = null;

        private ByteDataContainer() {
        }

        public Object getValue() {
            return this.valueAsParsedByJson == null ? this.valueAsString : this.valueAsParsedByJson;
        }

        public String getKey() {
            return this.key;
        }
    }
}

