/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.xml;

import groovy.xml.streamingmarkupsupport.StreamingMarkupWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XMLStreamWriter {
    protected StreamingMarkupWriter writer;
    protected Mode mode = Mode.INIT;
    protected Stack<String> tagStack = new Stack();
    private char quoteChar = (char)34;

    public XMLStreamWriter(StreamingMarkupWriter writer) {
        this.writer = writer;
    }

    public XMLStreamWriter startDocument(String encoding, String version) throws IOException {
        if (this.mode != Mode.INIT) {
            throw new IllegalStateException();
        }
        this.writer.unescaped().write(String.format("<?xml version=\"%s\" encoding=\"%s\"?>", version, encoding));
        return this;
    }

    protected void startTag() throws IOException {
        this.writer.unescaped().write(60);
    }

    public XMLStreamWriter startNode(String tag) throws IOException {
        if (this.mode == Mode.TAG) {
            this.endStartTag();
        }
        this.startTag();
        this.writer.unescaped().write(tag);
        this.tagStack.push(tag);
        this.mode = Mode.TAG;
        return this;
    }

    public XMLStreamWriter end() throws IOException {
        Writer ue = this.writer.unescaped();
        if (this.mode == Mode.TAG) {
            ue.write(" />");
            if (this.tagStack.pop() == null) {
                throw new IllegalStateException();
            }
        } else if (this.mode == Mode.CONTENT) {
            ue.write(60);
            ue.write(47);
            String t = this.tagStack.pop();
            if (t == null) {
                throw new IllegalStateException();
            }
            ue.write(t);
            ue.write(62);
        }
        this.mode = Mode.CONTENT;
        return this;
    }

    public XMLStreamWriter attribute(String name, String value) throws IOException {
        if (this.mode != Mode.TAG) {
            throw new IllegalStateException();
        }
        Writer ue = this.writer.unescaped();
        ue.write(" ");
        ue.write(name);
        ue.write(61);
        ue.write(this.quoteChar);
        this.writer.setWritingAttribute(true);
        this.writer.escaped().write(value);
        this.writer.setWritingAttribute(false);
        ue.write(this.quoteChar);
        return this;
    }

    protected void endStartTag() throws IOException {
        this.writer.unescaped().write(62);
    }

    public XMLStreamWriter characters(String data) throws IOException {
        if (this.mode == Mode.TAG) {
            this.endStartTag();
        }
        this.mode = Mode.CONTENT;
        this.writer.escaped().write(data);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        INIT,
        TAG,
        CONTENT;

    }
}

