/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet;

import groovy.lang.GroovyObject;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.pages.DefaultGroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.GrailsFlashScope;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsApplicationAttributes
implements GrailsApplicationAttributes {
    private static Log LOG = LogFactory.getLog(DefaultGrailsApplicationAttributes.class);
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private ServletContext context;
    private ApplicationContext appContext;
    private GroovyPagesTemplateEngine pagesTemplateEngine;
    private GrailsApplication grailsApplication;
    private GroovyPagesUriService groovyPagesUriService;
    private MessageSource messageSource;
    private GrailsPluginManager pluginManager;

    public DefaultGrailsApplicationAttributes(ServletContext context) {
        this.context = context;
        if (context != null) {
            this.appContext = (ApplicationContext)context.getAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT");
        }
        this.initBeans();
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    private void initBeans() {
        if (this.appContext != null) {
            this.pagesTemplateEngine = (GroovyPagesTemplateEngine)((Object)this.fetchBeanFromAppCtx("groovyPagesTemplateEngine"));
            this.pluginManager = (GrailsPluginManager)this.fetchBeanFromAppCtx("pluginManager");
            this.grailsApplication = (GrailsApplication)this.fetchBeanFromAppCtx("grailsApplication");
            this.groovyPagesUriService = (GroovyPagesUriService)this.fetchBeanFromAppCtx("groovyPagesUriService");
            this.messageSource = (MessageSource)this.fetchBeanFromAppCtx("messageSource");
        } else {
            LOG.warn((Object)"ApplicationContext not found in org.codehaus.groovy.grails.APPLICATION_CONTEXT attribute of servlet context.");
        }
        if (this.groovyPagesUriService == null) {
            this.groovyPagesUriService = new DefaultGroovyPagesUriService();
        }
    }

    private <T> T fetchBeanFromAppCtx(String name) {
        try {
            return (T)this.appContext.getBean(name);
        }
        catch (BeansException e) {
            LOG.warn((Object)("Bean named '" + name + "' is missing."));
            return null;
        }
    }

    @Override
    public String getPluginContextPath(HttpServletRequest request) {
        GroovyObject controller = this.getController((ServletRequest)request);
        if (controller != null) {
            String path = this.pluginManager.getPluginPathForInstance((Object)controller);
            return path == null ? "" : path;
        }
        return "";
    }

    @Override
    public GroovyObject getController(ServletRequest request) {
        return (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
    }

    @Override
    public String getControllerUri(ServletRequest request) {
        return "/" + this.getControllerName(request);
    }

    private String getControllerName(ServletRequest request) {
        GroovyObject controller;
        String controllerName = (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE");
        if ((controllerName == null || controllerName.length() == 0) && (controller = this.getController(request)) != null) {
            controllerName = (String)controller.getProperty("controllerName");
            request.setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
        }
        return controllerName != null ? controllerName : "";
    }

    @Override
    @Deprecated
    public String getApplicationUri(ServletRequest request) {
        String appUri = (String)request.getAttribute("org.codehaus.groovy.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath((HttpServletRequest)request);
        }
        return appUri;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public FlashScope getFlashScope(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpSession session = servletRequest.getSession(false);
        FlashScope fs = session != null ? (FlashScope)session.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE") : (FlashScope)request.getAttribute("org.codehaus.groovy.grails.FLASH_SCOPE");
        if (fs == null) {
            fs = new GrailsFlashScope();
            if (session != null) {
                session.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
            } else {
                request.setAttribute("org.codehaus.groovy.grails.FLASH_SCOPE", (Object)fs);
            }
        }
        return fs;
    }

    @Override
    public String getTemplateUri(CharSequence templateName, ServletRequest request) {
        Assert.notNull((Object)templateName, (String)"Argument [template] cannot be null");
        return this.groovyPagesUriService.getTemplateURI(this.getControllerName(request), ((Object)templateName).toString());
    }

    @Override
    public String getViewUri(String viewName, HttpServletRequest request) {
        Assert.notNull((Object)viewName, (String)"Argument [view] cannot be null");
        return this.groovyPagesUriService.getDeployedViewURI(this.getControllerName((ServletRequest)request), viewName);
    }

    @Override
    public String getControllerActionUri(ServletRequest request) {
        GroovyObject controller = this.getController(request);
        return (String)controller.getProperty("actionUri");
    }

    @Override
    public Errors getErrors(ServletRequest request) {
        return (Errors)request.getAttribute("org.codehaus.groovy.grails.ERRORS");
    }

    @Override
    public GroovyPagesTemplateEngine getPagesTemplateEngine() {
        if (this.pagesTemplateEngine != null) {
            return this.pagesTemplateEngine;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"No bean named [groovyPagesTemplateEngine] defined in Spring application context!");
        }
        return null;
    }

    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    @Override
    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName) {
        return this.getTagLibraryForTag(request, response, tagName, "g");
    }

    @Override
    public GroovyObject getTagLibraryForTag(HttpServletRequest request, HttpServletResponse response, String tagName, String namespace) {
        String nonNullNamesapce = namespace == null ? "g" : namespace;
        String fullTagName = nonNullNamesapce + ":" + tagName;
        GrailsTagLibClass tagLibClass = (GrailsTagLibClass)this.getGrailsApplication().getArtefactForFeature("TagLib", (Object)fullTagName);
        if (tagLibClass == null) {
            return null;
        }
        return (GroovyObject)this.getApplicationContext().getBean(tagLibClass.getFullName());
    }

    @Override
    public Writer getOut(HttpServletRequest request) {
        return (Writer)request.getAttribute("org.codehaus.groovy.grails.RESPONSE_OUT");
    }

    @Override
    public void setOut(HttpServletRequest request, Writer out2) {
        request.setAttribute("org.codehaus.groovy.grails.RESPONSE_OUT", (Object)out2);
    }

    @Override
    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        return this.groovyPagesUriService.getNoSuffixViewURI(controller, viewName);
    }

    @Override
    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.groovyPagesUriService.getTemplateURI(controller, templateName);
    }

    @Override
    public GroovyPagesUriService getGroovyPagesUriService() {
        return this.groovyPagesUriService;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

