/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import javax.servlet.ServletRequest;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.springframework.util.Assert;

public class GroovyPagesUriSupport
implements GroovyPagesUriService {
    public static final String PATH_TO_VIEWS = "/WEB-INF/grails-app/views";
    private static final char SLASH = '/';
    private static final String SLASH_STR = "/";
    private static final String SLASH_UNDR = "/_";
    private static final String BLANK = "";
    private static final String UNDERSCORE = "_";

    public String getTemplateURI(GroovyObject controller, String templateName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    public void clear() {
    }

    public String getViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getViewURI(this.getLogicalControllerName(controller), viewName);
    }

    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    public String getLogicalControllerName(GroovyObject controller) {
        String logicalName;
        ServletRequest request = null;
        try {
            request = (ServletRequest)controller.getProperty("request");
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
        String string = logicalName = request != null ? (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE") : null;
        if (logicalName == null) {
            logicalName = GrailsNameUtils.getLogicalPropertyName((String)controller.getClass().getName(), (String)"Controller");
        }
        return logicalName;
    }

    public String getTemplateURI(String controllerName, String templateName) {
        if (templateName.startsWith(SLASH_STR)) {
            return this.getAbsoluteTemplateURI(templateName);
        }
        FastStringWriter buf = new FastStringWriter();
        String pathToTemplate = BLANK;
        int lastSlash = templateName.lastIndexOf(47);
        if (lastSlash > -1) {
            pathToTemplate = templateName.substring(0, lastSlash + 1);
            templateName = templateName.substring(lastSlash + 1);
        }
        buf.append('/').append(controllerName).append('/').append(pathToTemplate).append(UNDERSCORE).append(templateName);
        return buf.append(".gsp").toString();
    }

    public String getAbsoluteTemplateURI(String templateName) {
        FastStringWriter buf = new FastStringWriter();
        String tmp = templateName.substring(1, templateName.length());
        if (tmp.indexOf(47) > -1) {
            buf.append('/');
            int i = tmp.lastIndexOf(47);
            buf.append(tmp.substring(0, i));
            buf.append(SLASH_UNDR);
            buf.append(tmp.substring(i + 1, tmp.length()));
        } else {
            buf.append(SLASH_UNDR);
            buf.append(templateName.substring(1, templateName.length()));
        }
        String uri = buf.append(".gsp").toString();
        buf.close();
        return uri;
    }

    public String getViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    public String getAbsoluteViewURI(String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getAbsoluteViewURIInternal(viewName, buf, true);
    }

    public String getNoSuffixViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, false);
    }

    public String getDeployedViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter(PATH_TO_VIEWS);
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    public String getDeployedAbsoluteViewURI(String viewName) {
        FastStringWriter buf = new FastStringWriter(PATH_TO_VIEWS);
        return this.getAbsoluteViewURIInternal(viewName, buf, true);
    }

    private String getViewURIInternal(String controllerName, String viewName, FastStringWriter buf, boolean includeSuffix) {
        if (viewName != null && viewName.startsWith(SLASH_STR)) {
            return this.getAbsoluteViewURIInternal(viewName, buf, includeSuffix);
        }
        buf.append('/').append(controllerName);
        if (viewName != null) {
            buf.append('/').append(viewName);
        }
        return includeSuffix ? buf.append(".gsp").toString() : buf.toString();
    }

    private String getAbsoluteViewURIInternal(String viewName, FastStringWriter buf, boolean includeSuffix) {
        String tmp = viewName.substring(1, viewName.length());
        if (tmp.indexOf(47) > -1) {
            buf.append('/');
            buf.append(tmp.substring(0, tmp.lastIndexOf(47)));
            buf.append('/');
            buf.append(tmp.substring(tmp.lastIndexOf(47) + 1, tmp.length()));
        } else {
            buf.append('/');
            buf.append(viewName.substring(1, viewName.length()));
        }
        if (includeSuffix) {
            buf.append(".gsp").toString();
        }
        return buf.toString();
    }
}

