/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.config.DefaultFlowRegistry;
import org.springframework.webflow.config.FlowBuilderInfo;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.config.FlowDefinitionResourceFactory;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.config.FlowLocation;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.DefaultFlowHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderContextImpl;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.xml.XmlFlowModelBuilder;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;

class FlowRegistryFactoryBean
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean,
DisposableBean {
    private FlowLocation[] flowLocations;
    private String[] flowLocationPatterns;
    private FlowBuilderInfo[] flowBuilders;
    private FlowBuilderServices flowBuilderServices;
    private FlowDefinitionRegistry parent;
    private String basePath;
    private ClassLoader classLoader;
    private DefaultFlowRegistry flowRegistry;
    private FlowDefinitionResourceFactory flowResourceFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    FlowRegistryFactoryBean() {
    }

    public void setFlowLocations(FlowLocation[] flowLocations) {
        this.flowLocations = flowLocations;
    }

    public void setFlowLocationPatterns(String[] flowLocationPatterns) {
        this.flowLocationPatterns = flowLocationPatterns;
    }

    public void setFlowBuilders(FlowBuilderInfo[] flowBuilders) {
        this.flowBuilders = flowBuilders;
    }

    public void setFlowBuilderServices(FlowBuilderServices flowBuilderServices) {
        this.flowBuilderServices = flowBuilderServices;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setParent(FlowDefinitionRegistry parent) {
        this.parent = parent;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.flowResourceFactory = new FlowDefinitionResourceFactory((ResourceLoader)this.flowBuilderServices.getApplicationContext());
        if (this.basePath != null) {
            this.flowResourceFactory.setBasePath(this.basePath);
        }
        this.flowRegistry = new DefaultFlowRegistry();
        this.flowRegistry.setParent(this.parent);
        this.registerFlowLocations();
        this.registerFlowLocationPatterns();
        this.registerFlowBuilders();
    }

    public Object getObject() throws Exception {
        return this.flowRegistry;
    }

    public Class getObjectType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.definition.registry.FlowDefinitionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.flowRegistry.destroy();
    }

    private void registerFlowLocations() {
        if (this.flowLocations != null) {
            int i = 0;
            while (i < this.flowLocations.length) {
                FlowLocation location = this.flowLocations[i];
                this.flowRegistry.registerFlowDefinition(this.createFlowDefinitionHolder(this.createResource(location)));
                ++i;
            }
        }
    }

    private void registerFlowLocationPatterns() {
        if (this.flowLocationPatterns != null) {
            int i = 0;
            while (i < this.flowLocationPatterns.length) {
                FlowDefinitionResource[] resources;
                String pattern = this.flowLocationPatterns[i];
                AttributeMap attributes = this.getFlowAttributes(Collections.EMPTY_SET);
                try {
                    resources = this.flowResourceFactory.createResources(pattern, attributes);
                }
                catch (IOException e) {
                    IllegalStateException ise = new IllegalStateException("An I/O Exception occurred resolving the flow location pattern '" + pattern + "'");
                    ise.initCause(e);
                    throw ise;
                }
                int j = 0;
                while (j < resources.length) {
                    this.flowRegistry.registerFlowDefinition(this.createFlowDefinitionHolder(resources[j]));
                    ++j;
                }
                ++i;
            }
        }
    }

    private void registerFlowBuilders() {
        if (this.flowBuilders != null) {
            int i = 0;
            while (i < this.flowBuilders.length) {
                FlowBuilderInfo builderInfo = this.flowBuilders[i];
                this.flowRegistry.registerFlowDefinition(this.buildFlowDefinition(builderInfo));
                ++i;
            }
        }
    }

    private FlowDefinitionHolder createFlowDefinitionHolder(FlowDefinitionResource flowResource) {
        FlowBuilder builder = this.createFlowBuilder(flowResource);
        FlowBuilderContextImpl builderContext = new FlowBuilderContextImpl(flowResource.getId(), flowResource.getAttributes(), this.flowRegistry, this.flowBuilderServices);
        FlowAssembler assembler = new FlowAssembler(builder, builderContext);
        return new DefaultFlowHolder(assembler);
    }

    private FlowDefinitionResource createResource(FlowLocation location) {
        AttributeMap flowAttributes = this.getFlowAttributes(location.getAttributes());
        return this.flowResourceFactory.createResource(location.getPath(), flowAttributes, location.getId());
    }

    private AttributeMap getFlowAttributes(Set attributes) {
        LocalAttributeMap flowAttributes = null;
        if (this.flowBuilderServices.getDevelopment()) {
            flowAttributes = new LocalAttributeMap(1 + attributes.size(), 1);
            flowAttributes.put("development", Boolean.TRUE);
        }
        if (!attributes.isEmpty()) {
            if (flowAttributes == null) {
                flowAttributes = new LocalAttributeMap(attributes.size(), 1);
            }
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                FlowElementAttribute attribute = (FlowElementAttribute)it.next();
                flowAttributes.put(attribute.getName(), this.getConvertedValue(attribute));
            }
        }
        return flowAttributes;
    }

    private FlowBuilder createFlowBuilder(FlowDefinitionResource resource) {
        return new FlowModelFlowBuilder(this.createFlowModelHolder(resource));
    }

    private FlowModelHolder createFlowModelHolder(FlowDefinitionResource resource) {
        DefaultFlowModelHolder modelHolder = new DefaultFlowModelHolder(this.createFlowModelBuilder(resource));
        this.flowRegistry.getFlowModelRegistry().registerFlowModel(resource.getId(), modelHolder);
        return modelHolder;
    }

    private FlowModelBuilder createFlowModelBuilder(FlowDefinitionResource resource) {
        if (this.isXml(resource.getPath())) {
            return new XmlFlowModelBuilder(resource.getPath(), this.flowRegistry.getFlowModelRegistry());
        }
        throw new IllegalArgumentException(resource + " is not a supported resource type; supported types are [.xml]");
    }

    private boolean isXml(Resource flowResource) {
        return flowResource.getFilename().endsWith(".xml");
    }

    private Object getConvertedValue(FlowElementAttribute attribute) {
        if (attribute.needsTypeConversion()) {
            Class targetType = this.fromStringToClass(attribute.getType());
            ConversionService conversionService = this.flowBuilderServices.getConversionService();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ConversionExecutor converter = conversionService.getConversionExecutor((Class)clazz, targetType);
            return converter.execute((Object)attribute.getValue());
        }
        return attribute.getValue();
    }

    private Class fromStringToClass(String name) {
        Class clazz = this.flowBuilderServices.getConversionService().getClassForAlias(name);
        if (clazz != null) {
            return clazz;
        }
        return this.loadClass(name);
    }

    private Class loadClass(String name) {
        try {
            return ClassUtils.forName((String)name, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to load class '" + name + "'");
        }
    }

    private FlowDefinition buildFlowDefinition(FlowBuilderInfo builderInfo) {
        try {
            Class flowBuilderClass = this.loadClass(builderInfo.getClassName());
            FlowBuilder builder = (FlowBuilder)flowBuilderClass.newInstance();
            AttributeMap flowAttributes = this.getFlowAttributes(builderInfo.getAttributes());
            FlowBuilderContextImpl builderContext = new FlowBuilderContextImpl(builderInfo.getId(), flowAttributes, this.flowRegistry, this.flowBuilderServices);
            FlowAssembler assembler = new FlowAssembler(builder, builderContext);
            return assembler.assembleFlow();
        }
        catch (IllegalArgumentException e) {
            throw new FlowDefinitionConstructionException(builderInfo.getId(), e);
        }
        catch (InstantiationException e) {
            throw new FlowDefinitionConstructionException(builderInfo.getId(), e);
        }
        catch (IllegalAccessException e) {
            throw new FlowDefinitionConstructionException(builderInfo.getId(), e);
        }
    }
}

