/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.grails.support.proxy.DefaultProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableConverterConfiguration<C extends Converter>
implements ConverterConfiguration<C> {
    protected final List<ObjectMarshaller<C>> marshallers;
    private final String encoding;
    private final Converter.CircularReferenceBehaviour circularReferenceBehaviour;
    private final boolean prettyPrint;
    private ProxyHandler proxyHandler;

    public ImmutableConverterConfiguration(ConverterConfiguration<C> cfg) {
        this(cfg, (ProxyHandler)new DefaultProxyHandler());
    }

    public ImmutableConverterConfiguration(ConverterConfiguration<C> cfg, ProxyHandler proxyHandler) {
        this.marshallers = Collections.unmodifiableList(cfg.getOrderedObjectMarshallers());
        this.encoding = cfg.getEncoding();
        this.prettyPrint = cfg.isPrettyPrint();
        this.circularReferenceBehaviour = cfg.getCircularReferenceBehaviour();
        this.proxyHandler = proxyHandler;
    }

    @Override
    public ObjectMarshaller<C> getMarshaller(Object o) {
        for (ObjectMarshaller<C> om : this.marshallers) {
            if (!om.supports(o)) continue;
            return om;
        }
        return null;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Converter.CircularReferenceBehaviour getCircularReferenceBehaviour() {
        return this.circularReferenceBehaviour;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public List<ObjectMarshaller<C>> getOrderedObjectMarshallers() {
        return this.marshallers;
    }

    @Override
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }
}

