/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentLoader;

public class SkeletonDataLoader
extends AsynchronousAssetLoader<SkeletonData, SkeletonDataParameter> {
    private SkeletonData skeletonData;

    public SkeletonDataLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, @Null SkeletonDataParameter parameter) {
        float scale = 1.0f;
        AttachmentLoader attachmentLoader = null;
        if (parameter != null) {
            scale = parameter.scale;
            if (parameter.attachmentLoader != null) {
                attachmentLoader = parameter.attachmentLoader;
            } else if (parameter.atlasName != null) {
                attachmentLoader = new AtlasAttachmentLoader(manager.get(parameter.atlasName, TextureAtlas.class));
            }
        }
        if (attachmentLoader == null) {
            attachmentLoader = new AtlasAttachmentLoader(manager.get(String.valueOf(file.pathWithoutExtension()) + ".atlas", TextureAtlas.class));
        }
        if (file.extension().equalsIgnoreCase("skel")) {
            SkeletonBinary skeletonBinary = new SkeletonBinary(attachmentLoader);
            skeletonBinary.setScale(scale);
            this.skeletonData = skeletonBinary.readSkeletonData(file);
        } else {
            SkeletonJson skeletonJson = new SkeletonJson(attachmentLoader);
            skeletonJson.setScale(scale);
            this.skeletonData = skeletonJson.readSkeletonData(file);
        }
    }

    @Override
    public SkeletonData loadSync(AssetManager manager, String fileName, FileHandle file, @Null SkeletonDataParameter parameter) {
        SkeletonData skeletonData = this.skeletonData;
        this.skeletonData = null;
        return skeletonData;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, @Null SkeletonDataParameter parameter) {
        if (parameter == null) {
            return null;
        }
        if (parameter.attachmentLoader != null) {
            return null;
        }
        Array<AssetDescriptor> dependencies = new Array<AssetDescriptor>();
        dependencies.add(new AssetDescriptor<TextureAtlas>(parameter.atlasName, TextureAtlas.class));
        return dependencies;
    }

    public static class SkeletonDataParameter
    extends AssetLoaderParameters<SkeletonData> {
        public String atlasName;
        public AttachmentLoader attachmentLoader;
        public float scale = 1.0f;

        public SkeletonDataParameter() {
        }

        public SkeletonDataParameter(String atlasName) {
            this.atlasName = atlasName;
        }

        public SkeletonDataParameter(String atlasName, float scale) {
            this.atlasName = atlasName;
            this.scale = scale;
        }

        public SkeletonDataParameter(AttachmentLoader attachmentLoader) {
            this.attachmentLoader = attachmentLoader;
        }

        public SkeletonDataParameter(AttachmentLoader attachmentLoader, float scale) {
            this.attachmentLoader = attachmentLoader;
            this.scale = scale;
        }
    }
}

