/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Null;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Skeleton {
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<IkConstraint> ikConstraints;
    final Array<TransformConstraint> transformConstraints;
    final Array<PathConstraint> pathConstraints;
    final Array<Updatable> updateCache = new Array();
    @Null
    Skin skin;
    final Color color;
    float time;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float x;
    float y;

    public Skeleton(SkeletonData data) {
        Bone bone;
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
        this.bones = new Array(data.bones.size);
        T[] bones = this.bones.items;
        for (BoneData boneData : data.bones) {
            if (boneData.parent == null) {
                bone = new Bone(boneData, this, null);
            } else {
                Bone parent = (Bone)bones[boneData.parent.index];
                bone = new Bone(boneData, this, parent);
                parent.children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(data.slots.size);
        this.drawOrder = new Array(data.slots.size);
        for (SlotData slotData : data.slots) {
            bone = (Bone)bones[slotData.boneData.index];
            Slot slot = new Slot(slotData, bone);
            this.slots.add(slot);
            this.drawOrder.add(slot);
        }
        this.ikConstraints = new Array(data.ikConstraints.size);
        for (IkConstraintData ikConstraintData : data.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraintData, this));
        }
        this.transformConstraints = new Array(data.transformConstraints.size);
        for (TransformConstraintData transformConstraintData : data.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraintData, this));
        }
        this.pathConstraints = new Array(data.pathConstraints.size);
        for (PathConstraintData pathConstraintData : data.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraintData, this));
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public Skeleton(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = skeleton.data;
        this.bones = new Array(skeleton.bones.size);
        for (Bone bone : skeleton.bones) {
            Bone newBone;
            if (bone.parent == null) {
                newBone = new Bone(bone, this, null);
            } else {
                Bone parent = this.bones.get(bone.parent.data.index);
                newBone = new Bone(bone, this, parent);
                parent.children.add(newBone);
            }
            this.bones.add(newBone);
        }
        this.slots = new Array(skeleton.slots.size);
        for (Slot slot : skeleton.slots) {
            Bone bone = this.bones.get(slot.bone.data.index);
            this.slots.add(new Slot(slot, bone));
        }
        this.drawOrder = new Array(this.slots.size);
        for (Slot slot : skeleton.drawOrder) {
            this.drawOrder.add(this.slots.get(slot.data.index));
        }
        this.ikConstraints = new Array(skeleton.ikConstraints.size);
        for (IkConstraint ikConstraint : skeleton.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraint, this));
        }
        this.transformConstraints = new Array(skeleton.transformConstraints.size);
        for (TransformConstraint transformConstraint : skeleton.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraint, this));
        }
        this.pathConstraints = new Array(skeleton.pathConstraints.size);
        for (PathConstraint pathConstraint : skeleton.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraint, this));
        }
        this.skin = skeleton.skin;
        this.color = new Color(skeleton.color);
        this.time = skeleton.time;
        this.scaleX = skeleton.scaleX;
        this.scaleY = skeleton.scaleY;
        this.updateCache();
    }

    public void updateCache() {
        Array<Updatable> updateCache = this.updateCache;
        updateCache.clear();
        int boneCount = this.bones.size;
        T[] bones = this.bones.items;
        int i = 0;
        while (i < boneCount) {
            Bone bone = (Bone)bones[i];
            bone.sorted = bone.data.skinRequired;
            bone.active = !bone.sorted;
            ++i;
        }
        if (this.skin != null) {
            T[] skinBones = this.skin.bones.items;
            int i2 = 0;
            int n = this.skin.bones.size;
            while (i2 < n) {
                Bone bone = (Bone)bones[((BoneData)skinBones[i2]).index];
                do {
                    bone.sorted = false;
                    bone.active = true;
                } while ((bone = bone.parent) != null);
                ++i2;
            }
        }
        int ikCount = this.ikConstraints.size;
        int transformCount = this.transformConstraints.size;
        int pathCount = this.pathConstraints.size;
        T[] ikConstraints = this.ikConstraints.items;
        T[] transformConstraints = this.transformConstraints.items;
        T[] pathConstraints = this.pathConstraints.items;
        int constraintCount = ikCount + transformCount + pathCount;
        int i3 = 0;
        while (i3 < constraintCount) {
            block12: {
                Updatable constraint;
                int ii = 0;
                while (ii < ikCount) {
                    constraint = (IkConstraint)ikConstraints[ii];
                    if (constraint.data.order == i3) {
                        this.sortIkConstraint((IkConstraint)constraint);
                        break block12;
                    }
                    ++ii;
                }
                ii = 0;
                while (ii < transformCount) {
                    constraint = (TransformConstraint)transformConstraints[ii];
                    if (((TransformConstraint)constraint).data.order == i3) {
                        this.sortTransformConstraint((TransformConstraint)constraint);
                        break block12;
                    }
                    ++ii;
                }
                ii = 0;
                while (ii < pathCount) {
                    constraint = (PathConstraint)pathConstraints[ii];
                    if (((PathConstraint)constraint).data.order == i3) {
                        this.sortPathConstraint((PathConstraint)constraint);
                        break;
                    }
                    ++ii;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < boneCount) {
            this.sortBone((Bone)bones[i3]);
            ++i3;
        }
    }

    private void sortIkConstraint(IkConstraint constraint) {
        boolean bl = constraint.active = constraint.target.active && (!constraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(constraint.data, true));
        if (!constraint.active) {
            return;
        }
        Bone target = constraint.target;
        this.sortBone(target);
        Array<Bone> constrained = constraint.bones;
        Bone parent = constrained.first();
        this.sortBone(parent);
        if (constrained.size == 1) {
            this.updateCache.add(constraint);
            this.sortReset(parent.children);
        } else {
            Bone child = constrained.peek();
            this.sortBone(child);
            this.updateCache.add(constraint);
            this.sortReset(parent.children);
            child.sorted = true;
        }
    }

    private void sortPathConstraint(PathConstraint constraint) {
        Attachment attachment;
        boolean bl = constraint.active = constraint.target.bone.active && (!constraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(constraint.data, true));
        if (!constraint.active) {
            return;
        }
        Slot slot = constraint.target;
        int slotIndex = slot.getData().index;
        Bone slotBone = slot.bone;
        if (this.skin != null) {
            this.sortPathConstraintAttachment(this.skin, slotIndex, slotBone);
        }
        if (this.data.defaultSkin != null && this.data.defaultSkin != this.skin) {
            this.sortPathConstraintAttachment(this.data.defaultSkin, slotIndex, slotBone);
        }
        if ((attachment = slot.attachment) instanceof PathAttachment) {
            this.sortPathConstraintAttachment(attachment, slotBone);
        }
        T[] constrained = constraint.bones.items;
        int boneCount = constraint.bones.size;
        int i = 0;
        while (i < boneCount) {
            this.sortBone((Bone)constrained[i]);
            ++i;
        }
        this.updateCache.add(constraint);
        i = 0;
        while (i < boneCount) {
            this.sortReset(((Bone)constrained[i]).children);
            ++i;
        }
        i = 0;
        while (i < boneCount) {
            ((Bone)constrained[i]).sorted = true;
            ++i;
        }
    }

    private void sortTransformConstraint(TransformConstraint constraint) {
        int i;
        boolean bl = constraint.active = constraint.target.active && (!constraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(constraint.data, true));
        if (!constraint.active) {
            return;
        }
        this.sortBone(constraint.target);
        T[] constrained = constraint.bones.items;
        int boneCount = constraint.bones.size;
        if (constraint.data.local) {
            i = 0;
            while (i < boneCount) {
                Bone child = (Bone)constrained[i];
                this.sortBone(child.parent);
                this.sortBone(child);
                ++i;
            }
        } else {
            i = 0;
            while (i < boneCount) {
                this.sortBone((Bone)constrained[i]);
                ++i;
            }
        }
        this.updateCache.add(constraint);
        i = 0;
        while (i < boneCount) {
            this.sortReset(((Bone)constrained[i]).children);
            ++i;
        }
        i = 0;
        while (i < boneCount) {
            ((Bone)constrained[i]).sorted = true;
            ++i;
        }
    }

    private void sortPathConstraintAttachment(Skin skin, int slotIndex, Bone slotBone) {
        T[] entries = skin.attachments.orderedItems().items;
        int i = 0;
        int n = skin.attachments.size;
        while (i < n) {
            Skin.SkinEntry entry = (Skin.SkinEntry)entries[i];
            if (entry.slotIndex == slotIndex) {
                this.sortPathConstraintAttachment(entry.attachment, slotBone);
            }
            ++i;
        }
    }

    private void sortPathConstraintAttachment(Attachment attachment, Bone slotBone) {
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        int[] pathBones = ((PathAttachment)attachment).getBones();
        if (pathBones == null) {
            this.sortBone(slotBone);
        } else {
            T[] bones = this.bones.items;
            int i = 0;
            int n = pathBones.length;
            while (i < n) {
                int nn = pathBones[i++];
                nn += i;
                while (i < nn) {
                    this.sortBone((Bone)bones[pathBones[i++]]);
                }
            }
        }
    }

    private void sortBone(Bone bone) {
        if (bone.sorted) {
            return;
        }
        Bone parent = bone.parent;
        if (parent != null) {
            this.sortBone(parent);
        }
        bone.sorted = true;
        this.updateCache.add(bone);
    }

    private void sortReset(Array<Bone> bones) {
        T[] items = bones.items;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            Bone bone = (Bone)items[i];
            if (bone.active) {
                if (bone.sorted) {
                    this.sortReset(bone.children);
                }
                bone.sorted = false;
            }
            ++i;
        }
    }

    public void updateWorldTransform() {
        T[] updateCache = this.updateCache.items;
        int i = 0;
        int n = this.updateCache.size;
        while (i < n) {
            ((Updatable)updateCache[i]).update();
            ++i;
        }
    }

    public void updateWorldTransform(Bone parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null.");
        }
        Bone rootBone = this.getRootBone();
        float pa = parent.a;
        float pb = parent.b;
        float pc = parent.c;
        float pd = parent.d;
        rootBone.worldX = pa * this.x + pb * this.y + parent.worldX;
        rootBone.worldY = pc * this.x + pd * this.y + parent.worldY;
        float rotationY = rootBone.rotation + 90.0f + rootBone.shearY;
        float la = SpineUtils.cosDeg(rootBone.rotation + rootBone.shearX) * rootBone.scaleX;
        float lb = SpineUtils.cosDeg(rotationY) * rootBone.scaleY;
        float lc = SpineUtils.sinDeg(rootBone.rotation + rootBone.shearX) * rootBone.scaleX;
        float ld = SpineUtils.sinDeg(rotationY) * rootBone.scaleY;
        rootBone.a = (pa * la + pb * lc) * this.scaleX;
        rootBone.b = (pa * lb + pb * ld) * this.scaleX;
        rootBone.c = (pc * la + pd * lc) * this.scaleY;
        rootBone.d = (pc * lb + pd * ld) * this.scaleY;
        T[] updateCache = this.updateCache.items;
        int i = 0;
        int n = this.updateCache.size;
        while (i < n) {
            Updatable updatable = (Updatable)updateCache[i];
            if (updatable != rootBone) {
                updatable.update();
            }
            ++i;
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        T[] bones = this.bones.items;
        int i = 0;
        int n = this.bones.size;
        while (i < n) {
            ((Bone)bones[i]).setToSetupPose();
            ++i;
        }
        T[] ikConstraints = this.ikConstraints.items;
        int i2 = 0;
        int n2 = this.ikConstraints.size;
        while (i2 < n2) {
            IkConstraint constraint = (IkConstraint)ikConstraints[i2];
            constraint.mix = constraint.data.mix;
            constraint.softness = constraint.data.softness;
            constraint.bendDirection = constraint.data.bendDirection;
            constraint.compress = constraint.data.compress;
            constraint.stretch = constraint.data.stretch;
            ++i2;
        }
        T[] transformConstraints = this.transformConstraints.items;
        int i3 = 0;
        int n3 = this.transformConstraints.size;
        while (i3 < n3) {
            TransformConstraint constraint = (TransformConstraint)transformConstraints[i3];
            TransformConstraintData data = constraint.data;
            constraint.rotateMix = data.rotateMix;
            constraint.translateMix = data.translateMix;
            constraint.scaleMix = data.scaleMix;
            constraint.shearMix = data.shearMix;
            ++i3;
        }
        T[] pathConstraints = this.pathConstraints.items;
        int i4 = 0;
        int n4 = this.pathConstraints.size;
        while (i4 < n4) {
            PathConstraint constraint = (PathConstraint)pathConstraints[i4];
            PathConstraintData data = constraint.data;
            constraint.position = data.position;
            constraint.spacing = data.spacing;
            constraint.rotateMix = data.rotateMix;
            constraint.translateMix = data.translateMix;
            ++i4;
        }
    }

    public void setSlotsToSetupPose() {
        T[] slots = this.slots.items;
        int n = this.slots.size;
        SpineUtils.arraycopy(slots, 0, this.drawOrder.items, 0, n);
        int i = 0;
        while (i < n) {
            ((Slot)slots[i]).setToSetupPose();
            ++i;
        }
    }

    public SkeletonData getData() {
        return this.data;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Array<Updatable> getUpdateCache() {
        return this.updateCache;
    }

    public Bone getRootBone() {
        return this.bones.size == 0 ? null : this.bones.first();
    }

    @Null
    public Bone findBone(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        T[] bones = this.bones.items;
        int i = 0;
        int n = this.bones.size;
        while (i < n) {
            Bone bone = (Bone)bones[i];
            if (bone.data.name.equals(boneName)) {
                return bone;
            }
            ++i;
        }
        return null;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    @Null
    public Slot findSlot(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        T[] slots = this.slots.items;
        int i = 0;
        int n = this.slots.size;
        while (i < n) {
            Slot slot = (Slot)slots[i];
            if (slot.data.name.equals(slotName)) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public Array<Slot> getDrawOrder() {
        return this.drawOrder;
    }

    public void setDrawOrder(Array<Slot> drawOrder) {
        if (drawOrder == null) {
            throw new IllegalArgumentException("drawOrder cannot be null.");
        }
        this.drawOrder = drawOrder;
    }

    @Null
    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        Skin skin = this.data.findSkin(skinName);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + skinName);
        }
        this.setSkin(skin);
    }

    public void setSkin(@Null Skin newSkin) {
        if (newSkin == this.skin) {
            return;
        }
        if (newSkin != null) {
            if (this.skin != null) {
                newSkin.attachAll(this, this.skin);
            } else {
                T[] slots = this.slots.items;
                int i = 0;
                int n = this.slots.size;
                while (i < n) {
                    Attachment attachment;
                    Slot slot = (Slot)slots[i];
                    String name = slot.data.attachmentName;
                    if (name != null && (attachment = newSkin.getAttachment(i, name)) != null) {
                        slot.setAttachment(attachment);
                    }
                    ++i;
                }
            }
        }
        this.skin = newSkin;
        this.updateCache();
    }

    @Null
    public Attachment getAttachment(String slotName, String attachmentName) {
        SlotData slot = this.data.findSlot(slotName);
        if (slot == null) {
            throw new IllegalArgumentException("Slot not found: " + slotName);
        }
        return this.getAttachment(slot.getIndex(), attachmentName);
    }

    @Null
    public Attachment getAttachment(int slotIndex, String attachmentName) {
        Attachment attachment;
        if (attachmentName == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(slotIndex, attachmentName)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(slotIndex, attachmentName);
        }
        return null;
    }

    public void setAttachment(String slotName, @Null String attachmentName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Slot slot = this.findSlot(slotName);
        if (slot == null) {
            throw new IllegalArgumentException("Slot not found: " + slotName);
        }
        Attachment attachment = null;
        if (attachmentName != null && (attachment = this.getAttachment(slot.data.index, attachmentName)) == null) {
            throw new IllegalArgumentException("Attachment not found: " + attachmentName + ", for slot: " + slotName);
        }
        slot.setAttachment(attachment);
    }

    public Array<IkConstraint> getIkConstraints() {
        return this.ikConstraints;
    }

    @Null
    public IkConstraint findIkConstraint(String constraintName) {
        if (constraintName == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        T[] ikConstraints = this.ikConstraints.items;
        int i = 0;
        int n = this.ikConstraints.size;
        while (i < n) {
            IkConstraint ikConstraint = (IkConstraint)ikConstraints[i];
            if (ikConstraint.data.name.equals(constraintName)) {
                return ikConstraint;
            }
            ++i;
        }
        return null;
    }

    public Array<TransformConstraint> getTransformConstraints() {
        return this.transformConstraints;
    }

    @Null
    public TransformConstraint findTransformConstraint(String constraintName) {
        if (constraintName == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        T[] transformConstraints = this.transformConstraints.items;
        int i = 0;
        int n = this.transformConstraints.size;
        while (i < n) {
            TransformConstraint constraint = (TransformConstraint)transformConstraints[i];
            if (constraint.data.name.equals(constraintName)) {
                return constraint;
            }
            ++i;
        }
        return null;
    }

    public Array<PathConstraint> getPathConstraints() {
        return this.pathConstraints;
    }

    @Null
    public PathConstraint findPathConstraint(String constraintName) {
        if (constraintName == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        T[] pathConstraints = this.pathConstraints.items;
        int i = 0;
        int n = this.pathConstraints.size;
        while (i < n) {
            PathConstraint constraint = (PathConstraint)pathConstraints[i];
            if (constraint.data.name.equals(constraintName)) {
                return constraint;
            }
            ++i;
        }
        return null;
    }

    public void getBounds(Vector2 offset, Vector2 size, FloatArray temp) {
        if (offset == null) {
            throw new IllegalArgumentException("offset cannot be null.");
        }
        if (size == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        if (temp == null) {
            throw new IllegalArgumentException("temp cannot be null.");
        }
        T[] drawOrder = this.drawOrder.items;
        float minX = 2.1474836E9f;
        float minY = 2.1474836E9f;
        float maxX = -2.1474836E9f;
        float maxY = -2.1474836E9f;
        int i = 0;
        int n = this.drawOrder.size;
        while (i < n) {
            Slot slot = (Slot)drawOrder[i];
            if (slot.bone.active) {
                int verticesLength = 0;
                float[] vertices = null;
                Attachment attachment = slot.attachment;
                if (attachment instanceof RegionAttachment) {
                    verticesLength = 8;
                    vertices = temp.setSize(8);
                    ((RegionAttachment)attachment).computeWorldVertices(slot.getBone(), vertices, 0, 2);
                } else if (attachment instanceof MeshAttachment) {
                    MeshAttachment mesh = (MeshAttachment)attachment;
                    verticesLength = mesh.getWorldVerticesLength();
                    vertices = temp.setSize(verticesLength);
                    mesh.computeWorldVertices(slot, 0, verticesLength, vertices, 0, 2);
                }
                if (vertices != null) {
                    int ii = 0;
                    while (ii < verticesLength) {
                        float x = vertices[ii];
                        float y = vertices[ii + 1];
                        minX = Math.min(minX, x);
                        minY = Math.min(minY, y);
                        maxX = Math.max(maxX, x);
                        maxY = Math.max(maxY, y);
                        ii += 2;
                    }
                }
            }
            ++i;
        }
        offset.set(minX, minY);
        size.set(maxX - minX, maxY - minY);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null.");
        }
        this.color.set(color);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void update(float delta) {
        this.time += delta;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

