/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import com.esotericsoftware.gloomhavenhelper.App;

public enum CharacterClass {
    Escort(-716690945),
    Objective(882704639),
    Brute(934205439),
    Cragheart(-2104804353),
    Mindthief(1652139519),
    Scoundrel(-1546361601),
    Spellweaver(-794696961),
    Tinkerer(-758864897),
    Diviner(-1593835521),
    BeastTyrant(-1267311873),
    Berserker(-260288769),
    Doomstalker(1539693823),
    Elementalist(-589505281),
    Nightshroud(1950405887),
    Plagueherald(1927331583),
    Quartermaster(-928216065),
    Sawbones(-708141825),
    Soothsinger(-562982657),
    Summoner(-361383681),
    Sunkeeper(-52153089),
    Bladeswarm(-693331457);

    public static CharacterClass[] values;
    public transient Color color;
    public transient String name;

    static {
        values = CharacterClass.values();
    }

    private CharacterClass(int rgba) {
        this.color = new Color(rgba);
    }

    public int hpMax(int level) {
        switch (this) {
            case Mindthief: 
            case Spellweaver: 
            case Diviner: 
            case BeastTyrant: 
            case Elementalist: 
            case Plagueherald: 
            case Soothsinger: {
                return 6 + (level - 1);
            }
            case Scoundrel: 
            case Tinkerer: 
            case Doomstalker: 
            case Nightshroud: 
            case Sawbones: 
            case Summoner: 
            case Bladeswarm: {
                return 8 + (level - 1) + (level - 1) / 2;
            }
            case Brute: 
            case Cragheart: 
            case Berserker: 
            case Quartermaster: 
            case Sunkeeper: {
                return 10 + (level - 1) * 2;
            }
            case Escort: {
                return 4 + 2 * level;
            }
            case Objective: {
                return 6 + App.gloom.playerCount() * level;
            }
        }
        return 0;
    }

    public String toString() {
        if (this.name == null) {
            this.name = this.name();
            if (this == BeastTyrant) {
                this.name = "Beast Tyrant";
            }
        }
        return this.name;
    }

    public static void loadText(JsonValue text) {
        CharacterClass.BeastTyrant.name = text.getString("BeastTyrant");
        CharacterClass.Soothsinger.name = text.getString("Soothsinger");
        CharacterClass.Plagueherald.name = text.getString("Plagueherald");
        CharacterClass.Spellweaver.name = text.getString("Spellweaver");
        CharacterClass.Mindthief.name = text.getString("Mindthief");
        CharacterClass.Elementalist.name = text.getString("Elementalist");
        CharacterClass.Diviner.name = text.getString("Diviner");
        CharacterClass.Doomstalker.name = text.getString("Doomstalker");
        CharacterClass.Sawbones.name = text.getString("Sawbones");
        CharacterClass.Nightshroud.name = text.getString("Nightshroud");
        CharacterClass.Summoner.name = text.getString("Summoner");
        CharacterClass.Scoundrel.name = text.getString("Scoundrel");
        CharacterClass.Tinkerer.name = text.getString("Tinkerer");
        CharacterClass.Bladeswarm.name = text.getString("Bladeswarm");
        CharacterClass.Berserker.name = text.getString("Berserker");
        CharacterClass.Quartermaster.name = text.getString("Quartermaster");
        CharacterClass.Sunkeeper.name = text.getString("Sunkeeper");
        CharacterClass.Brute.name = text.getString("Brute");
        CharacterClass.Cragheart.name = text.getString("Cragheart");
        CharacterClass.Escort.name = text.getString("Escort");
        CharacterClass.Objective.name = text.getString("Objective");
    }
}

