/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.model;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterStats;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;

public class Monster {
    public int number;
    public MonsterType type;
    public SummonColor summonColor = SummonColor.blue;
    public int hp;
    public boolean isNew = true;
    public int hpMax;
    public final Array<Condition> conditions = new Array();
    public final Array<Condition> expiredConditions = new Array();
    public final Array<Condition> currentTurnConditions = new Array();
    public int summonMove;
    public int summonAttack;
    public int summonRange;
    public transient MonsterData data;
    public transient MonsterStats stats;

    public Monster() {
    }

    public Monster(MonsterData data, MonsterType type, int level, int number) {
        this.data = data;
        this.type = type;
        this.number = number;
        if (data != App.summonData) {
            this.stats = data.stats[type.ordinal()][level];
            if (this.stats == null) {
                throw new IllegalArgumentException("No stats available: " + data.name + ", " + (Object)((Object)type) + ", " + level);
            }
            this.hp = this.hpMax = this.stats.hpMax();
        } else {
            this.stats = App.summonStats;
            this.hp = this.hpMax = level * 2;
        }
    }
}

