/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.Timer;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.DeckDialog;
import com.esotericsoftware.gloomhavenhelper.Game;
import com.esotericsoftware.gloomhavenhelper.Intro;
import com.esotericsoftware.gloomhavenhelper.MainMenu;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.PlayerRow;
import com.esotericsoftware.gloomhavenhelper.Rows;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.ElementState;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.Player;
import com.esotericsoftware.gloomhavenhelper.model.PlayerInit;
import com.esotericsoftware.gloomhavenhelper.model.Scenario;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Animator;
import com.esotericsoftware.gloomhavenhelper.util.ElementButton;
import com.esotericsoftware.gloomhavenhelper.util.Row;
import com.esotericsoftware.gloomhavenhelper.util.TextMenu;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.utils.SkeletonActor;
import java.util.Iterator;

public class GloomhavenHelper
extends ApplicationAdapter {
    Sprite bg;
    Sprite vignette;
    Sprite bgLeft;
    Sprite bgRight;
    Sprite bgMiddle;
    Button mainMenuButton;
    public ElementButton fireButton;
    public ElementButton iceButton;
    public ElementButton airButton;
    public ElementButton earthButton;
    public ElementButton lightButton;
    public ElementButton darkButton;
    TextButton roundButton;
    TextButton drawButton;
    private Label scenarioLevelLabel;
    private Label xpLabel;
    private Label trapsLabel;
    private Label coinsLabel;
    public Label scenarioLabel;
    public Label roundLabel;
    public Label attackLabel;
    public Cell helpCell;
    Stack nextButtonStack;
    Button attackButton;
    Image attackImage1;
    Image attackImage2;
    public Rows rows;
    public ScrollPane rowsScroll;
    Table elementsTable;
    Table scenarioTable;
    public MainMenu mainMenu;
    public Intro intro;
    public Group toasts;
    private long lastZoomTime;
    public boolean zoomOut;
    public boolean zoomIn;
    int drawMinutes;
    Timer.Task drawTask;
    private int scenarioNumber;
    private boolean solo;
    private Cell networkCell;
    Container networkDisconnected;
    Container networkConnected;
    Container networkServerGray;
    Container networkServerGreen;
    TextButton helpAddPlayers;
    TextButton helpSetScenario;
    TextButton helpAddMonsters;
    Table helpSetScenarioOrAddMonsters;
    Label helpSpawnMonsters;
    Label helpChooseCards1;
    Label helpChooseCards2;
    Label helpChooseCards3;
    Label helpTakeTurns1;
    Label helpTakeTurns2;
    Label helpTakeTurns3;
    Label helpNextRound1;
    Label helpNextRound2;
    public final Array<MonsterRow> monsterRows = new Array();
    public final Array<PlayerRow> playerRows = new Array();

    @Override
    public void create() {
        App.game.initialize();
        if (App.args != null) {
            int i = 0;
            int n = App.args.length;
            while (i < n) {
                if (App.args[i].equals("-verbose")) {
                    Log.TRACE();
                    Gdx.app.setLogLevel(3);
                }
                ++i;
            }
        }
        App.gameThread = App.game.currentThread();
        App.game.loadConfig();
        App.load();
        App.viewport.setMinWorldHeight(App.config.zoomReset ? (float)Math.max(800, Gdx.graphics.getHeight()) : App.config.zoom);
        this.updateViewport();
        this.drawTask = new Timer.Task(){

            @Override
            public void run() {
                ++GloomhavenHelper.this.drawMinutes;
            }
        };
        this.createUI();
        this.layoutUI();
        this.events();
        App.stage.setScrollFocus(this.rowsScroll);
        if (App.config.fullscreen) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
            Gdx.graphics.setVSync(true);
        }
        App.game.loadState();
        this.updateHelpText();
        if (App.eclipse) {
            Network.update();
        }
    }

    public void createUI() {
        App.root = new Table();
        this.intro = new Intro();
        this.bg = App.skin.getSprite("bg/bg");
        this.vignette = App.skin.getSprite("vignette/vignette");
        this.bgLeft = App.skin.getSprite("vignette/bg-left");
        this.bgRight = App.skin.getSprite("vignette/bg-right");
        this.bgMiddle = App.skin.getSprite("vignette/bg-middle");
        this.networkDisconnected = new Container<Image>(new Image(App.drawable("network-disconnected", new Color(-803332353)))).padLeft(35.0f);
        this.networkConnected = new Container<Image>(new Image(App.drawable("network-connected", new Color(209330431)))).padLeft(35.0f);
        this.networkServerGray = new Container<Image>(new Image(App.drawable("network-server", App.buttonGray))).padLeft(35.0f);
        this.networkServerGreen = new Container<Image>(new Image(App.drawable("network-server", new Color(209330431)))).padLeft(35.0f);
        this.mainMenu = new MainMenu();
        this.mainMenuButton = App.imageButton().imageUp("psd/menu", App.buttonGray).imageOver("psd/menu").imageChecked("psd/menu").create();
        this.scenarioLabel = new Label((CharSequence)"", App.skin, "plainLargeOutline", App.buttonGray);
        this.scenarioLabel.setWrap(true);
        this.scenarioLabel.setAlignment(1);
        this.fireButton = new ElementButton("fire"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.fire = elementState;
                App.state.changed();
            }
        };
        this.iceButton = new ElementButton("ice"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.ice = elementState;
                App.state.changed();
            }
        };
        this.airButton = new ElementButton("air"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.air = elementState;
                App.state.changed();
            }
        };
        this.earthButton = new ElementButton("earth"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.earth = elementState;
                App.state.changed();
            }
        };
        this.lightButton = new ElementButton("light"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.light = elementState;
                App.state.changed();
            }
        };
        this.darkButton = new ElementButton("dark"){

            @Override
            protected void clicked(ElementState elementState) {
                App.state.dark = elementState;
                App.state.changed();
            }
        };
        this.roundButton = ((TextButtonBuilder)App.textButton("Next\nRound").disabledFontColor(App.gray)).create();
        this.roundButton.getLabelCell().pad(-12.0f, 9.0f, 0.0f, 0.0f);
        Object builder = App.textButton("Draw").disabledFontColor(App.gray);
        this.drawButton = ((TextButtonBuilder)builder).set(new TextButton("", ((TextButtonBuilder)builder).set((TextButton.TextButtonStyle)new TextButton.TextButtonStyle())){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                if (GloomhavenHelper.this.drawMinutes > 0) {
                    App.plainMediumOutline.setColor(App.buttonGray);
                    String text = GloomhavenHelper.this.drawMinutes == 1 ? "1 minute" : String.valueOf(GloomhavenHelper.this.drawMinutes) + " minutes";
                    App.plainMediumOutline.draw(batch, text, Math.round(this.getWidth() / 2.0f), this.getHeight() - 11.0f, 0.0f, 1, false);
                }
                super.draw(batch, parentAlpha);
            }
        });
        this.roundLabel = new Label((CharSequence)"", App.skin, "plainMediumOutline", App.buttonGray);
        this.roundLabel.setTouchable(Touchable.disabled);
        this.nextButtonStack = new Stack(new Container<Label>(this.roundLabel).width(0.0f).pad(0.0f, 0.0f, 5.0f, 8.0f).bottom().right());
        this.scenarioLevelLabel = new Label((CharSequence)"", App.skin, "default", App.buttonGray);
        this.xpLabel = new Label((CharSequence)"", App.skin, "default", App.buttonGray);
        this.trapsLabel = new Label((CharSequence)"", App.skin, "default", App.buttonGray);
        this.coinsLabel = new Label((CharSequence)"", App.skin, "default", App.buttonGray);
        this.attackButton = App.imageButton().imageUp(App.drawable("attack/back", "attack/border")).create();
        this.attackImage1 = new Image();
        this.attackImage2 = new Image();
        this.attackLabel = new Label((CharSequence)"", App.skin, "plainMediumOutline", App.lightGray);
        this.attackLabel.setTouchable(Touchable.disabled);
        this.rows = new Rows();
        this.elementsTable = new Table();
        this.scenarioTable = new Table(App.skin);
        this.scenarioTable.setTouchable(Touchable.enabled);
        this.rowsScroll = new ScrollPane((Actor)this.rows){

            @Override
            public void invalidate() {
                super.invalidate();
                GloomhavenHelper.this.rows.invalidate();
            }

            @Override
            protected void visualScrollY(float pixelsY) {
                super.visualScrollY(pixelsY);
                if (App.dragging) {
                    App.stage.screenToStageCoordinates(App.v2.set(Gdx.input.getX(), Gdx.input.getY()));
                    GloomhavenHelper.this.updateDrag(App.v2.x, App.v2.y);
                }
            }

            @Override
            public void draw(Batch batch, float parentAlpha) {
                this.validate();
                batch.setColor(parentAlpha, parentAlpha, parentAlpha, 0.0f);
                batch.disableBlending();
                float bgWidth = 1024.0f;
                float x = GloomhavenHelper.this.rows.startX;
                float top = Math.round(this.getHeight() + this.getVisualScrollY());
                while (x > 0.0f) {
                    x -= bgWidth;
                }
                float endX = this.getWidth() + bgWidth;
                while (x < endX) {
                    float bgy = top;
                    while (bgy >= -1024.0f) {
                        batch.draw(GloomhavenHelper.this.bg, x, bgy, bgWidth, 1024.0f);
                        bgy -= 1024.0f;
                    }
                    x += bgWidth;
                }
                batch.enableBlending();
                batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
                float right = this.getWidth() - 145.0f;
                float bgy = top;
                while (bgy >= -1024.0f) {
                    batch.draw(GloomhavenHelper.this.bgLeft, 0.0f, bgy, 124.0f, 1024.0f);
                    batch.draw(GloomhavenHelper.this.bgRight, right, bgy, 145.0f, 1024.0f);
                    int i = 1;
                    while (i < GloomhavenHelper.this.rows.columns) {
                        batch.draw(GloomhavenHelper.this.bgMiddle, (float)Math.round(GloomhavenHelper.this.rows.startX + (1101.0f + GloomhavenHelper.this.rows.spaceX) * (float)i - GloomhavenHelper.this.rows.spaceX / 2.0f - 40.0f), bgy, 81.0f, 1024.0f);
                        ++i;
                    }
                    bgy -= 1024.0f;
                }
                batch.draw(GloomhavenHelper.this.vignette, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                super.draw(batch, parentAlpha);
            }
        };
        this.rowsScroll.getStyle().vScrollKnob = App.skin.getDrawable("scroll-vert");
        this.rowsScroll.setFadeScrollBars(true);
        this.rowsScroll.setupFadeScrollBars(0.4f, 0.0f);
        this.rowsScroll.setScrollBarTouch(false);
        this.rowsScroll.setFlickScrollTapSquareSize(35.0f);
        this.helpAddPlayers = App.textButton("Add Characters").create();
        this.helpSetScenario = App.textButton("Set Scenario").create();
        this.helpAddMonsters = App.textButton("Add Monsters").create();
        this.helpSetScenarioOrAddMonsters = new Table(App.skin).left();
        this.helpSetScenarioOrAddMonsters.add(this.helpSetScenario);
        this.helpSetScenarioOrAddMonsters.add(new Label((CharSequence)"    or    ", App.skin, "plainLargeOutline", App.buttonGray));
        this.helpSetScenarioOrAddMonsters.add(this.helpAddMonsters);
        this.helpSpawnMonsters = new Label((CharSequence)"Use the \"+\" buttons\nto spawn monsters.", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpChooseCards1 = new Label((CharSequence)"", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpChooseCards2 = new Label((CharSequence)"", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpChooseCards3 = new Label((CharSequence)"Choose cards.", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpTakeTurns1 = new Label((CharSequence)"", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpTakeTurns2 = new Label((CharSequence)"", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpTakeTurns3 = new Label((CharSequence)"Take turns.", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpNextRound1 = new Label((CharSequence)"Click next round.", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpNextRound2 = new Label((CharSequence)"Next round.", App.skin, "plainLargeOutline", App.buttonGray);
        this.helpSpawnMonsters.setAlignment(1);
        this.helpChooseCards1.setAlignment(1);
        this.helpChooseCards2.setAlignment(1);
        this.helpChooseCards3.setAlignment(1);
        this.helpTakeTurns1.setAlignment(1);
        this.helpTakeTurns2.setAlignment(1);
        this.helpTakeTurns3.setAlignment(1);
        this.helpNextRound1.setAlignment(1);
        this.helpNextRound2.setAlignment(1);
        this.toasts = new Group();
        App.stage.addActor(this.toasts);
    }

    public void updateHelpText() {
        if (App.state.playerInit == PlayerInit.dragOrder) {
            this.helpChooseCards1.setText("Choose character ability cards,\nthen click Draw.");
            this.helpChooseCards2.setText("Choose character ability cards.");
            this.helpTakeTurns1.setText("Drag portraits for init order.\nTake turns, click each portrait.");
            this.helpTakeTurns2.setText("Drag portraits, take turns.");
        } else if (App.state.playerInit == PlayerInit.numpad) {
            this.helpChooseCards1.setText("Choose character ability cards,\nclick portraits, draw.");
            this.helpChooseCards2.setText("Choose character ability cards,\nset initiatives, draw.");
            this.helpTakeTurns1.setText("Take turns, click each portrait.");
            this.helpTakeTurns2.setText("Take turns, click each portrait.");
        } else {
            this.helpChooseCards1.setText("Choose character ability cards,\ndrag portraits right, draw.");
            this.helpChooseCards2.setText("Choose character ability cards,\nset initiatives, draw.");
            this.helpTakeTurns1.setText("Take turns, click each portrait.");
            this.helpTakeTurns2.setText("Take turns, click each portrait.");
        }
    }

    private void layoutUI() {
        this.elementsTable.defaults().space(5.0f);
        this.elementsTable.add(this.fireButton);
        this.elementsTable.add(this.iceButton);
        this.elementsTable.add(this.airButton);
        this.elementsTable.add(this.earthButton);
        this.elementsTable.add(this.lightButton);
        this.elementsTable.add(this.darkButton);
        this.scenarioTable.add(this.scenarioLabel).colspan(8).padBottom(10.0f).row();
        this.scenarioTable.add(this.scenarioLevelLabel).padRight(10.0f);
        this.scenarioTable.add(App.image("psd/level", App.buttonGray)).padRight(35.0f);
        this.scenarioTable.add(this.trapsLabel).padRight(9.0f);
        this.scenarioTable.add(App.image("psd/traps", App.buttonGray)).padRight(34.0f);
        this.scenarioTable.add(this.xpLabel).padRight(10.0f);
        this.scenarioTable.add(App.image("psd/xp", App.buttonGray)).padRight(34.0f);
        this.scenarioTable.add(this.coinsLabel).padRight(10.0f);
        this.scenarioTable.add(App.image("psd/coins", App.buttonGray));
        Table table = new Table();
        table.padBottom(3.0f);
        table.add(this.scenarioTable);
        this.networkCell = table.add().bottom();
        Table top = new Table();
        top.setBackground(App.skin.getDrawable("psd/bar-top"));
        top.pad(9.0f, 9.0f, 21.0f, 9.0f).defaults().space(15.0f);
        top.add(this.mainMenuButton).size(102.0f);
        this.helpCell = top.add().expandX().padLeft(-9.0f);
        top.add(this.elementsTable);
        Group attack2 = new Group();
        attack2.addActor(this.attackImage2);
        Table attackTable = new Table(){
            float desat;

            @Override
            public void act(float delta) {
                super.act(delta);
                float target = GloomhavenHelper.this.monsterRows.size == 0 || App.state.canDraw ? 1 : 0;
                this.desat = App.animate(this.desat, target, 0.5f, 1.0f, 2.0f, delta);
            }

            @Override
            public void draw(Batch batch, float parentAlpha) {
                if (this.desat != 0.0f) {
                    batch.setShader(App.desatShader);
                    App.desatShader.setUniformf("u_desat", 0.9f * this.desat);
                }
                super.draw(batch, parentAlpha);
                if (this.desat != 0.0f) {
                    batch.setShader(null);
                }
            }
        };
        attackTable.defaults().space(20.0f);
        attackTable.add(new Stack(this.attackButton, new Container<Label>(this.attackLabel).padRight(4.0f).padBottom(-3.0f).bottom().right())).size(158.0f, 107.0f);
        attackTable.add(this.attackImage1).size(158.0f, 107.0f);
        attackTable.add(attack2).width(38.0f);
        Table bottom = new Table();
        bottom.setBackground(App.skin.getDrawable("psd/bar-bottom"));
        bottom.pad(20.0f, 9.0f, 9.0f, 9.0f).defaults().space(20.0f);
        bottom.add(this.nextButtonStack).size(127.0f, 118.0f).pad(0.0f, -9.0f, -9.0f, 0.0f);
        bottom.add(table).expand().padLeft(-17.0f);
        bottom.add(attackTable);
        this.attackImage2.setRotation(-31.5f);
        this.attackImage2.setBounds(-82.0f, -29.0f, 158.0f, 107.0f);
        attack2.toBack();
        App.root.setFillParent(true);
        App.root.defaults().growX();
        App.root.add(top).padBottom(-12.0f).row();
        App.root.add(this.rowsScroll).grow().row();
        App.root.add(bottom).height(131.0f).padTop(-11.0f);
        top.toFront();
        if (App.eclipse) {
            App.stage.addActor(App.root);
            this.intro.esotericLogo = null;
            App.atlas.findRegion("esoteric/logo").getTexture().dispose();
        }
    }

    private void events() {
        Gdx.input.setInputProcessor(new InputMultiplexer(new InputAdapter(){

            @Override
            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                if (GloomhavenHelper.this.intro.introPhase > -1 && GloomhavenHelper.this.intro.introPhase < 3) {
                    return false;
                }
                SkeletonActor actor = App.rippleSkeletonPool.obtain();
                AnimationState.TrackEntry entry = actor.getAnimationState().setAnimation(0, "ripple", false);
                entry.setTrackEnd(entry.getAnimation().getDuration());
                actor.addAction(Actions.sequence((Action)Actions.delay(entry.getTrackEnd()), (Action)Actions.removeActor()));
                Vector2 position = App.stage.screenToStageCoordinates(App.v2.set(screenX, screenY));
                actor.setPosition(position.x, position.y);
                App.stage.addActor(actor);
                return false;
            }
        }, App.stage));
        this.attackButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (App.state.canDraw) {
                    return;
                }
                AttackModifier attackModifier3 = App.state.attackModifier2();
                if (App.state.attackModifiers.size == 0) {
                    App.state.shuffleAttackModifiers(true);
                    GloomhavenHelper.this.attackImage1.setDrawable(null);
                    GloomhavenHelper.this.attackImage2.setDrawable(null);
                }
                App.state.attackModifiersDiscard.add(App.state.attackModifiers.pop());
                AttackModifier attackModifier1 = App.state.attackModifier1();
                AttackModifier attackModifier2 = App.state.attackModifier2();
                switch (attackModifier1) {
                    case nullAttack: 
                    case doubleAttack: {
                        App.state.needsShuffle = true;
                    }
                }
                App.animateAttackCard(attackModifier1, GloomhavenHelper.this.attackButton, GloomhavenHelper.this.attackImage1, GloomhavenHelper.this.attackImage2);
                if (App.config.server || App.config.client) {
                    byte[] bytes = new byte[]{97, (byte)(attackModifier1.ordinal() + 1), (byte)(attackModifier2 == null ? 0 : attackModifier2.ordinal() + 1), (byte)(attackModifier3 == null ? 0 : attackModifier3.ordinal() + 1)};
                    App.state.changed(true, bytes);
                } else {
                    App.state.changed();
                }
            }
        });
        ClickListener attackDiscardListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                new DeckDialog.AttackModifierDeckDialog().show();
            }
        };
        this.attackImage1.addListener(attackDiscardListener);
        this.attackImage2.addListener(attackDiscardListener);
        this.mainMenuButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GloomhavenHelper.this.mainMenu.show(GloomhavenHelper.this.mainMenuButton, 0.0f, 0.0f, -31.0f, 0.0f, true);
            }
        });
        this.drawButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!(App.state.playerInit != PlayerInit.dragNumberRequired && App.state.playerInit != PlayerInit.numpad || GloomhavenHelper.this.playerInitiativeSet())) {
                    TextMenu menu = new TextMenu();
                    String text = "Player initiative numbers must be set.";
                    menu.table.add(new Container<Label>(new Label((CharSequence)text, App.skin, "plainLargeOutline", App.buttonGray)).pad(6.0f, 16.0f, 0.0f, 16.0f)).row();
                    if (App.config.help) {
                        text = App.state.playerInit == PlayerInit.numpad ? "Click each player's portrait to set the initiative number." : "Drag each player's portrait to the right to set the initiative number.";
                        menu.table.add(new Container<Label>(new Label((CharSequence)text, App.skin, "plainLargeOutline", App.buttonGray)).pad(6.0f, 16.0f, 0.0f, 16.0f)).row();
                    }
                    menu.table.padBottom(9.0f);
                    menu.show(GloomhavenHelper.this.drawButton, 0.0f, 0.0f, 0.0f, 0.0f, true);
                    menu.setBackgroundOffset(9.0f, 9.0f, 0.0f, 0.0f);
                    return;
                }
                int i = 0;
                int n = GloomhavenHelper.this.monsterRows.size;
                while (i < n) {
                    GloomhavenHelper.this.monsterRows.get(i).showAbility();
                    ++i;
                }
                App.state.canDraw = false;
                GloomhavenHelper.this.sortByInitiative(0.5f);
                App.state.changed();
                GloomhavenHelper.this.rowsScroll.setScrollY(0.0f);
            }
        });
        this.roundButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.expireConditions && !GloomhavenHelper.this.turnsFinished()) {
                    boolean conditions = false;
                    boolean wounds = false;
                    SnapshotArray<Actor> children = GloomhavenHelper.this.rows.getChildren();
                    if (App.state.expireConditions) {
                        int i = 0;
                        int n = children.size;
                        while (i < n) {
                            if (((Row)children.get(i)).hasExpiringConditions()) {
                                conditions = true;
                            }
                            ++i;
                        }
                    }
                    if (!conditions && !wounds) {
                        GloomhavenHelper.this.nextRound();
                        return;
                    }
                    final TextMenu menu = new TextMenu();
                    String text = "Some turns have not been taken.";
                    menu.table.add(new Container<Label>(new Label((CharSequence)text, App.skin, "plainLargeOutline", App.buttonGray)).pad(6.0f, 16.0f, 0.0f, 16.0f)).row();
                    if (App.config.help) {
                        text = "Click each portrait as turns are completed\nso conditions expire correctly.";
                        menu.table.add(new Container<Label>(new Label((CharSequence)text, App.skin, "plainLargeOutline", App.buttonGray)).pad(6.0f, 16.0f, 0.0f, 16.0f)).row();
                    }
                    menu.addTextItem("Next Round", new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            GloomhavenHelper.this.nextRound();
                            menu.hide();
                        }
                    }).getActor().getLabel().setAlignment(1);
                    menu.show(GloomhavenHelper.this.roundButton, 0.0f, 0.0f, 0.0f, 0.0f, true);
                    menu.setBackgroundOffset(9.0f, 9.0f, 0.0f, 0.0f);
                } else {
                    GloomhavenHelper.this.nextRound();
                }
            }
        });
        this.scenarioTable.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                TextMenu menu = GloomhavenHelper.this.mainMenu.setScenarioLevel();
                menu.show(GloomhavenHelper.this.scenarioTable, 0.0f, 38.0f, 0.0f, 0.0f, true);
                menu.setBackgroundOffset(-9.0f, -9.0f, 18.0f, 0.0f);
            }
        });
        this.helpAddPlayers.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(true);
                GloomhavenHelper.this.mainMenuButton.toggle();
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(false);
                GloomhavenHelper.this.mainMenu.addCharacters(true);
            }
        });
        this.helpSetScenario.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(true);
                GloomhavenHelper.this.mainMenuButton.toggle();
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(false);
                GloomhavenHelper.this.mainMenu.setScenario(true);
            }
        });
        this.helpAddMonsters.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(true);
                GloomhavenHelper.this.mainMenuButton.toggle();
                GloomhavenHelper.this.mainMenuButton.setProgrammaticChangeEvents(false);
                GloomhavenHelper.this.mainMenu.addMonsters(true);
            }
        });
    }

    void nextRound() {
        if (App.state.round >= 4) {
            App.game.showAd();
        }
        if (App.state.needsShuffle) {
            App.state.shuffleAttackModifiers(true);
            this.attackImage1.setDrawable(null);
            this.attackImage2.setDrawable(null);
        }
        this.fireButton.endOfRound();
        this.iceButton.endOfRound();
        this.airButton.endOfRound();
        this.earthButton.endOfRound();
        this.lightButton.endOfRound();
        this.darkButton.endOfRound();
        for (MonsterRow monsterRow : this.monsterRows) {
            monsterRow.turnEnd(true);
            monsterRow.roundEnd();
        }
        for (PlayerRow playerRow : this.playerRows) {
            playerRow.turnEnd(true);
            playerRow.roundEnd();
        }
        ++App.state.round;
        App.state.canDraw = true;
        this.sortByInitiative(0.5f);
        App.state.changed();
        this.rowsScroll.setScrollY(0.0f);
    }

    public void updateDrag(float stageX, float stageY) {
        if (!App.dragging) {
            return;
        }
        this.rows.stageToLocalCoordinates(App.v2.set(stageX, stageY));
        float x = App.v2.x;
        float y = App.v2.y;
        if (App.lastSwapRow != null && App.lastSwapRow.dragStartActor != null && (y < App.lastSwapRow.finalY + App.lastSwapRow.dragStartActor.getY() || y > App.lastSwapRow.finalY + App.lastSwapRow.getHeight() - (App.lastSwapRow.getHeight() - App.lastSwapRow.dragStartActor.getTop()) || Math.abs(x - App.lastSwapRow.finalX) > 550.0f)) {
            App.lastSwapRow = null;
        }
        if (App.lastSwapRow == null) {
            SnapshotArray<Actor> children = this.rows.getChildren();
            int current = App.dragRow.getZIndex();
            int i = 0;
            int n = children.size;
            while (i < n) {
                Row row = (Row)children.get(i);
                if (!(row == App.dragRow || App.config.hideMonsters && row instanceof MonsterRow)) {
                    boolean overHoriz;
                    float left = row.finalX;
                    float right = row.finalX + row.getWidth() * 0.8f;
                    boolean bl = overHoriz = this.rows.columns == 1 || x >= left && x < right;
                    if (overHoriz) {
                        float bottom = row.finalY;
                        float top = row.finalY + row.getHeight();
                        if (i == current - 1) {
                            bottom += row.dragStartActor.getY();
                        }
                        if (i == current + 1) {
                            top -= row.getHeight() - row.dragStartActor.getTop();
                        }
                        boolean swap = y > bottom && y < top;
                        boolean afterOrBefore = false;
                        if (!swap) {
                            if (this.isLast(children, i, row) && y < bottom) {
                                ++i;
                                swap = true;
                            } else if (this.isFirst(children, i, row) && y > top) {
                                i = Math.max(0, i - 1);
                                swap = true;
                            }
                        } else {
                            App.lastSwapRow = row;
                        }
                        if (swap) {
                            App.dragRow.setZIndex(i);
                            Animator.storeChildren(this.rows, 0.0f);
                            App.dragRow.getAnimator().finish(false);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.rows.columns == 1) {
            App.dragRow.setPosition(App.dragRow.finalX, y - App.dragStart.y);
        } else {
            App.dragRow.setPosition(x - App.dragStart.x, y - App.dragStart.y);
        }
    }

    private boolean isFirst(SnapshotArray<Actor> children, int i, Row row) {
        if (i == 0) {
            return true;
        }
        Row above = (Row)children.get(i - 1);
        if (above == App.dragRow) {
            if (i == 1) {
                return true;
            }
            above = (Row)children.get(i - 2);
        }
        return above.finalX != row.finalX;
    }

    private boolean isLast(SnapshotArray<Actor> children, int i, Row row) {
        int n = children.size;
        if (i == n - 1) {
            return true;
        }
        Row below = (Row)children.get(i + 1);
        if (below == App.dragRow) {
            if (i == n - 2) {
                return true;
            }
            below = (Row)children.get(i + 2);
        }
        return below.finalX != row.finalX;
    }

    public void addMonsterRow(MonsterRow row) {
        this.monsterRows.add(row);
        this.rows.addActor(row);
        App.root.validate();
    }

    public void setScenario(int scenarioNumber, int level, boolean solo, boolean addMonsters) {
        for (MonsterRow monsterRow : this.monsterRows) {
            monsterRow.remove();
        }
        this.monsterRows.clear();
        PlayerRow.localInit.clear();
        Iterator<PlayerRow> iterator = this.playerRows.iterator();
        while (iterator.hasNext()) {
            PlayerRow row = iterator.next();
            if (row.player.characterClass == CharacterClass.Escort || row.player.characterClass == CharacterClass.Objective) {
                row.remove();
                iterator.remove();
                continue;
            }
            row.boxes.clear();
            row.monstersGroup.clearChildren();
            row.player.init(0);
            row.turnComplete = false;
            if (row.player.characterClass != CharacterClass.BeastTyrant) continue;
            MonsterBox box = row.addMonsterBox(1, App.summonData, row.player.level, false, SummonColor.beast, false);
            box.monster.hp = box.monster.hpMax = 8 + row.player.level * 2;
            box.monster.summonMove = 3;
            box.monster.summonAttack = 2;
            box.monster.isNew = false;
        }
        if (scenarioNumber > 0) {
            Scenario scenario = App.scenarios.get(scenarioNumber - 1);
            if (addMonsters) {
                for (MonsterData data : scenario.monsters) {
                    int actualLevel = Math.min(7, level + (solo ? 1 : 0));
                    for (String special : scenario.special) {
                        if (special.equals("Living Corpse: +2 levels") && data.name.equals("Living Corpse")) {
                            actualLevel = Math.min(7, actualLevel + 2);
                        }
                        if (special.equals("Elite Stone Golem: +1 level, HPxC") && data.name.equals("Stone Golem")) {
                            actualLevel = Math.min(7, actualLevel + 1);
                        }
                        if (special.equals("Harrower Infester: +1 level") && data.name.equals("Harrower Infester")) {
                            actualLevel = Math.min(7, actualLevel + 1);
                        }
                        if (!special.equals("City Guard: +1 level") || !data.name.equals("City Guard")) continue;
                        actualLevel = Math.min(7, actualLevel + 1);
                    }
                    this.addMonsterRow(new MonsterRow(data, actualLevel));
                }
            }
            this.addSpecials(scenario.special, level);
        }
        this.scenarioLevelLabel.setText("");
        this.attackImage1.setDrawable(null);
        this.attackImage2.setDrawable(null);
        for (PlayerRow playerRow : this.playerRows) {
            playerRow.player.hp = playerRow.player.hpMax;
            playerRow.player.xp = 0;
            playerRow.player.loot = 0;
            playerRow.player.conditions.clear();
            playerRow.player.expiredConditions.clear();
            playerRow.player.currentTurnConditions.clear();
        }
        App.state.abilityDecks.clear();
        App.state.removedAbilities.clear();
        App.state.badOmen = 0;
        App.state.round = 1;
        App.state.scenarioNumber = scenarioNumber;
        App.state.scenarioLevel = level;
        App.state.solo = solo;
        App.state.canDraw = true;
        App.state.needsShuffle = false;
        App.state.attackModifiers.clear();
        App.state.shuffleAttackModifiers(false);
        App.state.fire = ElementState.inert;
        App.state.ice = ElementState.inert;
        App.state.air = ElementState.inert;
        App.state.earth = ElementState.inert;
        App.state.light = ElementState.inert;
        App.state.dark = ElementState.inert;
        App.state.apply(false);
        App.state.changed();
    }

    public void setScenarioLevel(int level, boolean solo) {
        Scenario scenario = null;
        if (App.state.scenarioNumber > 0) {
            scenario = App.scenarios.get(App.state.scenarioNumber - 1);
        }
        App.state.scenarioLevel = level;
        for (MonsterRow row : this.monsterRows) {
            int actualLevel = Math.min(7, level + (solo ? 1 : 0));
            if (scenario != null) {
                for (MonsterData data : scenario.monsters) {
                    if (row.data != data) continue;
                    for (String special : scenario.special) {
                        if (special.equals("Living Corpse: +2 levels") && data.name.equals("Living Corpse")) {
                            actualLevel = Math.min(7, actualLevel + 2);
                        }
                        if (special.equals("Elite Stone Golem: +1 level, HPxC") && data.name.equals("Stone Golem")) {
                            actualLevel = Math.min(7, actualLevel + 1);
                        }
                        if (special.equals("Harrower Infester: +1 level") && data.name.equals("Harrower Infester")) {
                            actualLevel = Math.min(7, actualLevel + 1);
                        }
                        if (!special.equals("City Guard: +1 level") || !data.name.equals("City Guard")) continue;
                        actualLevel = Math.min(7, actualLevel + 1);
                    }
                }
            }
            row.setLevel(actualLevel);
        }
    }

    public void addSection(Scenario section) {
        int level = App.state.scenarioLevel;
        for (MonsterData data : section.monsters) {
            int actualLevel = Math.min(7, level + (this.solo ? 1 : 0));
            if (this.getMonsterRow(data) != null) continue;
            this.addMonsterRow(new MonsterRow(data, actualLevel));
        }
        for (String special : section.special) {
            if (!special.equals("Valrath Tracker: %target% C, %pierce% 10, Vermling Shaman: CxH/2, City Guard: CxH/2, Savvas Lavaflow: CxH/2")) continue;
            MonsterRow monsterRow = this.getMonsterRow("Vermling Shaman");
        }
        this.addSpecials(section.special, level);
    }

    private void addSpecials(Array<String> specials, int level) {
        Player last = null;
        for (String special : specials) {
            boolean escort = special.startsWith("Escort: ");
            if (escort || special.startsWith("Objective: ")) {
                String name = special.substring(escort ? 8 : 11);
                Player player = this.getPlayer(name);
                if (player != null) {
                    last = player;
                    continue;
                }
                player = new Player();
                player.level = level;
                player.name = name;
                player.characterClass = escort ? CharacterClass.Escort : CharacterClass.Objective;
                player.hp = player.hpMax = player.characterClass.hpMax(level);
                last = player;
                PlayerRow row = new PlayerRow(player);
                this.playerRows.add(row);
                this.rows.addActor(row);
                continue;
            }
            if (last == null) continue;
            if (special.equals("4+2xL")) {
                last.hp = last.hpMax = 4 + 2 * level;
                continue;
            }
            if (special.equals("6+2xL")) {
                last.hp = last.hpMax = 6 + 2 * level;
                continue;
            }
            if (special.equals("C+L+1")) {
                last.hp = last.hpMax = this.playerCount() + level + 1;
                continue;
            }
            if (special.equals("Cx2+L")) {
                last.hp = last.hpMax = 2 * this.playerCount() + level;
                continue;
            }
            if (special.equals("Cx2+L+4")) {
                last.hp = last.hpMax = 2 * this.playerCount() + level + 4;
                continue;
            }
            if (special.equals("2x(C+L)+3")) {
                last.hp = last.hpMax = 2 * (this.playerCount() + level) + 3;
                continue;
            }
            if (special.equals("5+L+2xC")) {
                last.hp = last.hpMax = 5 + level + 2 * this.playerCount();
                continue;
            }
            if (!special.equals("20+L+2xC")) continue;
            last.hp = last.hpMax = 20 + level + 2 * this.playerCount();
        }
    }

    public void sortByInitiative(float delay) {
        this.rows.getChildren().sort();
        Animator.storeChildren(this.rows, delay);
        this.roundButton.setDisabled(true);
        this.drawButton.setDisabled(true);
        this.rows.addAction(Actions.sequence((Action)Actions.delay(delay + 0.5f), new Action(){

            @Override
            public boolean act(float delta) {
                GloomhavenHelper.this.roundButton.setDisabled(false);
                GloomhavenHelper.this.drawButton.setDisabled(false);
                return true;
            }
        }));
    }

    boolean turnsFinished() {
        for (MonsterRow monsterRow : this.monsterRows) {
            if (!monsterRow.isAlive() && App.state.trackStandees || monsterRow.turnComplete) continue;
            return false;
        }
        for (PlayerRow playerRow : this.playerRows) {
            if (playerRow.turnComplete || !playerRow.isAlive()) continue;
            return false;
        }
        return true;
    }

    boolean playerInitiativeSet() {
        for (PlayerRow row : this.playerRows) {
            if (row.player.init != 0 || !row.isAlive()) continue;
            return false;
        }
        return true;
    }

    public void zoomIn() {
        float height = Math.max(700.0f, App.viewport.getMinWorldHeight() - 5.0f);
        float max = Gdx.graphics.getHeight() * 1113 / Gdx.graphics.getWidth();
        height = Math.max(height, max);
        App.viewport.setMinWorldHeight(height);
        this.updateViewport();
        this.updateTextures();
        Gdx.graphics.requestRendering();
        App.config.zoom = height;
        App.config.zoomReset = false;
        App.game.saveConfig();
    }

    public void zoomOut() {
        float height = App.viewport.getMinWorldHeight() + 5.0f;
        height = Math.max(height, (float)(Gdx.graphics.getHeight() * 1113 / Gdx.graphics.getWidth()));
        App.viewport.setMinWorldHeight(height);
        this.updateViewport();
        this.updateTextures();
        Gdx.graphics.requestRendering();
        App.config.zoom = height;
        App.config.zoomReset = false;
        App.game.saveConfig();
    }

    @Override
    public void render() {
        long time = System.currentTimeMillis();
        if (Gdx.input.isKeyPressed(19) || this.zoomIn) {
            Gdx.graphics.requestRendering();
            if (System.currentTimeMillis() - this.lastZoomTime > 16L) {
                this.lastZoomTime = System.currentTimeMillis();
                this.zoomIn();
            }
        } else if (Gdx.input.isKeyPressed(20) || this.zoomOut) {
            Gdx.graphics.requestRendering();
            if (System.currentTimeMillis() - this.lastZoomTime > 16L) {
                this.lastZoomTime = System.currentTimeMillis();
                this.zoomOut();
            }
        }
        TooltipManager.getInstance().enabled = App.config.help;
        float delta = Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f);
        this.intro.update(delta);
        boolean hasPlayers = this.playerCount() > 0;
        boolean hasMonsterRows = this.monsterRows.size > 0;
        boolean turnsFinished = this.turnsFinished();
        boolean hasMonsters = false;
        if (!App.state.trackStandees) {
            hasMonsters = true;
        } else {
            for (MonsterRow row : this.monsterRows) {
                if (row.boxes.size <= 0) continue;
                hasMonsters = true;
                break;
            }
        }
        boolean canDraw = App.state.canDraw;
        if (this.scenarioLevelLabel.setText(App.state.scenarioLevel) || this.solo != App.state.solo || this.scenarioNumber != App.state.scenarioNumber) {
            this.scenarioNumber = App.state.scenarioNumber;
            this.solo = App.state.solo;
            int level = App.state.scenarioLevel;
            this.trapsLabel.setText(2 + level + (App.state.solo ? 1 : 0));
            this.coinsLabel.setText("x" + (level == 7 ? 6 : 2 + level / 2));
            this.xpLabel.setText("+" + (4 + level * 2));
            if (App.state.scenarioNumber <= 0) {
                this.scenarioLabel.setText("");
            } else {
                this.scenarioLabel.setText(App.scenarios.get((int)(App.state.scenarioNumber - 1)).name);
            }
        }
        this.roundLabel.setText(App.state.round);
        this.attackLabel.setText(App.state.attackModifiers.size);
        boolean wasDrawVisible = this.drawButton.hasParent();
        if (!hasMonsterRows) {
            this.drawButton.remove();
            this.roundButton.remove();
        } else if (canDraw) {
            this.nextButtonStack.addActorAt(0, this.drawButton);
            this.roundButton.remove();
        } else {
            this.nextButtonStack.addActorAt(0, this.roundButton);
            this.drawButton.remove();
        }
        boolean drawVisible = this.drawButton.hasParent();
        if (!wasDrawVisible && drawVisible) {
            this.drawTask.cancel();
            Timer.schedule(this.drawTask, 60.0f, 60.0f);
            this.drawMinutes = 0;
        } else if (wasDrawVisible && !drawVisible) {
            this.drawTask.cancel();
        }
        this.attackButton.setVisible(hasMonsterRows);
        this.attackImage1.setVisible(hasMonsterRows);
        this.attackImage2.setVisible(hasMonsterRows);
        this.attackLabel.setVisible(hasMonsterRows);
        this.roundLabel.setVisible(hasMonsterRows);
        this.elementsTable.setVisible(hasMonsterRows);
        this.scenarioTable.setVisible(App.state.scenarioNumber >= 0);
        this.helpCell.width(Value.prefWidth);
        if (!hasMonsterRows && !hasPlayers) {
            this.helpCell.setActor(this.helpAddPlayers).left();
        } else if (!hasMonsterRows) {
            this.helpCell.setActor(this.helpSetScenarioOrAddMonsters).left().width(0.0f);
        } else if (!App.config.help) {
            this.helpCell.setActor(null);
        } else if (canDraw) {
            if (App.state.round == 1 && !hasMonsters) {
                this.helpCell.setActor(this.helpSpawnMonsters).center();
            } else if (App.state.round == 1) {
                this.helpCell.setActor(this.helpChooseCards1).center().width(0.0f);
            } else if (App.state.round == 2) {
                this.helpCell.setActor(this.helpChooseCards2).center();
            } else {
                this.helpCell.setActor(this.helpChooseCards3).center();
            }
        } else if (turnsFinished && App.state.round < 2) {
            this.helpCell.setActor(this.helpNextRound1).center();
        } else if (turnsFinished) {
            this.helpCell.setActor(this.helpNextRound2).center();
        } else if (App.state.round == 1) {
            this.helpCell.setActor(this.helpTakeTurns1).center().width(0.0f);
        } else if (App.state.round == 2) {
            this.helpCell.setActor(this.helpTakeTurns2).center();
        } else {
            this.helpCell.setActor(this.helpTakeTurns3).center();
        }
        if (App.config.client) {
            this.networkCell.setActor(Network.clientRunning() ? (Network.clientIsConnected() ? this.networkConnected : this.networkDisconnected) : null);
        } else if (App.config.server) {
            this.networkCell.setActor(Network.serverRunning() ? (Network.serverHasClient() ? this.networkServerGreen : this.networkServerGray) : null);
        } else {
            this.networkCell.setActor(null);
        }
        App.rippleSkeletonPool.freeComplete();
        this.toasts.toFront();
        Gdx.gl.glClear(16384);
        App.stage.act(delta);
        App.stage.draw();
    }

    public boolean hasCharacterClass(CharacterClass characterClass) {
        for (PlayerRow row : this.playerRows) {
            if (row.player.characterClass != characterClass) continue;
            return true;
        }
        return false;
    }

    public boolean hasCharacters() {
        for (PlayerRow row : this.playerRows) {
            if (row.player.characterClass == CharacterClass.Escort || row.player.characterClass == CharacterClass.Objective) continue;
            return true;
        }
        return false;
    }

    public MonsterRow getMonsterRow(MonsterData data) {
        for (MonsterRow row : this.monsterRows) {
            if (row.data != data) continue;
            return row;
        }
        return null;
    }

    public MonsterRow getMonsterRow(String name) {
        for (MonsterRow row : this.monsterRows) {
            if (!row.data.name.equals(name)) continue;
            return row;
        }
        return null;
    }

    public Player getPlayer(String name) {
        for (PlayerRow row : this.playerRows) {
            if (!row.player.name.equals(name)) continue;
            return row.player;
        }
        return null;
    }

    @Override
    public void resize(int width, int height) {
        Gdx.graphics.requestRendering();
        if (width == 0 || height == 0) {
            return;
        }
        if (App.config.zoomReset) {
            App.viewport.setMinWorldHeight(Math.max(Gdx.graphics.getHeight(), 800));
        }
        this.updateViewport();
        this.updateTextures();
    }

    public void updateViewport() {
        Game.Insets insets = App.game.getInsets();
        int top = (int)insets.top;
        int left = (int)insets.left;
        int bottom = (int)insets.bottom;
        int right = (int)insets.right;
        App.viewport.update(Gdx.graphics.getWidth() - left - right, Gdx.graphics.getHeight() - top - bottom, true);
        App.viewport.setScreenX(App.viewport.getScreenX() + left);
        App.viewport.setScreenY(App.viewport.getScreenY() + bottom);
        HdpiUtils.glViewport(App.viewport.getScreenX(), App.viewport.getScreenY(), App.viewport.getScreenWidth(), App.viewport.getScreenHeight());
    }

    public void updateTextures() {
        Texture.TextureFilter filter = this.nearest() ? Texture.TextureFilter.Nearest : Texture.TextureFilter.Linear;
        for (Texture texture : App.textures) {
            texture.setFilter(filter, filter);
        }
        if (this.intro.introPhase >= 0 && this.intro.introPhase <= 4) {
            App.atlas.findRegion("esoteric/logo").getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    public boolean nearest() {
        return App.viewport.getScreenWidth() >= 1113 && App.viewport.getMinWorldHeight() == (float)App.viewport.getScreenHeight();
    }

    public int playerCount() {
        int count = 0;
        for (PlayerRow row : this.playerRows) {
            if (row.player.characterClass == CharacterClass.Escort || row.player.characterClass == CharacterClass.Objective) continue;
            ++count;
        }
        return count;
    }
}

