/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import org.junit.Assert;
import org.junit.Test;

public class IntersectorTest {
    private static boolean triangleEquals(float[] base, int baseOffset, int stride, float[] comp) {
        int b;
        Assert.assertTrue((stride >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((base.length - baseOffset >= 9 ? 1 : 0) != 0);
        Assert.assertTrue((comp.length == 9 ? 1 : 0) != 0);
        int offset = -1;
        int i = 0;
        while (i < 3) {
            b = baseOffset + i * stride;
            if (MathUtils.isEqual(base[b], comp[0]) && MathUtils.isEqual(base[b + 1], comp[1]) && MathUtils.isEqual(base[b + 2], comp[2])) {
                offset = i;
                break;
            }
            ++i;
        }
        Assert.assertTrue((String)"Triangles do not have common first vertex.", (offset != -1 ? 1 : 0) != 0);
        i = 0;
        while (i < 3) {
            b = baseOffset + (offset + i) * stride % (3 * stride);
            int c = i * stride;
            if (!(MathUtils.isEqual(base[b], comp[c]) && MathUtils.isEqual(base[b + 1], comp[c + 1]) && MathUtils.isEqual(base[b + 2], comp[c + 2]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Test
    public void testSplitTriangle() {
        Plane plane = new Plane(new Vector3(1.0f, 0.0f, 0.0f), 0.0f);
        Intersector.SplitTriangle split = new Intersector.SplitTriangle(3);
        float[] fTriangle = new float[]{-10.0f, 0.0f, 10.0f, -1.0f, 0.0f, 0.0f, -12.0f, 0.0f, 10.0f};
        Intersector.splitTriangle(fTriangle, plane, split);
        Assert.assertTrue((split.numBack == 1 ? 1 : 0) != 0);
        Assert.assertTrue((split.numFront == 0 ? 1 : 0) != 0);
        Assert.assertTrue((split.total == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)IntersectorTest.triangleEquals(split.back, 0, 3, fTriangle));
        fTriangle[4] = 5.0f;
        Assert.assertFalse((String)"Test is broken", (boolean)IntersectorTest.triangleEquals(split.back, 0, 3, fTriangle));
        fTriangle = new float[]{10.0f, 0.0f, 10.0f, 1.0f, 0.0f, 0.0f, 12.0f, 0.0f, 10.0f};
        Intersector.splitTriangle(fTriangle, plane, split);
        Assert.assertTrue((split.numBack == 0 ? 1 : 0) != 0);
        Assert.assertTrue((split.numFront == 1 ? 1 : 0) != 0);
        Assert.assertTrue((split.total == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)IntersectorTest.triangleEquals(split.front, 0, 3, fTriangle));
        float[] triangle = new float[]{-10.0f, 0.0f, 10.0f, 10.0f, 0.0f, 0.0f, -10.0f, 0.0f, -10.0f};
        Intersector.splitTriangle(triangle, plane, split);
        Assert.assertTrue((split.numBack == 2 ? 1 : 0) != 0);
        Assert.assertTrue((split.numFront == 1 ? 1 : 0) != 0);
        Assert.assertTrue((split.total == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)IntersectorTest.triangleEquals(split.front, 0, 3, new float[]{0.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, -5.0f}));
        float[][] firstWay = new float[][]{{-10.0f, 0.0f, 10.0f, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, -5.0f}, {-10.0f, 0.0f, 10.0f, 0.0f, 0.0f, -5.0f, -10.0f, 0.0f, -10.0f}};
        float[][] secondWay = new float[][]{{-10.0f, 0.0f, 10.0f, 0.0f, 0.0f, 5.0f, -10.0f, 0.0f, -10.0f}, {0.0f, 0.0f, 5.0f, 0.0f, 0.0f, -5.0f, -10.0f, 0.0f, -10.0f}};
        float[] base = split.back;
        boolean first = IntersectorTest.triangleEquals(base, 0, 3, firstWay[0]) && IntersectorTest.triangleEquals(base, 9, 3, firstWay[1]) || IntersectorTest.triangleEquals(base, 0, 3, firstWay[1]) && IntersectorTest.triangleEquals(base, 9, 3, firstWay[0]);
        boolean second = IntersectorTest.triangleEquals(base, 0, 3, secondWay[0]) && IntersectorTest.triangleEquals(base, 9, 3, secondWay[1]) || IntersectorTest.triangleEquals(base, 0, 3, secondWay[1]) && IntersectorTest.triangleEquals(base, 9, 3, secondWay[0]);
        Assert.assertTrue((String)("Either first or second way must be right (first: " + first + ", second: " + second + ")"), (boolean)(first ^ second));
        triangle = new float[]{10.0f, 0.0f, 10.0f, -10.0f, 0.0f, 0.0f, 10.0f, 0.0f, -10.0f};
        Intersector.splitTriangle(triangle, plane, split);
        Assert.assertTrue((split.numBack == 1 ? 1 : 0) != 0);
        Assert.assertTrue((split.numFront == 2 ? 1 : 0) != 0);
        Assert.assertTrue((split.total == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)IntersectorTest.triangleEquals(split.back, 0, 3, new float[]{0.0f, 0.0f, 5.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, -5.0f}));
        firstWay = new float[][]{{10.0f, 0.0f, 10.0f, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, -5.0f}, {10.0f, 0.0f, 10.0f, 0.0f, 0.0f, -5.0f, 10.0f, 0.0f, -10.0f}};
        secondWay = new float[][]{{10.0f, 0.0f, 10.0f, 0.0f, 0.0f, 5.0f, 10.0f, 0.0f, -10.0f}, {0.0f, 0.0f, 5.0f, 0.0f, 0.0f, -5.0f, 10.0f, 0.0f, -10.0f}};
        base = split.front;
        first = IntersectorTest.triangleEquals(base, 0, 3, firstWay[0]) && IntersectorTest.triangleEquals(base, 9, 3, firstWay[1]) || IntersectorTest.triangleEquals(base, 0, 3, firstWay[1]) && IntersectorTest.triangleEquals(base, 9, 3, firstWay[0]);
        second = IntersectorTest.triangleEquals(base, 0, 3, secondWay[0]) && IntersectorTest.triangleEquals(base, 9, 3, secondWay[1]) || IntersectorTest.triangleEquals(base, 0, 3, secondWay[1]) && IntersectorTest.triangleEquals(base, 9, 3, secondWay[0]);
        Assert.assertTrue((String)("Either first or second way must be right (first: " + first + ", second: " + second + ")"), (boolean)(first ^ second));
    }
}

