/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLUtil {
    private XMLUtil() {
    }

    public static void printXML(StringBuffer stringBuffer, String string) {
        XMLUtil.printXML(stringBuffer, string, true);
    }

    public static void printXML(StringBuffer stringBuffer, String string, boolean bl) {
        if (string == null) {
            return;
        }
        XMLUtil.appendLine(stringBuffer, string, bl);
    }

    public static void printXML(StringBuffer stringBuffer, char c, boolean bl) {
        if (c == '&') {
            stringBuffer.append("&amp;");
        } else if (c == '<') {
            stringBuffer.append("&lt;");
        } else if (c == '>') {
            stringBuffer.append("&gt;");
        } else if (bl) {
            if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA");
            } else if (c == '\t') {
                stringBuffer.append("&#x9");
            } else {
                stringBuffer.append(c);
            }
        } else {
            stringBuffer.append(c);
        }
    }

    public static void writeXML(Writer writer, String string) throws IOException {
        XMLUtil.writeXML(writer, string, true);
    }

    public static void writeXML(Writer writer, String string, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        XMLUtil.appendLine(writer, string, bl);
    }

    public static void writeXML(Writer writer, char c, boolean bl) throws IOException {
        if (c == '&') {
            writer.write("&amp;");
        } else if (c == '<') {
            writer.write("&lt;");
        } else if (c == '>') {
            writer.write("&gt;");
        } else if (bl) {
            if (c == '\"') {
                writer.write("&quot;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\n') {
                writer.write("&#xA;");
            } else if (c == '\t') {
                writer.write("&#x9;");
            } else {
                writer.write(c);
            }
        } else {
            writer.write(c);
        }
    }

    public static boolean shouldEscape(char c) {
        if (c == '&') {
            return true;
        }
        if (c == '<') {
            return true;
        }
        return c == '>';
    }

    public static boolean shouldEscape(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!XMLUtil.shouldEscape(c)) continue;
            return true;
        }
        return false;
    }

    public static void printXML(Writer writer, String string) throws IOException {
        XMLUtil.printXML(writer, string, true);
    }

    public static void printXML(Writer writer, String string, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        XMLUtil.appendLine(writer, string, bl);
    }

    private static void appendLine(StringBuffer stringBuffer, String string, boolean bl) {
        stringBuffer.append(XMLUtil.convertChars(string, bl));
    }

    private static void appendLine(Writer writer, String string, boolean bl) throws IOException {
        writer.write(XMLUtil.convertChars(string, bl));
    }

    private static String convertChars(String string, boolean bl) {
        String string2 = string;
        if (string.indexOf("&") >= 0) {
            string2 = string2.replaceAll("&", "&amp;");
        }
        if (string.indexOf("<") >= 0) {
            string2 = string2.replaceAll("<", "&lt;");
        }
        if (string.indexOf(">") >= 0) {
            string2 = string2.replaceAll(">", "&gt;");
        }
        if (bl) {
            if (string.indexOf("\"") >= 0) {
                string2 = string2.replaceAll("\"", "&quot;");
            }
            if (string.indexOf("'") >= 0) {
                string2 = string2.replaceAll("'", "&apos;");
            }
            if (string.indexOf("\n") >= 0) {
                string2 = string2.replaceAll("\n", "&#xA");
            }
            if (string.indexOf("\t") >= 0) {
                string2 = string2.replaceAll("\t", "&#x9");
            }
        }
        return string2;
    }

    public static void printXML(Writer writer, char c, boolean bl) throws IOException {
        if (c == '&') {
            writer.write("&amp;");
        } else if (c == '<') {
            writer.write("&lt;");
        } else if (c == '>') {
            writer.write("&gt;");
        } else if (bl) {
            if (c == '\"') {
                writer.write("&quot;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\n') {
                writer.write("&#xA;");
            } else if (c == '\t') {
                writer.write("&#x9;");
            } else {
                writer.write(c);
            }
        } else {
            writer.write(c);
        }
    }

    protected static String getDocTypeName(Document document) {
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof DocumentType)) continue;
            DocumentType documentType = (DocumentType)node;
            return documentType.getName();
        }
        Element element = document.getDocumentElement();
        return element.getNodeName();
    }

    public static void reindent(Document document, String string) {
        XMLUtil.reindent(document, document, -1, string);
    }

    public static boolean reindent(Document document, Node node, int n, String string) {
        String string2 = node.getNodeValue();
        boolean bl = true;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            if (XMLUtil.reindent(document, nodeList.item(i), n + 1, string)) continue;
            bl = false;
        }
        if (bl && n >= 0 && n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            XMLUtil.printLevel(stringBuffer, n, string);
            String string3 = "\n" + stringBuffer.toString().intern();
            XMLUtil.printLevel(stringBuffer, 1, string);
            String string4 = "\n" + stringBuffer.toString().intern();
            if (n2 > 1 && !(nodeList.item(n2 - 1) instanceof Text)) {
                node.appendChild(document.createTextNode(string3));
                ++n2;
            }
            boolean bl2 = true;
            for (int i = 0; i < n2; ++i) {
                Text text;
                String string5;
                Node node2 = nodeList.item(i);
                boolean bl3 = node2 instanceof Text;
                if (bl2) {
                    if (bl3) {
                        string5 = node2.getNodeValue().intern();
                        if (n2 == 1) continue;
                        text = (Text)node2;
                        if (i == n2 - 1) {
                            if (string3 != string5) {
                                if (text.getLength() > 0) {
                                    text.deleteData(0, text.getLength());
                                }
                                text.appendData(string3);
                            }
                        } else if (string4 != string5) {
                            text.deleteData(0, text.getLength());
                            text.appendData(string4);
                        }
                        bl2 ^= true;
                        continue;
                    }
                    if (i == n2 - 1) {
                        node.insertBefore(document.createTextNode(string4), node2);
                        node.appendChild(document.createTextNode(string3));
                        ++n2;
                    } else {
                        node.insertBefore(document.createTextNode(string4), node2);
                    }
                    ++i;
                    ++n2;
                    continue;
                }
                if (bl3) {
                    node.removeChild(node2);
                    if (--i != --n2 - 1 || i < 0 || string3 == (string5 = (node2 = nodeList.item(i)).getNodeValue().intern())) continue;
                    text = (Text)node2;
                    if (text.getLength() > 0) {
                        text.deleteData(0, text.getLength());
                    }
                    text.appendData(string3);
                    continue;
                }
                bl2 ^= true;
            }
        }
        if (node instanceof Text) {
            if (string2 == null) {
                return true;
            }
            return string2.trim().equals("");
        }
        return true;
    }

    protected static void printLevel(StringBuffer stringBuffer, int n, String string) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
    }

    public static Locator findLocationXPath(InputSource inputSource, String string) throws IOException, SAXException {
        XMLReader xMLReader;
        Object object;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        object = new XPathLocator(string);
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.parse(inputSource);
        return ((XPathLocator)object).getDocumentLocator();
    }

    public static boolean isAttrContent(int n) {
        if (n < 9) {
            return false;
        }
        return n <= 9 || n >= 32;
    }

    public static class DOMWriter {
        private Writer out;
        private boolean writeCData = false;
        private String docTypePublic;
        private String docTypeSystem;

        public void setWriter(Writer writer) {
            this.out = writer;
        }

        public void setWriteCData(boolean bl) {
            this.writeCData = bl;
        }

        public void setDocTypePublic(String string) {
            this.docTypePublic = string;
        }

        public void setDocTypeSystem(String string) {
            this.docTypeSystem = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File file, Document document) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this.write(fileOutputStream, document);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }

        public void write(OutputStream outputStream, Document document) throws IOException {
            this.write(outputStream, null, document);
        }

        public void write(OutputStream outputStream, String string, Document document) throws IOException {
            if (string == null) {
                string = "UTF-8";
            }
            this.out = new BufferedWriter(new OutputStreamWriter(outputStream, string));
            this.write(document, string);
        }

        public void write(Document document) throws IOException {
            this.write(document, null);
        }

        public void write(Document document, String string) throws IOException {
            this.write(document, string, true);
        }

        public void write(Document document, String string, boolean bl) throws IOException {
            Node node;
            int n;
            Object object;
            if (bl) {
                this.out.write("<?xml version=\"1.0\"");
                if (string != null) {
                    this.out.write(" encoding=\"" + string + "\"?>\n");
                } else {
                    this.out.write(" encoding=\"UTF-8\"?>\n");
                }
            }
            if (this.docTypePublic != null || this.docTypeSystem != null) {
                object = XMLUtil.getDocTypeName(document);
                DocumentType documentType = document.getDoctype();
                NamedNodeMap namedNodeMap = null;
                if (documentType != null) {
                    namedNodeMap = documentType.getEntities();
                }
                this.write((String)object, this.docTypePublic, this.docTypeSystem, namedNodeMap);
                this.out.write("\n");
            }
            object = document.getChildNodes();
            int n2 = object.getLength();
            for (n = 0; n < n2; ++n) {
                node = object.item(n);
                if (!(node instanceof DocumentType)) continue;
                this.write(node);
                this.out.write("\n");
            }
            for (n = 0; n < n2; ++n) {
                node = object.item(n);
                if (node instanceof DocumentType) continue;
                this.write(node);
                this.out.write("\n");
            }
            this.out.flush();
        }

        public void write(Node node) throws IOException {
            boolean bl = false;
            NodeList nodeList = node.getChildNodes();
            if (node instanceof Element) {
                this.out.write("<" + node.getNodeName());
                this.write(node.getAttributes());
                if (nodeList.getLength() == 0 || nodeList.getLength() == 1 && nodeList.item(0) instanceof Text && "".equals(nodeList.item(0).getNodeValue())) {
                    this.out.write("/>");
                    return;
                }
                this.out.write(">");
            } else if (node instanceof Text) {
                this.printXML(node.getNodeValue(), false);
            } else if (node instanceof Document) {
                bl = true;
            } else if (node instanceof DocumentType) {
                this.write((DocumentType)node);
            } else if (node instanceof Comment) {
                this.write((Comment)node);
            } else if (node instanceof Entity) {
                this.write((Entity)node);
            } else if (node instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)node);
            } else {
                System.err.println("! schema2beans found unknown node type in DOM graph:");
                System.err.println("write: node.getClass=" + node.getClass() + " node=" + node);
                System.err.println("write: nodename=" + node.getNodeName() + " nodevalue=" + node.getNodeValue());
                System.err.println("write: getAttributes=" + node.getAttributes());
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.write(nodeList.item(i));
                if (!bl) continue;
                this.out.write("\n");
            }
            if (node instanceof Element) {
                this.out.write("</" + node.getNodeName() + ">");
            }
        }

        protected void write(DocumentType documentType) throws IOException {
            if (this.docTypePublic != null || this.docTypeSystem != null) {
                return;
            }
            this.write(documentType.getName(), documentType.getPublicId(), documentType.getSystemId(), documentType.getEntities());
        }

        protected void write(String string, String string2, String string3, NamedNodeMap namedNodeMap) throws IOException {
            int n;
            this.out.write("<!DOCTYPE " + string);
            if (string2 != null) {
                this.out.write(" PUBLIC \"");
                XMLUtil.printXML(this.out, string2);
                this.out.write("\"");
                if (string3 == null) {
                    string3 = "SYSTEM";
                }
            }
            if (string3 != null) {
                this.out.write(" \"");
                XMLUtil.printXML(this.out, string3);
                this.out.write("\"");
            }
            if (namedNodeMap != null && (n = namedNodeMap.getLength()) > 0) {
                this.out.write(" [");
                for (int i = 0; i < n; ++i) {
                    Node node = namedNodeMap.item(i);
                    this.write(node);
                }
                this.out.write("]");
            }
            this.out.write(">");
        }

        protected void write(Comment comment) throws IOException {
            this.out.write("<!--");
            String string = comment.getNodeValue();
            int n = string.indexOf("--");
            while (n >= 0) {
                this.out.write(string.substring(0, n));
                this.out.write("&#x2d;&#x2d;");
                string = string.substring(n + 2, string.length());
                n = string.indexOf("--");
            }
            this.out.write(string);
            this.out.write("-->");
        }

        protected void write(Entity entity) throws IOException {
            this.out.write("<!ENTITY " + entity.getNodeName());
            this.out.write(" UNKNOWN>");
        }

        protected void write(ProcessingInstruction processingInstruction) throws IOException {
            if ("xml".equals(processingInstruction.getTarget())) {
                return;
            }
            this.out.write("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
        }

        protected void write(NamedNodeMap namedNodeMap) throws IOException {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = namedNodeMap.item(i);
                this.out.write(" ");
                this.out.write(node.getNodeName());
                this.out.write("=\"");
                XMLUtil.printXML(this.out, node.getNodeValue());
                this.out.write("\"");
            }
        }

        protected void printXML(String string, boolean bl) throws IOException {
            if (this.writeCData && string.indexOf("]]>") < 0) {
                boolean bl2 = XMLUtil.shouldEscape(string);
                if (bl2) {
                    this.out.write("<![CDATA[");
                }
                this.out.write(string);
                if (bl2) {
                    this.out.write("]]>");
                }
            } else {
                XMLUtil.printXML(this.out, string, bl);
            }
        }
    }

    private static class XPathLocator
    extends DefaultHandler
    implements ContentHandler {
        private String xpathExpr;
        private String[] xpathParts;
        private int partNum;
        private String desiredElementName;
        private int desiredPosition;
        private boolean isAttribute;
        private Locator locator = null;
        private Locator resultLocator = null;

        public XPathLocator(String string) {
            string = string.trim();
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            this.xpathExpr = string;
            this.xpathParts = string.split("/");
            this.partNum = 0;
            this.setElementName();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setElementName() {
            this.desiredElementName = this.xpathParts[this.partNum].trim();
            this.desiredPosition = 0;
            this.isAttribute = false;
            int n = this.desiredElementName.indexOf(91);
            int n2 = this.desiredElementName.indexOf(93);
            if (n >= 0) {
                if (n2 < 0) {
                    throw new IllegalArgumentException("XPath subexpression (" + this.desiredElementName + ") is missing an ending ']'.");
                }
                String string = this.desiredElementName.substring(n + 1, n2).trim();
                this.desiredElementName = this.desiredElementName.substring(0, n);
                if (string.startsWith("position()=")) {
                    this.desiredPosition = Integer.parseInt(string.substring(11, string.length()));
                    return;
                } else {
                    boolean bl = string.length() > 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (Character.isDigit(string.charAt(i))) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) throw new UnsupportedOperationException("XPath (" + string + " in " + this.xpathExpr + ") not supported.");
                    this.desiredPosition = Integer.parseInt(string);
                }
                return;
            } else {
                if (!this.desiredElementName.startsWith("@")) return;
                this.isAttribute = true;
                this.desiredElementName = this.desiredElementName.substring(1, this.desiredElementName.length());
            }
        }

        private boolean foundGotoNext() {
            ++this.partNum;
            if (this.partNum >= this.xpathParts.length) {
                this.resultLocator = new LocatorImpl(this.locator);
                return true;
            }
            this.setElementName();
            return false;
        }

        public Locator getDocumentLocator() {
            return this.resultLocator;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.resultLocator != null) {
                return;
            }
            if (this.desiredElementName.equals(string2) || this.desiredElementName.equals(string3)) {
                if (this.desiredPosition == 0) {
                    if (!this.foundGotoNext() && this.isAttribute) {
                        int n = attributes.getLength();
                        for (int i = 0; i < n; ++i) {
                            if (!this.desiredElementName.equals(attributes.getLocalName(i)) && !this.desiredElementName.equals(attributes.getQName(i))) continue;
                            this.foundGotoNext();
                            return;
                        }
                    }
                } else {
                    --this.desiredPosition;
                }
            }
        }
    }
}

