/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.servlet.DefaultTrustManager;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLinkTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;

class HelperThread
extends Thread {
    private ServerSocket ss = null;
    private ServerLinkTable parent;
    private String servletName = null;
    private boolean closed = false;

    public HelperThread(int n, String string, int n2, ServerLinkTable serverLinkTable) throws IOException {
        this.parent = serverLinkTable;
        this.closed = false;
        this.ss = this.createServerSocket(null, n, string);
        try {
            this.ss.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            this.parent.servletContext.log("WARNING: HttpTunnelTcpListener[" + this.ss.toString() + "]setSoTimeout(" + 5000 + "): " + socketException.toString());
        }
        if (n2 > 0) {
            try {
                this.ss.setReceiveBufferSize(n2);
            }
            catch (SocketException socketException) {
                this.parent.servletContext.log("WARNING: HttpTunnelTcpListener[" + this.ss.toString() + "]setReceiveBufferSize(" + n2 + "): " + socketException.toString());
            }
        }
        this.setName("HttpTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + n + " ...");
    }

    public HelperThread(int n, String string, int n2, String string2, String string3, ServerLinkTable serverLinkTable) throws IOException {
        this.parent = serverLinkTable;
        this.closed = false;
        SSLServerSocketFactory sSLServerSocketFactory = this.getServerSocketFactory(string2, string3);
        this.ss = this.createServerSocket(sSLServerSocketFactory, n, string);
        try {
            this.ss.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            this.parent.servletContext.log("WARNING: HttpsTunnelTcpListener[" + this.ss.toString() + "]setSoTimeout(" + 5000 + "): " + socketException.toString());
        }
        if (n2 > 0) {
            try {
                this.ss.setReceiveBufferSize(n2);
            }
            catch (SocketException socketException) {
                this.parent.servletContext.log("WARNING: HttpsTunnelTcpListener[" + this.ss.toString() + "]setReceiveBufferSize(" + n2 + "): " + socketException.toString());
            }
        }
        this.setName("HttpsTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpsTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + n + " ...");
    }

    private ServerSocket createServerSocket(SSLServerSocketFactory sSLServerSocketFactory, int n, String string) throws IOException {
        ServerSocket serverSocket = null;
        int n2 = 0;
        while (serverSocket == null) {
            ++n2;
            try {
                if (sSLServerSocketFactory != null) {
                    serverSocket = this.doCreateSSLServerSocket(sSLServerSocketFactory, n, string);
                    continue;
                }
                serverSocket = this.doCreateServerSocket(n, string);
            }
            catch (BindException bindException) {
                if (n2 > 7) {
                    throw bindException;
                }
                this.parent.servletContext.log(bindException.toString(), (Throwable)bindException);
                this.pause(3000L);
            }
        }
        return serverSocket;
    }

    private ServerSocket doCreateServerSocket(int n, String string) throws IOException {
        ServerSocket serverSocket = null;
        if (string == null) {
            serverSocket = new ServerSocket(n);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string);
            serverSocket = new ServerSocket(n, 50, inetAddress);
        }
        return serverSocket;
    }

    private ServerSocket doCreateSSLServerSocket(SSLServerSocketFactory sSLServerSocketFactory, int n, String string) throws IOException {
        ServerSocket serverSocket = null;
        if (string == null) {
            serverSocket = sSLServerSocketFactory.createServerSocket(n);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string);
            serverSocket = sSLServerSocketFactory.createServerSocket(n, 50, inetAddress);
        }
        return serverSocket;
    }

    private void pause(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.closed) {
            try {
                Socket socket = this.ss.accept();
                HelperThread helperThread = this;
                synchronized (helperThread) {
                    if (this.closed) {
                        socket.close();
                        break;
                    }
                    this.parent.addServer(socket);
                }
                this.parent.servletContext.log(this.servletName + ": accepted socket connection. rcvbuf = " + socket.getReceiveBufferSize());
            }
            catch (InterruptedIOException interruptedIOException) {
                this.parent.checkConnectionTimeouts();
            }
            catch (Exception exception) {
                this.parent.servletContext.log(this.servletName + ": accept(): " + exception.getMessage());
            }
        }
        this.parent.servletContext.log(this.servletName + ": listen socket closed");
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SSLServerSocketFactory getServerSocketFactory(String string, String string2) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException("Keystore does not exist - " + string);
            }
            char[] cArray = string2.toCharArray();
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            keyManagerFactory.init(keyStore, cArray);
            TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
            sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            return sSLServerSocketFactory;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

