/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;
import java.util.Iterator;

public class RemDurableHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public RemDurableHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "RemDurableHandler");
        }
        if (gPacket.getType() == 7) {
            this.handleRemDurableInterest(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 8) {
            this.handleRemDurableInterestAck(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "RemDurableHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleRemDurableInterest(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(gPacket);
        if (!this.p.getConfigSyncComplete() && !clusterSubscriptionInfo.isConfigSyncResponse()) {
            if (DEBUG) {
                this.logger.log(4, "MessageBus: Dropping the G_REM_DURABLE_INTEREST packet from {0}. Not ready yet.", brokerAddress);
            }
            return;
        }
        int n = (Integer)gPacket.getProp("C");
        Iterator iterator = clusterSubscriptionInfo.getSubscriptions();
        try {
            while (iterator.hasNext()) {
                object = (Subscription)iterator.next();
                if (object == null) continue;
                messageBusCallback.unsubscribe((Subscription)object);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Exception processing packet ", exception);
        }
        if (clusterSubscriptionInfo.needReply()) {
            object = ClusterSubscriptionInfo.getReplyGPacket((short)8, 200);
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleRemDurableInterestAck(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_REM_DURABLE_INTEREST_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

