/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Hashtable;

public class RollbackCommitHandler
extends AdminCmdHandler {
    private static boolean DEBUG = RollbackCommitHandler.getDEBUG();
    TransactionList tl = null;

    public RollbackCommitHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
        this.tl = adminDataHandler.tl;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Rollback/Commit transaction " + hashtable);
        }
        int n = (Integer)hashtable.get("JMQMessageType");
        int n2 = 200;
        String string = null;
        TransactionUID transactionUID = null;
        TransactionState transactionState = null;
        TransactionHandler transactionHandler = null;
        if (this.parent.adminPktRtr != null) {
            transactionHandler = (TransactionHandler)this.parent.adminPktRtr.getHandler(48);
        }
        Long l = (Long)hashtable.get("JMQTransactionID");
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n2 = 500;
            string = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string);
        }
        if (l != null) {
            transactionUID = new TransactionUID(l);
        } else {
            n2 = 400;
        }
        if (n2 == 200) {
            transactionState = this.tl.retrieveState(transactionUID);
            if (transactionState == null) {
                n2 = 404;
                string = this.rb.getString("B3113", transactionUID);
            } else if (n == 62 && transactionState.getState() != 5) {
                n2 = 412;
                string = this.rb.getString("B3115", transactionUID);
            } else if (n == 64 && (transactionState.getState() < 1 || transactionState.getState() > 5)) {
                n2 = 412;
                string = this.rb.getString("B3222", transactionUID);
            } else {
                JMQXid jMQXid = this.tl.UIDToXid(transactionUID);
                if (!(jMQXid != null || Globals.getHAEnabled() && transactionState.getState() == 5)) {
                    string = n == 64 && transactionState.getState() >= 1 && transactionState.getState() < 5 ? this.rb.getString("B3100", "Rollback of non-XA transaction " + transactionUID + " in non-PREPARED state is not supported.") : this.rb.getString("B3100", "Could not find Xid for " + transactionUID);
                    n2 = 500;
                } else if (transactionHandler == null) {
                    string = this.rb.getString("B3100", "Could not locate TransactionHandler");
                    n2 = 500;
                } else if (n == 64) {
                    if (DEBUG) {
                        this.logger.log(4, "Rolling back " + transactionUID + " in state " + transactionState);
                    }
                    try {
                        transactionHandler.doRollback(transactionUID, jMQXid, null, transactionState, null, iMQConnection, RollbackReason.ADMIN);
                    }
                    catch (BrokerException brokerException) {
                        n2 = 500;
                        string = brokerException.getMessage();
                    }
                } else if (n == 62) {
                    if (DEBUG) {
                        this.logger.log(4, "Committing " + transactionUID + " in state " + transactionState);
                    }
                    try {
                        transactionHandler.doCommit(transactionUID, jMQXid, new Integer(0), transactionState, null, false, iMQConnection, null);
                    }
                    catch (BrokerException brokerException) {
                        n2 = 500;
                        string = brokerException.getMessage();
                    }
                } else {
                    return super.handle(iMQConnection, packet, hashtable);
                }
            }
        }
        this.sendReply(iMQConnection, packet, n + 1, n2, string);
        return true;
    }

    private void sendReply(IMQConnection iMQConnection, Packet packet, int n, int n2, String string) {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        RollbackCommitHandler.setProperties(packet2, n, n2, string);
        this.parent.sendReply(iMQConnection, packet, packet2);
    }
}

