/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsserver.util.VerifyAddressException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public class BrokerMQAddress
extends MQAddress {
    static final long serialVersionUID = 9061061210446233838L;
    private transient InetAddress host = null;
    private transient String tostring = null;

    protected BrokerMQAddress() {
    }

    protected void initialize(String string) throws MalformedURLException {
        super.initialize(string);
        this.serviceName = "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof BrokerMQAddress)) {
            return false;
        }
        return this.toString().equals(((BrokerMQAddress)object).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        if (this.getIsHTTP()) {
            return super.toString();
        }
        this.tostring = this.getSchemeName() + "://" + this.host.getHostAddress() + ":" + this.port + "/" + this.getServiceName();
        return this.tostring;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void resolveHostName() throws UnknownHostException {
        if (this.host == null) {
            String string = this.getHostName();
            this.host = string == null || string.equals("") || string.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        }
    }

    public static BrokerMQAddress createAddress(String string) throws MalformedURLException, UnknownHostException {
        BrokerMQAddress brokerMQAddress = new BrokerMQAddress();
        brokerMQAddress.initialize(string);
        brokerMQAddress.resolveHostName();
        return brokerMQAddress;
    }

    public static InetAddress resolveBindAddress(String string, boolean bl) throws BrokerException, UnknownHostException {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        InetAddress inetAddress = null;
        inetAddress = bl && string.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        if (!bl) {
            return inetAddress;
        }
        BrokerMQAddress.checkLoopbackAddress(inetAddress, string);
        return inetAddress;
    }

    public static void checkLoopbackAddress(InetAddress inetAddress, String string) throws BrokerException, UnknownHostException {
        if (inetAddress == null) {
            return;
        }
        InetAddress inetAddress2 = InetAddress.getByName("127.0.0.1");
        if (inetAddress2 == null) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            throw new VerifyAddressException(brokerResources.getString("B4213", string == null ? "" : string + "[" + inetAddress + "]"));
        }
        if (inetAddress2.equals(inetAddress)) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            throw new LoopbackAddressException(brokerResources.getString("B4214", string == null ? "" : string + "[" + inetAddress + "]"));
        }
    }
}

