/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CreateFileUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="update-file-user")
@Scoped(value=PerLookup.class)
@I18n(value="update.file.user")
public class UpdateFileUser
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UpdateFileUser.class);
    @Param(name="groups", optional=true, separator=58)
    List<String> groups = new ArrayList<String>(0);
    @Param(name="userpassword", password=true)
    String userpassword;
    @Param(name="authrealmname", optional=true)
    String authRealmName;
    @Param(optional=true)
    String target;
    @Param(name="username", primary=true)
    String userName;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService securityService = config.getSecurityService();
        if (this.authRealmName == null) {
            this.authRealmName = securityService.getDefaultRealm();
        }
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(this.authRealmName)) continue;
            fileAuthRealm = authRealm;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("update.file.user.filerealmnotfound", "There is no File realm {0} to perform this operation", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("update.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("update.file.user.keyfilenotfound", "There is no physical file associated with file realm {0}", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String password = this.userpassword;
        if (password == null) {
            report.setMessage(localStrings.getLocalString("update.file.user.keyfilenotreadable", "Password for user {0} has to be specified in --userpassword option or supplied through AS_ADMIN_USERPASSWORD property in the file specified in --passwordfile option", new Object[]{this.userName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            fr = new FileRealm(keyFile);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("update.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("update.file.user.realmnotsupported", "Configured file realm {0} does not exist.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            CreateFileUser.handleAdminGroup(this.authRealmName, this.groups);
            String[] groups1 = this.groups.toArray(new String[this.groups.size()]);
            fr.updateUser(this.userName, password, groups1);
            fr.writeKeyFile(keyFile);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("update.file.user.userupdatefailed", "Updating user {0} in file realm {1} failed", new Object[]{this.userName, this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

