/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.Display;
import org.glassfish.gmbal.generic.MethodMonitor;
import org.glassfish.gmbal.generic.MethodMonitorFactory;
import org.glassfish.gmbal.generic.Pair;
import org.glassfish.gmbal.generic.UnaryFunction;
import org.glassfish.gmbal.typelib.DeclarationFactory;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.gmbal.typelib.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEvaluator {
    private static boolean debug = false;
    private static boolean debugEvaluate = false;
    private static final MethodMonitor mm = MethodMonitorFactory.makeStandard(TypeEvaluator.class);
    private static Map<Class<?>, EvaluatedType> immutableTypes = new HashMap();
    private static Map<EvalMapKey, EvaluatedClassDeclaration> evalClassMap = new HashMap<EvalMapKey, EvaluatedClassDeclaration>();
    private static List<EvaluatedType> emptyETList = new ArrayList<EvaluatedType>(0);
    private static Map<Class, EvaluatedType> classMap;

    private TypeEvaluator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapPut(EvaluatedClassDeclaration ecd, Class cls) {
        mm.enter(debug, "mapPut", ecd, cls);
        immutableTypes.put(cls, ecd);
        try {
            EvalMapKey key = new EvalMapKey(cls, emptyETList);
            evalClassMap.put(key, ecd);
        }
        finally {
            mm.exit(debug);
        }
    }

    private static EvaluatedType getImmutableEvaluatedType(Class<?> cls) {
        return immutableTypes.get(cls);
    }

    public static synchronized void setDebugLevel(int level) {
        debug = level > 1;
        debugEvaluate = level >= 1;
    }

    private static EvaluatedClassDeclaration getECD(Class cls) {
        return DeclarationFactory.ecdecl(1, cls.getName(), cls, true);
    }

    private static List<Method> getDeclaredMethods(final Class<?> cls) {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return Arrays.asList(cls.getDeclaredMethods());
        }
        return AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                return Arrays.asList(cls.getDeclaredMethods());
            }
        });
    }

    private static List<Field> getDeclaredFields(final Class<?> cls) {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return Arrays.asList(cls.getDeclaredFields());
        }
        return AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                return Arrays.asList(cls.getDeclaredFields());
            }
        });
    }

    private static Method getDeclaredMethod(final Class<?> cls, final String name, final Class<?> ... sig) throws NoSuchMethodException, PrivilegedActionException {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return cls.getDeclaredMethod(name, sig);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws Exception {
                return cls.getDeclaredMethod(name, sig);
            }
        });
    }

    public static synchronized int evalClassMapSize() {
        return evalClassMap.size();
    }

    public static synchronized void dumpEvalClassMap() {
        System.out.println("TypeEvaluator: dumping eval class map");
        int numSystem = 0;
        int total = 0;
        for (Map.Entry<EvalMapKey, EvaluatedClassDeclaration> entry : evalClassMap.entrySet()) {
            System.out.println("\tKey:" + entry.getKey() + "=>");
            System.out.println("\t\t" + entry.getValue());
            String name = ((Class)entry.getKey().first()).getName();
            if (!name.startsWith("org.glassfish.gmbal")) {
                ++numSystem;
            }
            ++total;
        }
        System.out.printf("\nEvalClassMap contains %d entries, %d of which are system classes\n", total, numSystem);
    }

    public static synchronized EvaluatedType getEvaluatedType(Class cls) {
        EvaluatedType etype = classMap.get(cls);
        if (etype == null) {
            TypeEvaluationVisitor visitor = new TypeEvaluationVisitor();
            etype = visitor.evaluateType(cls);
            classMap.put(cls, etype);
        }
        return etype;
    }

    static {
        try {
            Class[] classes = new Class[]{Integer.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Double.TYPE, Void.TYPE, Integer.class, Byte.class, Character.class, Short.class, Boolean.class, Float.class, Double.class, Long.class, BigDecimal.class, BigInteger.class, Date.class, ObjectName.class, Class.class, Number.class};
            Class<Object> objectClass = Object.class;
            Class<String> stringClass = String.class;
            Class<Void> voidClass = Void.class;
            Method toStringMethod = TypeEvaluator.getDeclaredMethod(objectClass, "toString", new Class[0]);
            EvaluatedClassDeclaration objectECD = TypeEvaluator.getECD(objectClass);
            EvaluatedClassDeclaration voidECD = TypeEvaluator.getECD(voidClass);
            EvaluatedClassDeclaration stringECD = TypeEvaluator.getECD(stringClass);
            EvaluatedMethodDeclaration toStringEMD = DeclarationFactory.emdecl(objectECD, 1, stringECD, "toString", emptyETList, toStringMethod);
            List<EvaluatedMethodDeclaration> toStringList = Algorithms.list(toStringEMD);
            List<EvaluatedClassDeclaration> objectList = Algorithms.list(objectECD);
            voidECD.inheritance(objectList);
            voidECD.freeze();
            objectECD.methods(toStringList);
            objectECD.freeze();
            stringECD.inheritance(objectList);
            stringECD.freeze();
            TypeEvaluator.mapPut(voidECD, voidClass);
            TypeEvaluator.mapPut(objectECD, objectClass);
            TypeEvaluator.mapPut(stringECD, stringClass);
            for (Class cls : classes) {
                EvaluatedClassDeclaration ecd = TypeEvaluator.getECD(cls);
                ecd.inheritance(objectList);
                ecd.freeze();
                TypeEvaluator.mapPut(ecd, cls);
            }
        }
        catch (Exception exc) {
            throw Exceptions.self.internalTypeEvaluatorError(exc);
        }
        classMap = new WeakHashMap<Class, EvaluatedType>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvalMapKey
    extends Pair<Class<?>, List<EvaluatedType>> {
        public static final EvalMapKey OBJECT_KEY = new EvalMapKey(Object.class, (List<EvaluatedType>)new ArrayList<EvaluatedType>(0));

        public EvalMapKey(Class<?> cls, List<EvaluatedType> decls) {
            super(cls, decls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartialDefinitions {
        private Map<Pair<Class<?>, List<Type>>, EvaluatedType> table = new HashMap();

        private PartialDefinitions() {
        }

        private Pair<Class<?>, List<Type>> getKey(Class cls) {
            ArrayList<Class<Object>> list = new ArrayList<Class<Object>>();
            for (TypeVariable tv : cls.getTypeParameters()) {
                Object type;
                Type[] bounds = tv.getBounds();
                if (bounds.length > 0) {
                    if (bounds.length > 1) {
                        throw Exceptions.self.multipleUpperBoundsNotSupported(tv);
                    }
                    type = bounds[0];
                } else {
                    type = Object.class;
                }
                list.add((Class<Object>)type);
            }
            return new Pair(cls, list);
        }

        private Pair<Class<?>, List<Type>> getKey(ParameterizedType pt) {
            ArrayList<Type> list = new ArrayList<Type>();
            for (Type type : pt.getActualTypeArguments()) {
                list.add(type);
            }
            return new Pair((Class)pt.getRawType(), list);
        }

        public EvaluatedType get(Class cls) {
            return this.table.get(this.getKey(cls));
        }

        public EvaluatedType get(ParameterizedType pt) {
            return this.table.get(this.getKey(pt));
        }

        public void put(Class cls, EvaluatedType et) {
            this.table.put(this.getKey(cls), et);
        }

        public void put(ParameterizedType pt, EvaluatedType et) {
            this.table.put(this.getKey(pt), et);
        }

        public void remove(Class cls) {
            this.table.remove(this.getKey(cls));
        }

        public void remove(ParameterizedType pt) {
            this.table.remove(this.getKey(pt));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeEvaluationVisitor {
        private final Display<String, EvaluatedType> display = new Display();
        private final PartialDefinitions partialDefinitions = new PartialDefinitions();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvaluatedType evaluateType(Object type) {
            EvaluatedType result;
            block10: {
                mm.enter(debugEvaluate, "evaluateType", type);
                result = null;
                try {
                    if (type == null) {
                        result = null;
                        break block10;
                    }
                    if (type instanceof Class) {
                        Class cls = (Class)type;
                        result = this.visitClassDeclaration(cls);
                        break block10;
                    }
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)type;
                        result = this.visitParameterizedType(pt);
                        break block10;
                    }
                    if (type instanceof TypeVariable) {
                        TypeVariable tvar = (TypeVariable)type;
                        result = this.visitTypeVariable(tvar);
                        break block10;
                    }
                    if (type instanceof GenericArrayType) {
                        GenericArrayType gat = (GenericArrayType)type;
                        result = this.visitGenericArrayType(gat);
                        break block10;
                    }
                    if (type instanceof WildcardType) {
                        WildcardType wt = (WildcardType)type;
                        result = this.visitWildcardType(wt);
                        break block10;
                    }
                    if (type instanceof Method) {
                        throw Exceptions.self.evaluateTypeCalledWithMethod(type);
                    }
                    throw Exceptions.self.evaluateTypeCalledWithUnknownType(type);
                }
                finally {
                    mm.exit(debugEvaluate, result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitClassDeclaration(Class decl) {
            EvaluatedType result;
            block8: {
                mm.enter(debug, "visitClassDeclaration", decl);
                result = null;
                try {
                    if (!decl.isArray()) break block8;
                    mm.info(debug, "decl is an array");
                    EvaluatedArrayType evaluatedArrayType = DeclarationFactory.egat(this.evaluateType(decl.getComponentType()));
                    mm.exit(debug, result);
                    return evaluatedArrayType;
                }
                catch (Throwable throwable) {
                    mm.exit(debug, result);
                    throw throwable;
                }
            }
            result = this.partialDefinitions.get(decl);
            if (result == null) {
                EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                this.partialDefinitions.put(decl, (EvaluatedType)newDecl);
                try {
                    OrderedResult<String, EvaluatedType> bindings = this.getBindings(decl);
                    result = this.getCorrectDeclaration(bindings, decl, newDecl);
                }
                finally {
                    this.partialDefinitions.remove(decl);
                }
            } else {
                mm.info(debug, "found result:" + result);
            }
            mm.exit(debug, result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitParameterizedType(ParameterizedType pt) {
            EvaluatedType result;
            block6: {
                mm.enter(debug, "visitParameterizedType", pt);
                Class decl = (Class)pt.getRawType();
                result = null;
                try {
                    result = this.partialDefinitions.get(pt);
                    if (result != null) break block6;
                    EvaluatedClassDeclaration newDecl = DeclarationFactory.ecdecl(decl.getModifiers(), decl.getName(), decl);
                    this.partialDefinitions.put(pt, (EvaluatedType)newDecl);
                    try {
                        OrderedResult<String, EvaluatedType> bindings = this.getBindings(pt);
                        result = this.getCorrectDeclaration(bindings, decl, newDecl);
                    }
                    finally {
                        this.partialDefinitions.remove(pt);
                    }
                }
                finally {
                    mm.exit(debug, result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedFieldDeclaration visitFieldDeclaration(EvaluatedClassDeclaration cdecl, Field fld) {
            EvaluatedType ftype;
            EvaluatedFieldDeclaration result;
            block7: {
                block6: {
                    mm.enter(debug, "visitFieldDeclaration", cdecl, fld);
                    result = null;
                    if (Modifier.isFinal(fld.getModifiers())) break block6;
                    EvaluatedFieldDeclaration evaluatedFieldDeclaration = null;
                    mm.exit(debug, result);
                    return evaluatedFieldDeclaration;
                }
                Class<?> fieldType = fld.getType();
                ftype = TypeEvaluator.getImmutableEvaluatedType(fieldType);
                if (ftype != null) break block7;
                EvaluatedFieldDeclaration evaluatedFieldDeclaration = null;
                mm.exit(debug, result);
                return evaluatedFieldDeclaration;
            }
            try {
                result = DeclarationFactory.efdecl(cdecl, fld.getModifiers(), ftype, fld.getName(), fld);
                mm.exit(debug, result);
            }
            catch (Exception exc) {
                try {
                    mm.info(debug, "Caught exception ", exc, " for field ", fld);
                    mm.exit(debug, result);
                }
                catch (Throwable throwable) {
                    mm.exit(debug, result);
                    throw throwable;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedMethodDeclaration visitMethodDeclaration(EvaluatedClassDeclaration cdecl, Method mdecl) {
            mm.enter(debug, "visitMethodDeclaration", cdecl, mdecl);
            EvaluatedMethodDeclaration result = null;
            try {
                List<EvaluatedType> eptypes = Algorithms.map(Arrays.asList(mdecl.getGenericParameterTypes()), new UnaryFunction<Type, EvaluatedType>(){

                    @Override
                    public EvaluatedType evaluate(Type type) {
                        return TypeEvaluationVisitor.this.evaluateType(type);
                    }
                });
                mm.info(debug, "eptypes" + eptypes);
                if (mdecl.getName().equals("getThing")) {
                    mm.info(debug, "processing getThing method from test");
                }
                result = DeclarationFactory.emdecl(cdecl, mdecl.getModifiers(), this.evaluateType(mdecl.getGenericReturnType()), mdecl.getName(), eptypes, mdecl);
                mm.exit(debug, result);
            }
            catch (Throwable throwable) {
                mm.exit(debug, result);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitTypeVariable(TypeVariable tvar) {
            mm.enter(debug, "visitTypeVariable", new Object[0]);
            EvaluatedType result = null;
            try {
                result = this.lookup(tvar);
            }
            finally {
                mm.exit(debug, result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitGenericArrayType(GenericArrayType at) {
            mm.enter(debug, "visitGenericArrayType", new Object[0]);
            EvaluatedArrayType result = null;
            try {
                result = DeclarationFactory.egat(this.evaluateType(at.getGenericComponentType()));
            }
            finally {
                mm.exit(debug, result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType visitWildcardType(WildcardType wt) {
            mm.enter(debug, "visitWilcardType", new Object[0]);
            EvaluatedType result = null;
            try {
                List<Type> ub = Arrays.asList(wt.getUpperBounds());
                if (ub.size() > 0) {
                    if (ub.size() > 1) {
                        throw Exceptions.self.multipleUpperBoundsNotSupported(wt);
                    }
                    result = this.evaluateType(ub.get(0));
                } else {
                    result = EvaluatedType.EOBJECT;
                }
                mm.exit(debug, result);
            }
            catch (Throwable throwable) {
                mm.exit(debug, result);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType lookup(TypeVariable tvar) {
            mm.enter(debug, "lookup", tvar);
            EvaluatedType result = null;
            try {
                result = this.display.lookup(tvar.getName());
                if (result == null) {
                    mm.info(debug, "tvar not found in display");
                    Type[] bounds = tvar.getBounds();
                    if (bounds.length > 0) {
                        if (bounds.length > 1) {
                            throw Exceptions.self.multipleUpperBoundsNotSupported(tvar);
                        }
                        result = this.evaluateType(bounds[0]);
                    } else {
                        result = EvaluatedType.EOBJECT;
                    }
                }
                mm.exit(debug, result);
            }
            catch (Throwable throwable) {
                mm.exit(debug, result);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EvaluatedType getCorrectDeclaration(OrderedResult<String, EvaluatedType> bindings, Class decl, EvaluatedClassDeclaration newDecl) {
            mm.enter(debug, "getCorrectDeclaration", decl);
            EvaluatedType result = null;
            try {
                List<EvaluatedType> blist = bindings.getList();
                EvalMapKey key = new EvalMapKey(decl, blist);
                if (blist.size() > 0) {
                    newDecl.instantiations(blist);
                }
                if ((result = (EvaluatedType)evalClassMap.get(key)) == null) {
                    mm.info(debug, "No result in evalClassMap");
                    evalClassMap.put(key, newDecl);
                    this.processClass(newDecl, bindings.getMap(), decl);
                    result = newDecl;
                } else {
                    mm.info(debug, "Found result in evalClassMap");
                }
                mm.exit(debug, result);
            }
            catch (Throwable throwable) {
                mm.exit(debug, result);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processClass(final EvaluatedClassDeclaration newDecl, Map<String, EvaluatedType> bindings, Class decl) {
            mm.enter(debug, "processClass", bindings, decl);
            this.display.enterScope();
            this.display.bind(bindings);
            try {
                List<EvaluatedClassDeclaration> inheritance = Algorithms.map(this.getInheritance(decl), new UnaryFunction<Type, EvaluatedClassDeclaration>(){

                    @Override
                    public EvaluatedClassDeclaration evaluate(Type pt) {
                        return (EvaluatedClassDeclaration)TypeEvaluationVisitor.this.evaluateType(pt);
                    }
                });
                mm.info(debug, "inheritance", inheritance);
                newDecl.inheritance(inheritance);
                List<EvaluatedFieldDeclaration> newFields = Algorithms.map(TypeEvaluator.getDeclaredFields(decl), new UnaryFunction<Field, EvaluatedFieldDeclaration>(){

                    @Override
                    public EvaluatedFieldDeclaration evaluate(Field fld) {
                        return TypeEvaluationVisitor.this.visitFieldDeclaration(newDecl, fld);
                    }
                });
                newDecl.fields(newFields);
                List<EvaluatedMethodDeclaration> newMethods = Algorithms.map(TypeEvaluator.getDeclaredMethods(decl), new UnaryFunction<Method, EvaluatedMethodDeclaration>(){

                    @Override
                    public EvaluatedMethodDeclaration evaluate(Method md) {
                        return TypeEvaluationVisitor.this.visitMethodDeclaration(newDecl, md);
                    }
                });
                newDecl.methods(newMethods);
                newDecl.freeze();
                mm.info(debug, "newDecl" + newDecl);
            }
            finally {
                this.display.exitScope();
                mm.exit(debug);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Type> getInheritance(Class cls) {
            mm.enter(debug, "getInheritance", cls);
            ArrayList<Type> result = null;
            try {
                result = new ArrayList<Type>(0);
                result.add(cls.getGenericSuperclass());
                result.addAll(Arrays.asList(cls.getGenericInterfaces()));
            }
            finally {
                mm.exit(debug, result);
            }
            return result;
        }

        private OrderedResult<String, EvaluatedType> getBindings(Class decl) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            for (TypeVariable tv : decl.getTypeParameters()) {
                EvaluatedType res = this.lookup(tv);
                result.add(tv.getName(), res);
            }
            return result;
        }

        private OrderedResult<String, EvaluatedType> getBindings(ParameterizedType pt) {
            OrderedResult<String, EvaluatedType> result = new OrderedResult<String, EvaluatedType>();
            Iterator<Type> types = Arrays.asList(pt.getActualTypeArguments()).iterator();
            Iterator tvars = Arrays.asList(((Class)pt.getRawType()).getTypeParameters()).iterator();
            while (types.hasNext() && tvars.hasNext()) {
                Type type = types.next();
                TypeVariable tvar = tvars.next();
                result.add(tvar.getName(), this.evaluateType(type));
            }
            if (types.hasNext() != tvars.hasNext()) {
                throw Exceptions.self.listsNotTheSameLengthInParamType(pt);
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OrderedResult<K, V> {
            private List<V> list = new ArrayList<V>(0);
            private Map<K, V> map = new HashMap();

            public List<V> getList() {
                return this.list;
            }

            public Map<K, V> getMap() {
                return this.map;
            }

            public void add(K key, V value) {
                this.list.add(value);
                this.map.put(key, value);
            }
        }
    }
}

