/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class MappingReferenceKeyElementImpl
extends MappingMemberElementImpl
implements MappingReferenceKeyElement {
    private ArrayList _referencingKey;
    private MappingTableElement _table;

    public MappingReferenceKeyElementImpl() {
        this((String)null);
    }

    public MappingReferenceKeyElementImpl(String name) {
        super(name, null);
    }

    public MappingReferenceKeyElementImpl(MappingTableElement table) throws ModelException {
        super(table.getName(), table.getDeclaringClass());
        this.setTableInternal(table);
    }

    public String getKeyName() {
        return this.getName();
    }

    public void setKeyName(String name) throws ModelException {
        this.setName(name.toString());
    }

    public MappingTableElement getTable() {
        return this._table;
    }

    public void setTable(MappingTableElement table) throws ModelException {
        MappingTableElement old = this.getTable();
        try {
            this.fireVetoableChange("table", old, table);
            this.setTableInternal(table);
            this.firePropertyChange("table", old, table);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    private void setTableInternal(MappingTableElement table) throws ModelException {
        if (table == null) {
            throw new ModelException(I18NHelper.getMessage(MappingReferenceKeyElementImpl.getMessages(), "mapping.element.null_argument"));
        }
        this._table = table;
        if (null == this.getDeclaringClass()) {
            this._declaringClass = table.getDeclaringClass();
        }
        if (null == this.getName()) {
            this._name = table.getName();
        }
    }

    public TableElement getDeclaringTable() {
        ArrayList locals = this.getReferencingKey();
        if (locals != null && locals.size() > 0) {
            String absoluteName = NameUtil.getAbsoluteMemberName((String)this.getDeclaringClass().getDatabaseRoot(), (String)locals.get(0).toString());
            return TableElement.forName((String)NameUtil.getTableName((String)absoluteName));
        }
        return null;
    }

    public void setDeclaringTable(TableElement tableElement) {
        throw new UnsupportedOperationException();
    }

    public TableElement getReferencedTable() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        if (columnPairs != null && columnPairs.length > 0) {
            return columnPairs[0].getReferencedColumn().getDeclaringTable();
        }
        return null;
    }

    private ArrayList getReferencingKey() {
        if (this._referencingKey == null) {
            this._referencingKey = new ArrayList();
        }
        return this._referencingKey;
    }

    public ArrayList getColumnPairNames() {
        ArrayList locals = this.getReferencingKey();
        ArrayList foreigns = this.getTable().getKey();
        int count = locals != null ? locals.size() : 0;
        ArrayList<String> pairs = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            pairs.add(locals.get(i) + ";" + foreigns.get(i));
        }
        return pairs;
    }

    private int getIndexOfColumnPair(String searchPairName) {
        int count;
        ArrayList myPairs = this.getColumnPairNames();
        int n = count = myPairs != null ? myPairs.size() : 0;
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                if (!myPairs.get(i).equals(searchPairName)) continue;
                return i;
            }
        }
        return -1;
    }

    private void addKeyColumn(ColumnElement column) throws ModelException {
        ArrayList referencingKey = this.getReferencingKey();
        String columnName = NameUtil.getRelativeMemberName((String)column.getName().getFullName());
        try {
            this.fireVetoableChange("keyColumns", null, null);
            referencingKey.add(columnName);
            this.firePropertyChange("keyColumns", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public ColumnElement[] getLocalColumns() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        int count = columnPairs != null ? columnPairs.length : 0;
        ColumnElement[] columns = new ColumnElement[count];
        for (int i = 0; i < count; ++i) {
            columns[i] = columnPairs[i].getLocalColumn();
        }
        return columns;
    }

    public ColumnElement[] getReferencedColumns() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        int count = columnPairs != null ? columnPairs.length : 0;
        ColumnElement[] columns = new ColumnElement[count];
        for (int i = 0; i < count; ++i) {
            columns[i] = columnPairs[i].getReferencedColumn();
        }
        return columns;
    }

    public void removeColumnPair(String pairName) throws ModelException {
        ArrayList<String> pairNames = new ArrayList<String>(1);
        pairNames.add(pairName);
        this.removeColumnPairs(pairNames);
    }

    public void removeColumnPairs(ArrayList pairNames) throws ModelException {
        ArrayList refKey = this.getReferencingKey();
        ArrayList key = this.getTable().getKey();
        int count = pairNames != null ? pairNames.size() : 0;
        for (int i = 0; i < count; ++i) {
            String pairName = (String)pairNames.get(i);
            int index = this.getIndexOfColumnPair(pairName);
            if (pairName == null) continue;
            try {
                Object remove1 = null;
                Object remove2 = null;
                this.fireVetoableChange("keyColumns", null, null);
                remove1 = key.remove(index);
                remove2 = refKey.remove(index);
                if (remove1 == null || remove2 == null) {
                    if (remove1 != null) {
                        key.add(index, remove1);
                    } else if (remove2 != null) {
                        refKey.add(index, remove2);
                    }
                    throw new ModelException(I18NHelper.getMessage(MappingReferenceKeyElementImpl.getMessages(), "mapping.element.element_not_removed", pairName));
                }
                this.firePropertyChange("keyColumns", null, null);
                continue;
            }
            catch (PropertyVetoException e) {
                throw new ModelVetoException(e);
            }
        }
    }

    public void addColumnPair(ColumnPairElement pair) throws ModelException {
        this.addColumnPairs(new ColumnPairElement[]{pair});
    }

    public void addColumnPairs(ColumnPairElement[] pairs) throws ModelException {
        MappingTableElementImpl table = (MappingTableElementImpl)this.getTable();
        int count = pairs != null ? pairs.length : 0;
        for (int i = 0; i < count; ++i) {
            ColumnPairElement pair = pairs[i];
            if (pair != null) {
                if (this.getIndexOfColumnPair(NameUtil.getRelativeMemberName((String)pair.getName().getFullName())) != -1) continue;
                table.addKeyColumnInternal(pair.getReferencedColumn());
                this.addKeyColumn(pair.getLocalColumn());
                continue;
            }
            throw new ModelException(I18NHelper.getMessage(MappingReferenceKeyElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    public void removeColumnPair(ColumnPairElement pair) throws ModelException {
        this.removeColumnPairs(new ColumnPairElement[]{pair});
    }

    public void removeColumnPairs(ColumnPairElement[] pairs) throws ModelException {
        ArrayList<String> pairNames = new ArrayList<String>();
        int count = pairs != null ? pairs.length : 0;
        for (int i = 0; i < count; ++i) {
            ColumnPairElement pair = pairs[i];
            pairNames.add(NameUtil.getRelativeMemberName((String)pair.getName().getFullName()));
        }
        this.removeColumnPairs(pairNames);
    }

    public void setColumnPairs(ColumnPairElement[] pairs) throws ModelException {
        this.removeColumnPairs(this.getColumnPairNames());
        this.addColumnPairs(pairs);
    }

    public ColumnPairElement[] getColumnPairs() {
        ArrayList pairNames = this.getColumnPairNames();
        TableElement table = this.getDeclaringTable();
        int count = pairNames != null ? pairNames.size() : 0;
        ColumnPairElement[] pairs = new ColumnPairElement[count];
        String databaseRoot = this.getDeclaringClass().getDatabaseRoot();
        for (int i = 0; i < count; ++i) {
            String absoluteName = NameUtil.getAbsoluteMemberName((String)databaseRoot, (String)((String)pairNames.get(i)));
            pairs[i] = (ColumnPairElement)table.getMember(DBIdentifier.create((String)absoluteName));
        }
        return pairs;
    }

    public ColumnPairElement getColumnPair(DBIdentifier name) {
        ColumnPairElement[] myPairs = this.getColumnPairs();
        int count = myPairs != null ? myPairs.length : 0;
        String databaseRoot = this.getDeclaringClass().getDatabaseRoot();
        if (count > 0) {
            String absoluteTableName = NameUtil.getAbsoluteTableName((String)databaseRoot, (String)this.getTable().getName());
            ColumnPairElement searchPair = (ColumnPairElement)TableElement.forName((String)absoluteTableName).getMember(name);
            for (int i = 0; i < count; ++i) {
                if (!myPairs[i].equals((Object)searchPair)) continue;
                return searchPair;
            }
        }
        return null;
    }

    public void setReferencingKey(ArrayList referencingKey) {
        this._referencingKey = referencingKey;
    }

    protected void stripSchemaName() {
        this._name = NameUtil.getRelativeTableName((String)this._name);
        if (this._referencingKey != null) {
            ListIterator<String> i = this._referencingKey.listIterator();
            while (i.hasNext()) {
                i.set(NameUtil.getRelativeMemberName((String)((String)i.next())));
            }
        }
    }
}

