/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.util;

import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserProperties
extends Properties {
    private static AdminResources ar = Globals.getAdminResources();
    private static final String JMQPREFSROOT = ".imq";
    private static final String JMQADMINROOT = "admin";
    private String fileName;
    private String dirName;

    public UserProperties() {
        String string = System.getProperty("user.home");
        this.fileName = "admin.properties";
        this.dirName = string + File.separator + JMQPREFSROOT + File.separator + JMQADMINROOT;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getAbsoluteFileName() {
        String string = this.dirName + File.separator + this.fileName;
        return string;
    }

    public void setDirName(String string) {
        this.dirName = string;
    }

    public void load() throws UserPropertiesException, SecurityException {
        String string = this.dirName + File.separator + this.fileName;
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (!file.canRead()) {
            UserPropertiesException userPropertiesException = new UserPropertiesException(ar.getString("A3142", file.getAbsolutePath()));
            throw userPropertiesException;
        }
        this.loadFile(file);
    }

    private void loadFile(File file) throws UserPropertiesException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.load(fileInputStream);
        }
        catch (Exception exception) {
            UserPropertiesException userPropertiesException = new UserPropertiesException(ar.getString("A3143", file.getAbsolutePath(), exception.toString()));
            throw userPropertiesException;
        }
    }

    public void save() throws UserPropertiesException, SecurityException {
        String string = this.dirName + File.separator + this.fileName;
        File file = new File(this.dirName);
        File file2 = new File(string);
        if (file2.exists()) {
            if (!file2.canWrite()) {
                UserPropertiesException userPropertiesException = new UserPropertiesException(ar.getString("A3144", file2.getAbsolutePath()));
                throw userPropertiesException;
            }
        } else if (file.exists()) {
            if (!file.canWrite()) {
                UserPropertiesException userPropertiesException = new UserPropertiesException(ar.getString("A3145", file2.getAbsolutePath()));
                throw userPropertiesException;
            }
        } else {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.store(fileOutputStream, null);
        }
        catch (IOException iOException) {
            UserPropertiesException userPropertiesException = new UserPropertiesException(ar.getString("A3146", file2.getAbsolutePath(), iOException.toString()));
            throw userPropertiesException;
        }
    }
}

