/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.i18n;

import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManagerBase {
    private static Logger _logger = LogDomains.getLogger(StringManagerBase.class, "javax.enterprise.system.util");
    private volatile ResourceBundle _resourceBundle;
    private final String _resourceBundleName;
    private final ClassLoader _classLoader;
    private static final String NO_DEFAULT = "No local string defined";
    private static Hashtable managers = new Hashtable();

    protected StringManagerBase(String resourceBundleName, ClassLoader classLoader) {
        this._resourceBundleName = resourceBundleName;
        this._classLoader = classLoader;
    }

    private ResourceBundle getResourceBundle() {
        if (this._resourceBundle == null) {
            try {
                this._resourceBundle = ResourceBundle.getBundle(this._resourceBundleName, Locale.getDefault(), this._classLoader);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iplanet_util.no_resource_bundle", e);
            }
        }
        return this._resourceBundle;
    }

    public static synchronized StringManagerBase getStringManager(String resourceBundleName, ClassLoader classLoader) {
        StringManagerBase mgr = (StringManagerBase)managers.get(resourceBundleName);
        if (mgr == null) {
            mgr = new StringManagerBase(resourceBundleName, classLoader);
            try {
                managers.put(resourceBundleName, mgr);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iplanet_util.error_while_caching", e);
            }
        }
        return mgr;
    }

    public String getString(String key) {
        return this.getStringWithDefault(key, NO_DEFAULT);
    }

    public String getStringWithDefault(String key, String defaultValue) {
        String value = null;
        try {
            value = this.getResourceBundle().getString(key);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "No local string for: " + key, e);
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getStringWithDefault(String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getStringWithDefault(key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        String fmtStr = null;
        try {
            fmtStr = f.format(arguments);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "iplanet_util.error_while_formating", e);
            fmtStr = defaultFormat;
        }
        return fmtStr;
    }

    public String getString(String key, Object arg1) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1});
    }

    public String getString(String key, Object arg1, Object arg2) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String getString(String key, Object[] args) {
        return this.getStringWithDefault(key, NO_DEFAULT, args);
    }
}

