/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.ForbiddenStateException;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.messages.BeanMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorImpl<T>
extends ManagedBean<T>
implements Decorator<T> {
    private WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private Set<Annotation> delegateBindings;
    private Type delegateType;
    private Set<Type> delegateTypes;
    private Set<Type> decoratedTypes;

    public static <T> Decorator<T> wrap(final Decorator<T> decorator) {
        return new ForwardingDecorator<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                return this.delegate().getDelegateQualifiers();
            }

            @Override
            public Set<Type> getTypes() {
                return this.delegate().getTypes();
            }

            @Override
            protected Decorator<T> delegate() {
                return decorator;
            }
        };
    }

    public static <T> DecoratorImpl<T> of(WeldClass<T> clazz, BeanManagerImpl manager) {
        return new DecoratorImpl<T>(clazz, manager);
    }

    protected DecoratorImpl(WeldClass<T> type, BeanManagerImpl manager) {
        super(type, Decorator.class.getSimpleName() + "-" + type.getName(), manager);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initDelegateInjectionPoint();
            this.initDecoratedTypes();
            this.initDelegateBindings();
            this.initDelegateType();
            this.checkDelegateType();
        }
    }

    protected void initDecoratedTypes() {
        this.decoratedTypes = new HashSet<Type>();
        this.decoratedTypes.addAll(this.getAnnotatedItem().getInterfaceOnlyFlattenedTypeHierarchy());
        this.decoratedTypes.remove(Serializable.class);
    }

    protected void initDelegateInjectionPoint() {
        this.delegateInjectionPoint = this.getDelegateInjectionPoints().iterator().next();
    }

    @Override
    protected void checkDelegateInjectionPoints() {
        for (WeldInjectionPoint<?, ?> injectionPoint : this.getDelegateInjectionPoints()) {
            if (!(injectionPoint instanceof MethodInjectionPoint) || injectionPoint.isAnnotationPresent(Inject.class)) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_ON_NON_INITIALIZER_METHOD, injectionPoint);
        }
        if (this.getDelegateInjectionPoints().size() == 0) {
            throw new DefinitionException(BeanMessage.NO_DELEGATE_FOR_DECORATOR, this);
        }
        if (this.getDelegateInjectionPoints().size() > 1) {
            throw new DefinitionException(BeanMessage.TOO_MANY_DELEGATES_FOR_DECORATOR, this);
        }
    }

    protected void initDelegateBindings() {
        this.delegateBindings = new HashSet<Annotation>();
        this.delegateBindings.addAll(this.delegateInjectionPoint.getQualifiers());
    }

    protected void initDelegateType() {
        this.delegateType = this.delegateInjectionPoint.getBaseType();
        this.delegateTypes = new HashSet<Type>();
        this.delegateTypes.add(this.delegateType);
    }

    protected void checkDelegateType() {
        for (Type decoratedType : this.getDecoratedTypes()) {
            if (decoratedType instanceof Class) {
                if (((Class)decoratedType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
                throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
            }
            if (!(decoratedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
            if (!this.delegateInjectionPoint.isParameterizedType()) {
                throw new DefinitionException(BeanMessage.DECORATED_TYPE_PARAMETERIZED_DELEGATE_NOT, this.delegateType, this);
            }
            if (!Arrays.equals(this.delegateInjectionPoint.getActualTypeArguments(), parameterizedType.getActualTypeArguments())) {
                throw new DefinitionException(BeanMessage.DELEGATE_TYPE_PARAMETER_MISMATCH, decoratedType, this);
            }
            Type rawType = ((ParameterizedType)decoratedType).getRawType();
            if (rawType instanceof Class && !((Class)rawType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) {
                throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
            }
            throw new ForbiddenStateException(BeanMessage.UNABLE_TO_PROCESS, decoratedType);
        }
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegateBindings;
    }

    @Override
    public Type getDelegateType() {
        return this.delegateType;
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public WeldInjectionPoint<?, ?> getDelegateInjectionPoint() {
        return this.delegateInjectionPoint;
    }

    @Override
    public void initDecorators() {
    }

    @Override
    public String getDescription() {
        return super.getDescription("decorator");
    }
}

