/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Scope;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionModelBuilder;
import org.jboss.interceptor.model.InterceptorClassMetadataImpl;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.ForbiddenStateException;
import org.jboss.weld.WeldException;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.Strings;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private List<Decorator<?>> decorators;
    private Class<T> proxyClassForDecorators;
    private final ThreadLocal<Integer> decoratorStackPosition;
    private final ThreadLocal<T> decoratedActualInstance = new ThreadLocal();
    private boolean hasSerializationOrInvocationInterceptorMethods;
    private WeldMethod<?, ?> postConstruct;
    private WeldMethod<?, ?> preDestroy;
    private InjectionTarget<T> injectionTarget;

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl manager) {
        super(idSuffix, manager);
        this.annotatedItem = type;
        this.decoratorStackPosition = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        this.initStereotypes();
        this.initAlternative();
        this.initInitializerMethods();
        this.initInjectableFields();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkBeanImplementation();
        if (this.isInterceptionCandidate()) {
            this.initCdiBoundInterceptors();
            this.initDirectlyDefinedInterceptors();
        }
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.initDecorators();
        if (this.hasDecorators()) {
            this.initProxyClassForDecoratedBean();
        }
    }

    @Override
    public void checkType() {
    }

    public void initDecorators() {
        this.decorators = this.getManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        this.proxyClassForDecorators = Proxies.createProxyClass(Proxies.TypeInfo.of(this.getTypes()).add((Type)((Object)TargetInstanceProxy.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        boolean outside;
        ArrayList<SerializableContextualInstance<Decorator<Object>, Object>> decoratorInstances = new ArrayList<SerializableContextualInstance<Decorator<Object>, Object>>();
        InjectionPoint ip = originalInjectionPoint;
        boolean bl = outside = this.decoratorStackPosition.get() == 0;
        if (outside) {
            this.decoratedActualInstance.set(instance);
        }
        try {
            int i = this.decoratorStackPosition.get();
            while (i < this.decorators.size()) {
                Decorator<?> decorator = this.decorators.get(i);
                this.decoratorStackPosition.set(++i);
                Object decoratorInstance = this.getManager().getReference(ip, decorator, creationalContext);
                decoratorInstances.add(new SerializableContextualInstanceImpl(decorator, decoratorInstance, null));
                ip = Beans.getDelegateInjectionPoint(decorator);
                if (ip != null) continue;
                throw new ForbiddenStateException(BeanMessage.NON_CONTAINER_DECORATOR, decorator);
            }
        }
        finally {
            if (outside) {
                this.decoratorStackPosition.remove();
            }
        }
        try {
            T proxy = this.proxyClassForDecorators.newInstance();
            ((ProxyObject)proxy).setHandler(new DecoratorProxyMethodHandler(decoratorInstances, this.decoratedActualInstance.get()));
            T t = proxy;
            return t;
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        finally {
            if (outside) {
                this.decoratedActualInstance.set(null);
            }
        }
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        this.type = this.getAnnotatedItem().getJavaClass();
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem);
        this.addInjectionPoints(Beans.getFieldInjectionPoints(this, this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods));
    }

    @Override
    protected void initScopeType() {
        for (WeldClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(((Annotation)scopeTypes.iterator().next()).annotationType())) break;
                this.scopeType = ((Annotation)scopeTypes.iterator().next()).annotationType();
                log.trace(BeanMessage.USING_SCOPE, this.scopeType, this);
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getWeldSuperclass() == null || this.getAnnotatedItem().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    public WeldClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        return name;
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    protected void initPostConstruct() {
        this.postConstruct = Beans.getPostConstruct(this.getAnnotatedItem());
    }

    protected void initPreDestroy() {
        this.preDestroy = Beans.getPreDestroy(this.getAnnotatedItem());
    }

    public WeldMethod<?, ?> getPostConstruct() {
        return this.postConstruct;
    }

    public WeldMethod<?, ?> getPreDestroy() {
        return this.preDestroy;
    }

    protected abstract boolean isInterceptionCandidate();

    protected static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl manager, Set<Annotation> annotations) {
        HashSet<Annotation> foundInterceptionBindingTypes = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!manager.isInterceptorBinding(annotation.annotationType())) continue;
            foundInterceptionBindingTypes.add(annotation);
            foundInterceptionBindingTypes.addAll(manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotation.annotationType()).getInheritedInterceptionBindingTypes());
        }
        return foundInterceptionBindingTypes;
    }

    protected void initCdiBoundInterceptors() {
        if (this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) == null) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), SerializableContextual.class);
            Set<Annotation> classBindingAnnotations = AbstractClassBean.flattenInterceptorBindings(this.manager, this.getAnnotatedItem().getAnnotations());
            for (Class<Annotation> annotation : this.getStereotypes()) {
                classBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, this.manager.getStereotypeDefinition(annotation)));
            }
            if (classBindingAnnotations.size() > 0) {
                if (Beans.findInterceptorBindingConflicts(this.manager, classBindingAnnotations)) {
                    throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
                }
                Annotation[] classBindingAnnotationsArray = classBindingAnnotations.toArray(new Annotation[0]);
                List<Interceptor<?>> resolvedPostConstructInterceptors = this.manager.resolveInterceptors(InterceptionType.POST_CONSTRUCT, classBindingAnnotationsArray);
                builder.interceptPostConstruct().with(AbstractClassBean.toSerializableContextualArray(resolvedPostConstructInterceptors));
                List<Interceptor<?>> resolvedPreDestroyInterceptors = this.manager.resolveInterceptors(InterceptionType.PRE_DESTROY, classBindingAnnotationsArray);
                builder.interceptPreDestroy().with(AbstractClassBean.toSerializableContextualArray(resolvedPreDestroyInterceptors));
                List<Interceptor<?>> resolvedPrePassivateInterceptors = this.manager.resolveInterceptors(InterceptionType.PRE_PASSIVATE, classBindingAnnotationsArray);
                builder.interceptPrePassivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPrePassivateInterceptors));
                List<Interceptor<?>> resolvedPostActivateInterceptors = this.manager.resolveInterceptors(InterceptionType.POST_ACTIVATE, classBindingAnnotationsArray);
                builder.interceptPostActivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPostActivateInterceptors));
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getAnnotatedItem());
            for (WeldMethod<?, ?> method : businessMethods) {
                List<Interceptor<?>> methodBoundInterceptors;
                HashSet<Annotation> methodBindingAnnotations = new HashSet<Annotation>(classBindingAnnotations);
                methodBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, method.getAnnotations()));
                if (methodBindingAnnotations.size() <= 0) continue;
                if (Beans.findInterceptorBindingConflicts(this.manager, classBindingAnnotations)) {
                    throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType() + "." + method.getName() + "()");
                }
                if (method.isAnnotationPresent(this.manager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    methodBoundInterceptors = this.manager.resolveInterceptors(InterceptionType.AROUND_TIMEOUT, methodBindingAnnotations.toArray(new Annotation[0]));
                    builder.interceptAroundTimeout(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
                    continue;
                }
                methodBoundInterceptors = this.manager.resolveInterceptors(InterceptionType.AROUND_INVOKE, methodBindingAnnotations.toArray(new Annotation[0]));
                builder.interceptAroundInvoke(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
            }
            InterceptionModel serializableContextualInterceptionModel = builder.build();
            if (serializableContextualInterceptionModel.getAllInterceptors().size() > 0) {
                this.manager.getCdiInterceptorsRegistry().registerInterceptionModel(this.getType(), serializableContextualInterceptionModel);
            }
        }
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        WeldMethod<?, ?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, preDestroy, instance);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        WeldMethod<?, ?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, postConstruct, instance);
            }
        }
    }

    private static SerializableContextual[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(new SerializableContextualImpl(interceptor));
        }
        return serializableContextuals.toArray(new SerializableContextual[0]);
    }

    public boolean hasCdiBoundInterceptors() {
        if (this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    public boolean hasDirectlyDefinedInterceptors() {
        if (this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.hasSerializationOrInvocationInterceptorMethods || this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    protected void initDirectlyDefinedInterceptors() {
        if (this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) == null && InterceptionUtils.supportsEjb3InterceptorDeclaration()) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), Class.class);
            Class<?>[] classDeclaredInterceptors = null;
            if (this.getAnnotatedItem().isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                Annotation interceptorsAnnotation = this.getType().getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass());
                classDeclaredInterceptors = Reflections.extractValues(interceptorsAnnotation);
            }
            if (classDeclaredInterceptors != null) {
                builder.interceptAll().with(classDeclaredInterceptors);
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getAnnotatedItem());
            for (WeldMethod<?, ?> method : businessMethods) {
                boolean excludeClassInterceptors = method.isAnnotationPresent(InterceptionUtils.getExcludeClassInterceptorsAnnotationClass());
                Class<?>[] methodDeclaredInterceptors = null;
                if (method.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                    methodDeclaredInterceptors = Reflections.extractValues(method.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass()));
                }
                if (excludeClassInterceptors) {
                    builder.ignoreGlobalInterceptors(method.getJavaMember());
                }
                if (methodDeclaredInterceptors == null) continue;
                if (method.isAnnotationPresent(this.manager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    builder.interceptAroundTimeout(method.getJavaMember()).with(methodDeclaredInterceptors);
                    continue;
                }
                builder.interceptAroundInvoke(method.getJavaMember()).with(methodDeclaredInterceptors);
            }
            InterceptionModel interceptionModel = builder.build();
            InterceptorClassMetadataImpl interceptorClassMetadata = new InterceptorClassMetadataImpl(this.getType());
            boolean bl = this.hasSerializationOrInvocationInterceptorMethods = !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_INVOKE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_TIMEOUT).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.PRE_PASSIVATE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.POST_ACTIVATE).isEmpty();
            if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
                this.manager.getClassDeclaredInterceptorsRegistry().registerInterceptionModel(this.getType(), builder.build());
            }
        }
    }
}

