/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.bridgemgr;

import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrException;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrHelpPrinter;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrOptionParser;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrOptions;
import com.sun.messaging.bridge.admin.bridgemgr.BridgeMgrProperties;
import com.sun.messaging.bridge.admin.bridgemgr.CmdRunner;
import com.sun.messaging.bridge.admin.bridgemgr.Globals;
import com.sun.messaging.bridge.admin.bridgemgr.resources.BridgeAdminResources;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.util.options.OptionException;
import java.util.Properties;

public class BridgeMgr
implements BridgeMgrOptions {
    private static BridgeAdminResources ar = Globals.getBridgeAdminResources();

    public static void main(String[] stringArray) {
        Object object;
        BridgeMgrOptions bridgeMgrOptions;
        int n = 0;
        if (BridgeMgr.silentModeOptionSpecified(stringArray)) {
            Globals.setSilentMode(true);
        }
        if (BridgeMgr.shortHelpOptionSpecified(stringArray)) {
            bridgeMgrOptions = new BridgeMgrHelpPrinter();
            ((BridgeMgrHelpPrinter)bridgeMgrOptions).printShortHelp(0);
        } else if (BridgeMgr.longHelpOptionSpecified(stringArray)) {
            bridgeMgrOptions = new BridgeMgrHelpPrinter();
            ((BridgeMgrHelpPrinter)bridgeMgrOptions).printLongHelp();
        }
        if (BridgeMgr.versionOptionSpecified(stringArray)) {
            CommonCmdRunnerUtil.printBanner();
            CommonCmdRunnerUtil.printVersion();
            System.exit(0);
        }
        bridgeMgrOptions = null;
        try {
            bridgeMgrOptions = BridgeMgrOptionParser.parseArgs(stringArray);
        }
        catch (OptionException optionException) {
            CommonCmdRunnerUtil.handleArgsParsingExceptions(optionException, "-p", "imqbridgemgr");
            System.exit(1);
        }
        try {
            BridgeMgr.checkOptions((BridgeMgrProperties)bridgeMgrOptions);
        }
        catch (BridgeMgrException bridgeMgrException) {
            BridgeMgr.handleCheckOptionsExceptions(bridgeMgrException);
            System.exit(1);
        }
        Properties properties = ((BridgeMgrProperties)bridgeMgrOptions).getSysProps();
        if (properties != null && properties.size() > 0) {
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = properties.getProperty(string);
                if (((BridgeMgrProperties)bridgeMgrOptions).adminDebugModeSet()) {
                    Globals.stdOutPrintln("Setting system property: " + string + "=" + string2);
                }
                try {
                    System.setProperty(string, string2);
                }
                catch (Exception exception) {
                    Globals.stdErrPrintln("Failed to set system property: " + string + "=" + string2);
                    Globals.stdErrPrintln(exception.toString());
                }
            }
        }
        object = new CmdRunner((BridgeMgrProperties)bridgeMgrOptions);
        n = ((CmdRunner)object).runCommand();
        System.exit(n);
    }

    private static void checkOptions(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        String string;
        String string2;
        if (bridgeMgrProperties.debugModeSet() || bridgeMgrProperties.noCheckModeSet()) {
            if (bridgeMgrProperties.adminDebugModeSet()) {
                Globals.stdOutPrintln("Option checking turned off.");
            }
            return;
        }
        if (bridgeMgrProperties.adminDebugModeSet()) {
            Globals.stdErrPrintln("BridgeMgrProperties dump:");
            bridgeMgrProperties.list(System.err);
            Globals.stdErrPrintln("-------------\n");
            Globals.stdErrPrintln("Command: " + bridgeMgrProperties.getCommand());
            Globals.stdErrPrintln("Command Argument: " + bridgeMgrProperties.getCommandArg());
            Globals.stdErrPrintln("Broker Host/Port: " + bridgeMgrProperties.getBrokerHostPort());
            Globals.stdErrPrintln("Admin User ID: " + bridgeMgrProperties.getAdminUserId());
            Globals.stdErrPrintln("Admin User Password: " + bridgeMgrProperties.getAdminPasswd());
        }
        if ((string2 = bridgeMgrProperties.getCommand()) == null) {
            BridgeMgrException bridgeMgrException = new BridgeMgrException(10000);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            throw bridgeMgrException;
        }
        if (string2.equals("list")) {
            BridgeMgr.checkList(bridgeMgrProperties);
        } else if (string2.equals("pause")) {
            BridgeMgr.checkPause(bridgeMgrProperties);
        } else if (string2.equals("resume")) {
            BridgeMgr.checkResume(bridgeMgrProperties);
        } else if (string2.equals("start")) {
            BridgeMgr.checkStart(bridgeMgrProperties);
        } else if (string2.equals("stop")) {
            BridgeMgr.checkStop(bridgeMgrProperties);
        } else if (!bridgeMgrProperties.debugModeSet() || !string2.equals("debug")) {
            BridgeMgrException bridgeMgrException = new BridgeMgrException(10001);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            throw bridgeMgrException;
        }
        String string3 = bridgeMgrProperties.getProperty("receiveTimeout");
        if (string3 != null) {
            try {
                int n = BridgeMgr.checkIntegerValue(bridgeMgrProperties, "receiveTimeout", string3);
            }
            catch (Exception exception) {
                BridgeMgrException bridgeMgrException = new BridgeMgrException(10004);
                bridgeMgrException.setProperties(bridgeMgrProperties);
                bridgeMgrException.setErrorString(string3);
                throw bridgeMgrException;
            }
        }
        if ((string = bridgeMgrProperties.getProperty("numRetries")) != null) {
            try {
                int n = BridgeMgr.checkIntegerValue(bridgeMgrProperties, "numRetries", string);
            }
            catch (Exception exception) {
                BridgeMgrException bridgeMgrException = new BridgeMgrException(10005);
                bridgeMgrException.setProperties(bridgeMgrProperties);
                bridgeMgrException.setErrorString(string);
                throw bridgeMgrException;
            }
        }
    }

    private static void checkList(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProperties, CMD_LIST_VALID_CMDARGS);
        String string = bridgeMgrProperties.getCommandArg();
        if (string.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProperties);
            BridgeMgr.checkLinkName(bridgeMgrProperties);
        }
    }

    private static void checkPause(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProperties, CMD_PAUSE_VALID_CMDARGS);
        String string = bridgeMgrProperties.getCommandArg();
        if (string.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProperties);
            BridgeMgr.checkLinkName(bridgeMgrProperties);
        }
    }

    private static void checkResume(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProperties, CMD_RESUME_VALID_CMDARGS);
        String string = bridgeMgrProperties.getCommandArg();
        if (string.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProperties);
            BridgeMgr.checkLinkName(bridgeMgrProperties);
        }
    }

    private static void checkStart(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProperties, CMD_START_VALID_CMDARGS);
        String string = bridgeMgrProperties.getCommandArg();
        if (string.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProperties);
            BridgeMgr.checkLinkName(bridgeMgrProperties);
        }
    }

    private static void checkStop(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        BridgeMgr.checkCmdArg(bridgeMgrProperties, CMD_STOP_VALID_CMDARGS);
        String string = bridgeMgrProperties.getCommandArg();
        if (string.equals("link")) {
            BridgeMgr.checkBridgeName(bridgeMgrProperties);
            BridgeMgr.checkLinkName(bridgeMgrProperties);
        }
    }

    private static int checkIntegerValue(BridgeMgrProperties bridgeMgrProperties, String string, String string2) throws BridgeMgrException {
        int n;
        BridgeMgrException bridgeMgrException = null;
        try {
            n = Integer.parseInt(string2);
            if (n < -1) {
                bridgeMgrException = new BridgeMgrException(10008);
                bridgeMgrException.setProperties(bridgeMgrProperties);
                bridgeMgrException.setErrorString(string);
                throw bridgeMgrException;
            }
        }
        catch (Exception exception) {
            bridgeMgrException = new BridgeMgrException(10008);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            bridgeMgrException.setErrorString(string);
            throw bridgeMgrException;
        }
        return n;
    }

    private static void checkCmdArg(BridgeMgrProperties bridgeMgrProperties, String[] stringArray) throws BridgeMgrException {
        String string = bridgeMgrProperties.getCommandArg();
        if (string == null) {
            BridgeMgrException bridgeMgrException = new BridgeMgrException(10002);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            throw bridgeMgrException;
        }
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            if (string.equals("bridge") && bridgeMgrProperties.getLinkName() != null) {
                BridgeMgrException bridgeMgrException = new BridgeMgrException(5002);
                bridgeMgrException.setProperties(bridgeMgrProperties);
                throw bridgeMgrException;
            }
            return;
        }
        BridgeMgrException bridgeMgrException = new BridgeMgrException(10003);
        bridgeMgrException.setProperties(bridgeMgrProperties);
        bridgeMgrException.setValidCmdArgs(stringArray);
        throw bridgeMgrException;
    }

    private static void checkBridgeName(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        String string = bridgeMgrProperties.getBridgeName();
        if (string == null || string.trim().length() == 0) {
            BridgeMgrException bridgeMgrException = new BridgeMgrException(5000);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            throw bridgeMgrException;
        }
    }

    private static void checkLinkName(BridgeMgrProperties bridgeMgrProperties) throws BridgeMgrException {
        String string = bridgeMgrProperties.getLinkName();
        if (string == null || string.trim().length() == 0) {
            BridgeMgrException bridgeMgrException = new BridgeMgrException(5001);
            bridgeMgrException.setProperties(bridgeMgrProperties);
            throw bridgeMgrException;
        }
    }

    private static boolean shortHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-H") && !stringArray[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-v") && !stringArray[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void handleCheckOptionsExceptions(BridgeMgrException bridgeMgrException) {
        BridgeMgrProperties bridgeMgrProperties = (BridgeMgrProperties)bridgeMgrException.getProperties();
        String string = bridgeMgrProperties.getCommand();
        String string2 = bridgeMgrProperties.getCommandArg();
        String[] stringArray = bridgeMgrException.getValidCmdArgs();
        String[] stringArray2 = bridgeMgrException.getValidAttrs();
        String string3 = bridgeMgrException.getBadAttr();
        String string4 = bridgeMgrException.getBadValue();
        String string5 = bridgeMgrException.getErrorString();
        int n = bridgeMgrException.getType();
        switch (n) {
            case 5000: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3000", "-bn"));
                break;
            }
            case 5001: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3001", "-ln"));
                break;
            }
            case 5002: {
                Globals.stdErrPrintln(ar.getString("BA1080"), ar.getKString("BA3002", "-ln", string + " " + string2));
                break;
            }
            default: {
                CommonCmdRunnerUtil.handleCommonCheckOptionsExceptions(bridgeMgrException, string, string2, new BridgeMgrHelpPrinter());
            }
        }
    }
}

