/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPAdapterRegistry;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.webservices.AdapterInvocationInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.transport.tcp.AppServRegistry;
import org.glassfish.webservices.transport.tcp.Ejb109Adapter;
import org.glassfish.webservices.transport.tcp.ServletFakeArtifactSet;
import org.glassfish.webservices.transport.tcp.V3Module;
import org.glassfish.webservices.transport.tcp.WSEndpointDescriptor;
import org.glassfish.webservices.transport.tcp.Web109Adapter;

public final class WSTCPAdapterRegistryImpl
implements WSTCPAdapterRegistry {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    final Map<String, RegistryRecord> registry = new ConcurrentHashMap<String, RegistryRecord>();
    private static final WSTCPAdapterRegistryImpl instance = new WSTCPAdapterRegistryImpl();

    private WSTCPAdapterRegistryImpl() {
    }

    @NotNull
    public static WSTCPAdapterRegistryImpl getInstance() {
        return instance;
    }

    public TCPAdapter getTarget(@NotNull WSTCPURI requestURI) {
        RegistryRecord record = requestURI.path.length() > 0 && !requestURI.path.equals("/") ? this.registry.get(requestURI.path) : this.registry.get("/");
        if (record != null) {
            if (record.adapter == null) {
                try {
                    record.adapter = this.createWSAdapter(requestURI.path, record.wsEndpointDescriptor);
                    logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. Register adapter. Path: {0}", requestURI.path);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WSTCPAdapterRegistryImpl. " + MessagesMessages.WSTCP_0008_ERROR_TCP_ADAPTER_CREATE((Object)record.wsEndpointDescriptor.getWSServiceName()), e);
                }
            }
            return record.adapter;
        }
        return null;
    }

    public void registerEndpoint(@NotNull String path, @NotNull WSEndpointDescriptor wsEndpointDescriptor) {
        this.registry.put(path, new RegistryRecord(wsEndpointDescriptor));
    }

    public void deregisterEndpoint(@NotNull String path) {
        logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. DeRegister adapter for {0}", path);
        this.registry.remove(path);
    }

    public WSEndpointDescriptor lookupEndpoint(@NotNull String path) {
        RegistryRecord record = this.registry.get(path);
        return record != null ? record.wsEndpointDescriptor : null;
    }

    private TCPAdapter createWSAdapter(@NotNull String wsPath, @NotNull WSEndpointDescriptor wsEndpointDescriptor) throws Exception {
        if (wsEndpointDescriptor.isEJB()) {
            EjbRuntimeEndpointInfo ejbEndPtInfo = V3Module.getWSEjbEndpointRegistry().getEjbWebServiceEndpoint(wsEndpointDescriptor.getURI(), "POST", null);
            AdapterInvocationInfo adapterInfo = (AdapterInvocationInfo)ejbEndPtInfo.prepareInvocation(true);
            return new Ejb109Adapter(wsEndpointDescriptor.getWSServiceName().toString(), wsPath, adapterInfo.getAdapter().getEndpoint(), new ServletFakeArtifactSet(wsEndpointDescriptor.getRequestURL(), wsEndpointDescriptor.getUrlPattern()), ejbEndPtInfo, adapterInfo);
        }
        String uri = wsEndpointDescriptor.getURI();
        Adapter adapter = JAXWSAdapterRegistry.getInstance().getAdapter(wsEndpointDescriptor.getContextRoot(), uri, uri);
        WebModule webModule = AppServRegistry.getWebModule(wsEndpointDescriptor.getWSServiceEndpoint());
        WebComponentInvocation invocation = new WebComponentInvocation(webModule);
        return new Web109Adapter(wsEndpointDescriptor.getWSServiceName().toString(), wsPath, adapter.getEndpoint(), new ServletFakeArtifactSet(wsEndpointDescriptor.getRequestURL(), wsEndpointDescriptor.getUrlPattern()), (ComponentInvocation)invocation);
    }

    protected static class RegistryRecord {
        public TCPAdapter adapter;
        public WSEndpointDescriptor wsEndpointDescriptor;

        public RegistryRecord(WSEndpointDescriptor wsEndpointDescriptor) {
            this.wsEndpointDescriptor = wsEndpointDescriptor;
        }
    }
}

