/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensibleClassLoader
extends URLClassLoader
implements RepositoryChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ExtensibleClassLoader.class.getName());

    ExtensibleClassLoader(URL[] urls, ClassLoader parent, List<Repository> repos) {
        super(urls, parent);
        for (Repository repo : repos) {
            for (URI uri : repo.getJarLocations()) {
                if (!this.addURI(uri)) continue;
                LOGGER.info("Added " + uri + " to shared classpath");
            }
            repo.addListener(this);
        }
    }

    public void jarAdded(URI uri) {
        this.added(uri);
    }

    public void jarRemoved(URI uri) {
        this.removed(uri);
    }

    @Override
    public void added(URI uri) {
        File file = new File(uri);
        if (file.isDirectory()) {
            LOGGER.info("directory not support, please contribute");
        }
        if (this.addURI(uri)) {
            LOGGER.info("Added " + uri + " to shared classpath, no need to restart appserver");
        }
    }

    @Override
    public void removed(URI uri) {
    }

    @Override
    public void moduleAdded(ModuleDefinition moduleDefinition) {
    }

    @Override
    public void moduleRemoved(ModuleDefinition moduleDefinition) {
    }

    private boolean addURI(URI uri) {
        boolean success = false;
        try {
            super.addURL(uri.toURL());
            success = true;
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Cannot add new added library to shared classpath", e);
        }
        return success;
    }
}

