/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public abstract class AbstractMain
extends PlatformMain {
    final File bootstrapFile = this.findBootstrapFile();
    protected ASMainHelper helper;
    protected final File glassfishDir;
    protected File domainDir;

    abstract Logger getLogger();

    protected abstract String getPreferedCacheDir();

    AbstractMain() {
        System.setProperty("hk2.startup.context.root", this.bootstrapFile.getParent());
        this.glassfishDir = this.bootstrapFile.getParentFile().getParentFile();
        System.setProperty("com.sun.aas.installRoot", this.glassfishDir.getAbsolutePath());
    }

    public void start(String[] args) throws Exception {
        this.helper = new ASMainHelper(this.logger);
        this.helper.parseAsEnv(this.glassfishDir);
        this.run(this.logger, args);
    }

    protected void run(Logger logger, String ... args) throws Exception {
        this.logger = logger;
        StartupContext sc = this.getContext(StartupContext.class);
        if (sc != null) {
            this.domainDir = sc.getUserDirectory();
        }
        if (this.domainDir == null) {
            this.domainDir = this.helper.getDomainRoot(new StartupContext(this.bootstrapFile, args));
            this.helper.verifyAndSetDomainRoot(this.domainDir);
        }
        File cacheProfileDir = new File(this.domainDir, this.getPreferedCacheDir());
        System.setProperty("com.sun.enterprise.hk2.cacheDir", cacheProfileDir.getAbsolutePath());
        this.setUpCache(this.bootstrapFile.getParentFile(), cacheProfileDir);
    }

    protected void setSystemProperties() throws Exception {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        URI installRootURI = new File(installRoot).toURI();
        System.setProperty("com.sun.aas.installRootURI", installRootURI.toString());
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        URI instanceRootURI = new File(instanceRoot).toURI();
        System.setProperty("com.sun.aas.instanceRootURI", instanceRootURI.toString());
    }

    protected abstract void setUpCache(File var1, File var2) throws IOException;

    protected File findBootstrapFile() {
        try {
            return Which.jarFile(this.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + this.getClass() + " class location, aborting");
        }
    }
}

