/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.digester.Digester;

public class StandardHostDeployer
implements Deployer {
    private static Logger log = Logger.getLogger(StandardHostDeployer.class.getName());
    private ContextRuleSet contextRuleSet = null;
    private Digester digester = null;
    protected StandardHost host = null;
    private NamingRuleSet namingRuleSet = null;
    private String overrideDocBase = null;
    private String overrideConfigFile = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public StandardHostDeployer() {
    }

    public StandardHostDeployer(StandardHost host) {
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = (StandardHost)host;
    }

    public String getName() {
        return this.host.getName();
    }

    public synchronized void install(String contextPath, URL war) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        log.info(sm.getString("standardHost.installing", (Object)contextPath, war.toString()));
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;
        if (url.startsWith("jar:")) {
            if (!(url = url.substring(4, url.length() - 2)).toLowerCase().endsWith(".war")) {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
            isWAR = true;
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
        }
        boolean isAppBase = false;
        File appBase = new File(this.host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        File contextFile = new File(docBase);
        File baseDir = contextFile.getParentFile();
        if (appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
            isAppBase = true;
        }
        if (!this.host.isDeployXML() && !isAppBase) {
            throw new IllegalArgumentException(sm.getString("standardHost.installBase", url));
        }
        if (isAppBase && this.host.getAutoDeploy()) {
            String filename = contextFile.getName();
            if (isWAR) {
                filename = filename.substring(0, filename.length() - 4);
            }
            if (contextPath.length() == 0) {
                if (!filename.equals("ROOT")) {
                    throw new IllegalArgumentException(sm.getString("standardHost.pathMatch", (Object)"/", "ROOT"));
                }
            } else if (!filename.equals(contextPath.substring(1))) {
                throw new IllegalArgumentException(sm.getString("standardHost.pathMatch", (Object)contextPath, filename));
            }
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = ExpandWar.expand(this.host, war, contextPath);
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre-install", context);
            this.host.addChild(context);
            this.host.fireContainerEvent("install", context);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.INFO, "", e);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error installing", e);
            throw new IOException(e.toString());
        }
    }

    public synchronized void install(String contextPath, URL war, String configFile) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        log.info(sm.getString("standardHost.installing", (Object)contextPath, war.toString()));
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;
        if (url.startsWith("jar:")) {
            if (!(url = url.substring(4, url.length() - 2)).toLowerCase().endsWith(".war")) {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
            isWAR = true;
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = ExpandWar.expand(this.host, war, contextPath);
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            context.setConfigFile(configFile);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre-install", context);
            this.host.addChild(context);
            this.host.fireContainerEvent("install", context);
            Engine engine = (Engine)this.host.getParent();
            StandardServer server = (StandardServer)engine.getService().getServer();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sm.getString("standardHost.installError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public synchronized void install(URL config, URL war) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.configRequired"));
        }
        if (!this.host.isDeployXML()) {
            throw new IllegalArgumentException(sm.getString("standardHost.configNotAllowed"));
        }
        log.info(sm.getString("standardHost.installingXML", config));
        String docBase = null;
        boolean isWAR = false;
        if (war != null) {
            String url = war.toString();
            log.info(sm.getString("standardHost.installingWAR", url));
            if (url.startsWith("jar:")) {
                url = url.substring(4, url.length() - 2);
                isWAR = true;
            }
            if (url.startsWith("file://")) {
                docBase = url.substring(7);
            } else if (url.startsWith("file:")) {
                docBase = url.substring(5);
            } else {
                throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
            }
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = ExpandWar.expand(this.host, war);
        }
        this.overrideDocBase = docBase;
        if (config.toString().startsWith("file:")) {
            this.overrideConfigFile = config.getFile();
        }
        InputStream stream = null;
        try {
            stream = config.openStream();
            Digester digester = this.createDigester();
            digester.setDebug(this.host.getDebug());
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.clear();
            digester.push(this);
            digester.parse(stream);
            stream.close();
            stream = null;
        }
        catch (Exception e) {
            this.host.log(sm.getString("standardHost.installError", docBase), e);
            throw new IOException(e.toString());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
            this.overrideDocBase = null;
            this.overrideConfigFile = null;
        }
    }

    public Context findDeployedApp(String contextPath) {
        return (Context)this.host.findChild(contextPath);
    }

    public String[] findDeployedApps() {
        Container[] children = this.host.findChildren();
        String[] results = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            results[i] = children[i].getName();
        }
        return results;
    }

    public void remove(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info(sm.getString("standardHost.removing", contextPath));
        try {
            this.host.removeChild(context);
            this.host.fireContainerEvent("remove", context);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sm.getString("standardHost.removeError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        this.host.log(sm.getString("standardHost.removing", contextPath));
        try {
            File workDir = (File)context.getServletContext().getAttribute("javax.servlet.context.tempdir");
            String configFile = context.getConfigFile();
            this.host.removeChild(context);
            if (undeploy) {
                File contextFile;
                File baseDir;
                boolean isAppBase = false;
                File appBase = new File(this.host.getAppBase());
                if (!appBase.isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
                }
                if ((baseDir = (contextFile = new File(context.getDocBase())).getParentFile()) == null || appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
                    isAppBase = true;
                }
                boolean isWAR = false;
                if (contextFile.getName().toLowerCase().endsWith(".war")) {
                    isWAR = true;
                }
                if (isAppBase && this.host.getAutoDeploy()) {
                    String filename = contextFile.getName();
                    if (isWAR) {
                        filename = filename.substring(0, filename.length() - 4);
                    }
                    if (contextPath.length() == 0 && filename.equals("ROOT") || filename.equals(contextPath.substring(1))) {
                        if (!isWAR) {
                            File contextWAR;
                            long contextLastModified = contextFile.lastModified();
                            if (contextFile.isDirectory()) {
                                this.deleteDir(contextFile);
                            }
                            if (this.host.isUnpackWARs() && (contextWAR = new File(context.getDocBase() + ".war")).exists() && contextLastModified > contextWAR.lastModified()) {
                                contextWAR.delete();
                            }
                        } else {
                            contextFile.delete();
                        }
                    }
                    if (this.host.isDeployXML() && configFile != null) {
                        File docBaseXml = new File(configFile);
                        docBaseXml.delete();
                    }
                }
                if (workDir == null && context instanceof StandardContext && ((StandardContext)context).getWorkDir() != null) {
                    workDir = new File(((StandardContext)context).getWorkPath());
                }
                if (workDir != null && workDir.exists()) {
                    this.deleteDir(workDir);
                }
            }
            this.host.fireContainerEvent("remove", context);
        }
        catch (Exception e) {
            this.host.log(sm.getString("standardHost.removeError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public void start(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info(sm.getString("standardHost.start", contextPath));
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (LifecycleException e) {
            log.log(Level.SEVERE, sm.getString("standardHost.start", contextPath), e);
            throw new IllegalStateException(sm.getString("standardHost.start", contextPath), e);
        }
    }

    public void stop(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        log.info(sm.getString("standardHost.stop", contextPath));
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (LifecycleException e) {
            log.log(Level.SEVERE, sm.getString("standardHost.stop", contextPath), e);
            throw new IllegalStateException(sm.getString("standardHost.stop", contextPath), e);
        }
    }

    public void addChild(Container child) {
        Context context = (Context)child;
        String contextPath = context.getPath();
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.host.findChild(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (this.overrideDocBase != null) {
            context.setDocBase(this.overrideDocBase);
        }
        if (this.overrideConfigFile != null) {
            context.setConfigFile(this.overrideConfigFile);
        }
        this.host.fireContainerEvent("pre-install", context);
        this.host.addChild(child);
        this.host.fireContainerEvent("install", context);
    }

    public ClassLoader getParentClassLoader() {
        return this.host.getParentClassLoader();
    }

    protected Digester createDigester() {
        if (this.digester == null) {
            this.digester = new Digester();
            if (this.host.getDebug() > 0) {
                this.digester.setDebug(3);
            }
            this.digester.setValidating(false);
            this.contextRuleSet = new ContextRuleSet("");
            this.digester.addRuleSet(this.contextRuleSet);
            this.namingRuleSet = new NamingRuleSet("Context/");
            this.digester.addRuleSet(this.namingRuleSet);
        }
        return this.digester;
    }

    protected void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }
}

