/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util;

import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyValidatorFactory
implements ValidatorFactory {
    private final Configuration<?> configuration;
    private volatile ValidatorFactory delegate;

    public LazyValidatorFactory() {
        this(null);
    }

    public LazyValidatorFactory(Configuration<?> configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            LazyValidatorFactory lazyValidatorFactory = this;
            synchronized (lazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    @Override
    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    private ValidatorFactory initFactory() {
        if (this.configuration == null) {
            return Validation.buildDefaultValidatorFactory();
        }
        return this.configuration.buildValidatorFactory();
    }

    @Override
    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return this.getDelegate().unwrap(clazz);
    }
}

