/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;

class TerminalReader
extends Reader {
    protected InputStream m_In;
    protected PrintStream m_Out;
    protected boolean m_Echo = false;
    protected boolean m_EOF = false;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte DEL = 127;
    public static final byte CTRL_U = 21;
    private static byte ESC = (byte)27;
    private static byte[] CURSOR_LEFT = new byte[]{ESC, 91, 49, 68};
    private static byte[] ERASE_TEOL = new byte[]{ESC, 91, 75};
    private static byte[] CRLF = new byte[]{13, 10};
    private static byte EOT = (byte)4;

    public TerminalReader(InputStream in, PrintStream out) {
        this.m_In = in;
        this.m_Out = out;
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean echo) {
        this.m_Echo = echo;
    }

    public int read(char[] chars, int off, int len) throws IOException {
        if (this.m_EOF) {
            return -1;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = this.m_In.read();
            if (ch == EOT || i == off && ch == -1) {
                return -1;
            }
            chars[i] = (char)ch;
            if (ch == -1 || ch == 10 || ch == 13) {
                this.m_EOF = ch == -1;
                int read = i - off + 1;
                if (this.m_Echo) {
                    this.m_Out.write(CRLF);
                }
                return read;
            }
            if (ch == 8 || ch == 127) {
                if (i > off) {
                    i -= 2;
                    this.moveLeft(1);
                    this.eraseToEndOfLine();
                    continue;
                }
                --i;
                this.bell();
                continue;
            }
            if (ch == 21) {
                this.moveLeft(i - off);
                this.eraseToEndOfLine();
                i = off - 1;
                continue;
            }
            if (!this.m_Echo) continue;
            this.m_Out.write(chars[i]);
        }
        return len;
    }

    private void bell() {
        this.m_Out.write(7);
        this.m_Out.flush();
    }

    private void moveLeft(int i) throws IOException {
        TerminalReader.CURSOR_LEFT[2] = Byte.decode(Integer.toString(i));
        this.m_Out.write(CURSOR_LEFT);
        this.m_Out.flush();
    }

    private void eraseToEndOfLine() throws IOException {
        this.m_Out.write(ERASE_TEOL);
        this.m_Out.flush();
    }

    public void close() throws IOException {
        this.m_In.close();
    }
}

