/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerContextTask;
import com.sun.grizzly.Context;
import com.sun.grizzly.ContextTask;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainContextTask;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueReaderContextTask;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncQueueWriterContextTask;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOContext
implements Context {
    private Context.OpType currentOpType;
    private ProtocolChain protocolChain;
    private Map<String, Object> attributes = null;
    private SelectionKey key;
    private SelectorHandler selectorHandler;
    private Controller controller;
    private Context.KeyRegistrationState keyRegistrationState = Context.KeyRegistrationState.REGISTER;
    private ExecutorService threadPool;
    private IOEvent<Context> ioEvent;
    private AsyncQueueReader asyncQueueReader;
    private AsyncQueueWriter asyncQueueWriter;
    private AsyncQueueReadable asyncQueueReadable;
    private AsyncQueueWritable asyncQueueWritable;
    private boolean isSuspended = false;
    private AtomicInteger refCounter = new AtomicInteger(1);
    private ProtocolChainContextTask protocolChainContextTask;
    private CallbackHandlerContextTask callbackHandlerContextTask;
    private AsyncQueueReaderContextTask asyncQueueReaderContextTask;
    private AsyncQueueWriterContextTask asyncQueueWriterContextTask;

    public void copyTo(Copyable copy) {
        NIOContext copyContext = (NIOContext)copy;
        copyContext.currentOpType = this.currentOpType;
        copyContext.protocolChain = this.protocolChain;
        if (this.attributes != null) {
            copyContext.attributes = new HashMap<String, Object>(this.attributes);
        }
        copyContext.key = this.key;
        copyContext.selectorHandler = this.selectorHandler;
        copyContext.controller = this.controller;
        copyContext.keyRegistrationState = this.keyRegistrationState;
        copyContext.threadPool = this.threadPool;
        copyContext.ioEvent = this.ioEvent;
        copyContext.asyncQueueReader = this.asyncQueueReader;
        copyContext.asyncQueueWriter = this.asyncQueueWriter;
    }

    public ProtocolChainContextTask getProtocolChainContextTask() {
        if (this.protocolChainContextTask == null) {
            this.protocolChainContextTask = new ProtocolChainContextTask();
        }
        return this.protocolChainContextTask;
    }

    public CallbackHandlerContextTask getCallbackHandlerContextTask(CallbackHandler callbackHandler) {
        if (this.callbackHandlerContextTask == null) {
            this.callbackHandlerContextTask = new CallbackHandlerContextTask(callbackHandler);
        } else {
            this.callbackHandlerContextTask.setCallBackHandler(callbackHandler);
        }
        return this.callbackHandlerContextTask;
    }

    public AsyncQueueReaderContextTask getAsyncQueueReaderContextTask(AsyncQueueReader asyncQueueReader) {
        if (this.asyncQueueReaderContextTask == null) {
            this.asyncQueueReaderContextTask = new AsyncQueueReaderContextTask(asyncQueueReader);
        } else {
            this.asyncQueueReaderContextTask.setAsyncQueueReader(asyncQueueReader);
        }
        return this.asyncQueueReaderContextTask;
    }

    public AsyncQueueWriterContextTask getAsyncQueueWriterContextTask(AsyncQueueWriter asyncQueueWriter) {
        if (this.asyncQueueWriterContextTask == null) {
            this.asyncQueueWriterContextTask = new AsyncQueueWriterContextTask(asyncQueueWriter);
        } else {
            this.asyncQueueWriterContextTask.setAsyncQueueWriter(asyncQueueWriter);
        }
        return this.asyncQueueWriterContextTask;
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public AttributeHolder getAttributeHolderByScope(Context.AttributeScope scope) {
        AttributeHolder holder = null;
        switch (scope) {
            case REQUEST: {
                holder = this;
                break;
            }
            case CONNECTION: {
                Object attachment = this.getSelectionKey().attachment();
                if (!(attachment instanceof AttributeHolder)) break;
                holder = (AttributeHolder)attachment;
                break;
            }
            case SELECTOR: {
                holder = this.selectorHandler;
                break;
            }
            case CONTROLLER: {
                holder = this.controller;
            }
        }
        return holder;
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void recycle() {
        if (this.isSuspended) {
            throw new IllegalStateException("The Context has been marked as suspended and cannot be recycled");
        }
        this.getProtocolChainInstanceHandler().offer(this.protocolChain);
        this.key = null;
        this.keyRegistrationState = Context.KeyRegistrationState.REGISTER;
        this.currentOpType = null;
        this.protocolChain = null;
        this.ioEvent = null;
        this.asyncQueueReader = null;
        this.asyncQueueWriter = null;
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.isSuspended = false;
        this.refCounter.set(1);
    }

    @Override
    public Context.KeyRegistrationState getKeyRegistrationState() {
        return this.keyRegistrationState;
    }

    @Override
    public void setKeyRegistrationState(Context.KeyRegistrationState keyRegistrationState) {
        this.keyRegistrationState = keyRegistrationState;
    }

    @Override
    public ProtocolChain getProtocolChain() {
        return this.protocolChain;
    }

    @Override
    public void setProtocolChain(ProtocolChain protocolChain) {
        this.protocolChain = protocolChain;
    }

    @Override
    public Context.OpType getCurrentOpType() {
        return this.currentOpType;
    }

    public void setCurrentOpType(Context.OpType currentOpType) {
        this.currentOpType = currentOpType;
    }

    public void configureOpType(SelectionKey key) {
        int readyOps = key.readyOps();
        switch (readyOps) {
            case 8: {
                this.currentOpType = Context.OpType.OP_CONNECT;
                break;
            }
            case 1: {
                this.currentOpType = Context.OpType.OP_READ;
                break;
            }
            case 4: {
                this.currentOpType = Context.OpType.OP_WRITE;
                break;
            }
            case 5: {
                this.currentOpType = Context.OpType.OP_READ_WRITE;
                break;
            }
            case 16: {
                this.currentOpType = Context.OpType.OP_ACCEPT;
                break;
            }
            default: {
                this.currentOpType = Context.OpType.OP_CONNECT;
            }
        }
    }

    @Override
    public void execute() {
        Object attachment = SelectionKeyAttachment.getAttachment((SelectionKey)this.key);
        if (this.ioEvent != null && attachment instanceof CallbackHandler) {
            this.execute(this.getCallbackHandlerContextTask((CallbackHandler)attachment));
        } else {
            this.execute(this.getProtocolChainContextTask());
        }
    }

    @Override
    public void execute(ContextTask contextTask) {
        this.execute(contextTask, true);
    }

    @Override
    public void execute(ContextTask contextTask, boolean runInSeparateThread) {
        if (this.protocolChain == null) {
            ProtocolChainInstanceHandler pciHandler = this.getProtocolChainInstanceHandler();
            this.protocolChain = pciHandler.poll();
        }
        if (contextTask != null) {
            contextTask.setContext(this);
            if (runInSeparateThread) {
                this.getThreadPool().execute(contextTask);
            } else {
                try {
                    contextTask.call();
                }
                catch (Exception e) {
                    Controller.logger().log(Level.SEVERE, "Unexpected exception occured, when executing task: " + contextTask, e);
                }
            }
        }
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        ProtocolChainInstanceHandler protocolChainInstanceHandler = this.selectorHandler.getProtocolChainInstanceHandler();
        return protocolChainInstanceHandler != null ? protocolChainInstanceHandler : this.controller.getProtocolChainInstanceHandler();
    }

    @Override
    public ExecutorService getThreadPool() {
        if (this.threadPool == null && this.controller != null) {
            this.threadPool = this.controller.getThreadPool();
        }
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void setIOEvent(IOEvent<Context> ioEvent) {
        this.ioEvent = ioEvent;
    }

    @Override
    public IOEvent getIOEvent() {
        return this.ioEvent;
    }

    @Override
    public Controller.Protocol getProtocol() {
        return this.selectorHandler.protocol();
    }

    public void setProtocol(Controller.Protocol protocol) {
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    public AsyncQueueReadable getAsyncQueueReadable() {
        if (this.asyncQueueReadable == null) {
            this.asyncQueueReadable = new AsyncQueueReadableContextWrapper();
        }
        return this.asyncQueueReadable;
    }

    @Override
    public AsyncQueueWritable getAsyncQueueWritable() {
        if (this.asyncQueueWritable == null) {
            this.asyncQueueWritable = new AsyncQueueWritableContextWrapper();
        }
        return this.asyncQueueWritable;
    }

    @Override
    public AsyncQueueReader getAsyncQueueReader() {
        return this.asyncQueueReader;
    }

    protected void setAsyncQueueReader(AsyncQueueReader asyncQueueReader) {
        this.asyncQueueReader = asyncQueueReader;
    }

    protected AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    protected void setAsyncQueueWriter(AsyncQueueWriter asyncQueueWriter) {
        this.asyncQueueWriter = asyncQueueWriter;
    }

    @Override
    public void suspend() {
        if (this.isSuspended) {
            return;
        }
        this.isSuspended = true;
        this.incrementRefCount();
        this.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public void resume() {
        if (!this.isSuspended) {
            return;
        }
        this.isSuspended = false;
        this.selectorHandler.register(this.key, 1);
    }

    @Override
    public void cancel() {
        if (!this.isSuspended) {
            return;
        }
        this.isSuspended = false;
        this.selectorHandler.getSelectionKeyHandler().cancel(this.key);
        this.getController().returnContext(this);
    }

    @Override
    public void incrementRefCount() {
        this.refCounter.incrementAndGet();
    }

    @Override
    public int decrementRefCount() {
        return this.refCounter.decrementAndGet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncQueueReadableContextWrapper
    implements AsyncQueueReadable {
        private AsyncQueueReadableContextWrapper() {
        }

        @Override
        public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
            return NIOContext.this.asyncQueueReader.read(NIOContext.this.key, buffer, callbackHandler);
        }

        @Override
        public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
            return NIOContext.this.asyncQueueReader.read(NIOContext.this.key, buffer, callbackHandler, condition);
        }

        @Override
        public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
            return NIOContext.this.asyncQueueReader.read(NIOContext.this.key, buffer, callbackHandler, condition, readPostProcessor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncQueueWritableContextWrapper
    implements AsyncQueueWritable {
        private AsyncQueueWritableContextWrapper() {
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, buffer);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, buffer, callbackHandler);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, buffer, callbackHandler, writePreProcessor);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, buffer, callbackHandler, writePreProcessor, cloner);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, dstAddress, buffer);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, dstAddress, buffer, callbackHandler);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, dstAddress, buffer, callbackHandler, writePreProcessor);
        }

        @Override
        public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
            return NIOContext.this.asyncQueueWriter.write(NIOContext.this.key, dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
        }
    }
}

