/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public final class FeatureAvailability {
    private static final FeatureAvailability INSTANCE = new FeatureAvailability();
    private final Map<String, Object> mFeatures = new HashMap<String, Object>();
    private final Map<String, CountDownLatch> mLatches = new HashMap<String, CountDownLatch>();
    public static final String AMX_LOADER_FEATURE = "AMXLoader";
    public static final String AMX_CORE_READY_FEATURE = "AMXCoreReady";
    public static final String AMX_READY_FEATURE = "AMXReady";
    private static final boolean DEBUG_ENABLED = false;

    private FeatureAvailability() {
    }

    public static FeatureAvailability getInstance() {
        return INSTANCE;
    }

    private void debug(Object ... args) {
    }

    public synchronized void registerFeature(String featureName, Object data) {
        if (this.mFeatures.get(featureName) != null) {
            throw new IllegalStateException("FeatureAvailability.addFeature: already added: " + featureName);
        }
        if (data == null) {
            throw new IllegalArgumentException("FeatureAvailability.addFeature(): data is null for: " + featureName);
        }
        this.mFeatures.put(featureName, data);
        if (this.mLatches.containsKey(featureName)) {
            CountDownLatch latch = this.mLatches.remove(featureName);
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForFeature(String featureName, String callerInfo) {
        CountDownLatch latch = null;
        Object data = null;
        FeatureAvailability featureAvailability = this;
        synchronized (featureAvailability) {
            data = this.mFeatures.get(featureName);
            if (data == null && (latch = this.mLatches.get(featureName)) == null) {
                latch = new CountDownLatch(1);
                this.mLatches.put(featureName, latch);
            }
        }
        assert (data == null && latch != null || data != null && latch == null);
        if (latch != null) {
            long start = System.currentTimeMillis();
            try {
                long startNanos = System.nanoTime();
                latch.await();
                long elapsedNanos = System.nanoTime() - startNanos;
                if (elapsedNanos > 1000000L) {
                    this.debug("FeatureAvailability.waitForFeature: waited ", "" + elapsedNanos, " for feature \"", featureName, "\" by \"", callerInfo, "\"");
                }
            }
            catch (InterruptedException e) {
                this.debug("waitForFeature: ERROR: ", e);
                throw new Error(e);
            }
            data = this.mFeatures.get(featureName);
        }
        return data;
    }
}

