/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.tx.Protocol;
import com.sun.xml.ws.api.tx.TXException;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.tx.at.ATCompletion;
import com.sun.xml.ws.tx.at.ATParticipant;
import com.sun.xml.ws.tx.at.LocalizationMessages;
import com.sun.xml.ws.tx.common.AT_2PC_State;
import com.sun.xml.ws.tx.common.AddressManager;
import com.sun.xml.ws.tx.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.common.TxFault;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.common.WsaHelper;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import com.sun.xml.ws.tx.coordinator.Registrant;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.at.WSATCoordinator;
import com.sun.xml.ws.tx.webservice.member.coord.CreateCoordinationContextType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATCoordinator
extends Coordinator
implements Synchronization,
XAResource {
    public static final URI localCoordinationProtocolServiceURI = AddressManager.getPreferredAddress(CoordinatorPortType.class);
    private static final int MAX_WAIT_ITERATION = 300;
    private static final long WAIT_SLEEP = 2000L;
    private static TxLogger logger = TxLogger.getATLogger(ATCoordinator.class);
    protected static final TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
    private final Map<String, ATParticipant> volatileParticipants = new LinkedHashMap<String, ATParticipant>(4);
    private AT_2PC_State volatileParticipantsState = AT_2PC_State.ACTIVE;
    private final Map<String, ATParticipant> durableParticipants = new LinkedHashMap<String, ATParticipant>(4);
    private AT_2PC_State durableParticipantsState = AT_2PC_State.ACTIVE;
    private ATCompletion completionRegistrant;
    private boolean guardTimeout = false;
    private boolean forgotten = false;
    private boolean allowNewParticipants = true;
    protected Transaction transaction = null;
    private volatile boolean registeredSynchronization = false;
    private static WSATCoordinator wsatCoordinatorService = new WSATCoordinator();
    public static final EndpointReference localCoordinatorProtocolService;

    public ATCoordinator(CoordinationContextInterface context, CreateCoordinationContextType request) {
        super(context, request);
    }

    public ATCoordinator(CoordinationContextInterface context) {
        super(context);
    }

    public void setTransaction(Transaction txn) {
        this.transaction = txn;
        if (txn == null) {
            return;
        }
        try {
            if (!this.isSubordinateCoordinator()) {
                this.registerSynchronization();
            }
            this.registerWithDurableParent();
        }
        catch (SystemException ex) {
            logger.severe("setTransaction", LocalizationMessages.XA_REGISTER_0004(ex.getLocalizedMessage()));
        }
        catch (IllegalStateException ex) {
            logger.severe("setTransaction", LocalizationMessages.XA_REGISTER_0004(ex.getLocalizedMessage()));
        }
        catch (RollbackException ex) {
            logger.severe("setTransaction", LocalizationMessages.XA_REGISTER_0004(ex.getLocalizedMessage()));
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    void setAborting() {
        this.volatileParticipantsState = AT_2PC_State.ABORTING;
        this.durableParticipantsState = AT_2PC_State.ABORTING;
    }

    boolean isAborting() {
        return this.volatileParticipantsState == AT_2PC_State.ABORTING || this.durableParticipantsState == AT_2PC_State.ABORTING;
    }

    @Override
    public List<Registrant> getRegistrants() {
        ArrayList<Registrant> list = this.completionRegistrant != null ? new ArrayList(this.volatileParticipants.size() + this.durableParticipants.size() + 1) : new ArrayList<Registrant>(this.volatileParticipants.size() + this.durableParticipants.size());
        list.addAll(this.volatileParticipants.values());
        list.addAll(this.durableParticipants.values());
        if (this.completionRegistrant != null) {
            list.add(this.completionRegistrant);
        }
        return Collections.unmodifiableList(list);
    }

    protected void registerWithVolatileParent() {
        this.registerSynchronization();
    }

    protected boolean registerWithDurableParent() throws RollbackException, SystemException {
        boolean result = false;
        if (this.getTransaction() != null) {
            result = this.getTransaction().enlistResource((XAResource)this);
        }
        return result;
    }

    @Override
    public void addRegistrant(Registrant registrant, WebServiceContext wsContext) {
        if (!this.allowNewParticipants) {
            if (wsContext != null) {
                WsaHelper.sendFault(wsContext, SOAPVersion.SOAP_11, TxFault.InvalidState, "Invalid to register a new participant after the first durable participant is prepared.  Registrant id: " + registrant.getIdValue());
            }
            throw new IllegalStateException(LocalizationMessages.LATE_PARTICIPANT_REGISTRATION_0002());
        }
        switch (registrant.getProtocol()) {
            case COMPLETION: {
                this.completionRegistrant = (ATCompletion)registrant;
                break;
            }
            case DURABLE: {
                logger.fine("ATCoordinator.addRegistrant", this.getCoordIdPartId(registrant));
                this.durableParticipants.put(registrant.getIdValue(), (ATParticipant)registrant);
                break;
            }
            case VOLATILE: {
                this.volatileParticipants.put(registrant.getIdValue(), (ATParticipant)registrant);
                break;
            }
            default: {
                throw new UnsupportedOperationException(LocalizationMessages.UNKNOWN_PROTOCOL_0003(registrant.getProtocol().getUri()));
            }
        }
    }

    @Override
    public Registrant getRegistrant(String id) {
        Registrant r = this.volatileParticipants.get(id);
        if (r == null) {
            r = this.durableParticipants.get(id);
        }
        if (r == null && this.completionRegistrant != null && this.completionRegistrant.getId().getValue().equals(id)) {
            r = this.completionRegistrant;
        }
        return r;
    }

    @Override
    public void removeRegistrant(String id) {
        this.forget(id);
    }

    public Collection<ATParticipant> getVolatileParticipants() {
        return this.volatileParticipants.values();
    }

    public Collection<ATParticipant> getVolatileParticipantsSnapshot() {
        return new ArrayList<ATParticipant>(this.volatileParticipants.values());
    }

    public Collection<ATParticipant> getDurableParticipants() {
        return this.durableParticipants.values();
    }

    public Collection<ATParticipant> getDurableParticipantsSnapshot() {
        return new ArrayList<ATParticipant>(this.durableParticipants.values());
    }

    public ATCompletion getCompletionRegistrant() {
        return this.completionRegistrant;
    }

    public void initiateVolatilePrepare() {
        if (this.isAborting()) {
            this.initiateRollback();
            return;
        }
        this.volatileParticipantsState = AT_2PC_State.PREPARING;
        this.actionForAllParticipants(this.getVolatileParticipantsSnapshot(), ACTION.PREPARE);
    }

    private void actionForAllParticipants(Collection<ATParticipant> particpants, ACTION action) {
        for (ATParticipant participant : particpants) {
            switch (action) {
                case PREPARE: {
                    try {
                        participant.prepare();
                        break;
                    }
                    catch (TXException ex) {
                        this.setAborting();
                        return;
                    }
                }
                case COMMIT: {
                    try {
                        participant.commit();
                        break;
                    }
                    catch (TXException ex) {
                        this.setAborting();
                        return;
                    }
                }
                case ROLLBACK: {
                    participant.abort();
                    break;
                }
            }
        }
    }

    protected void waitForVolatilePrepareResponse() {
        String METHOD_NAME = "waitForVolatilePrepareResponse";
        int numParticipants = this.getVolatileParticipants().size();
        if (this.volatileParticipantsState == AT_2PC_State.PREPARED_SUCCESS || numParticipants == 0) {
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("waitForVolatilePrepareResponse", "prepared coordId=" + this.getIdValue() + " state=" + (Object)((Object)this.volatileParticipantsState) + " numParticipants=" + numParticipants);
            }
            return;
        }
        boolean communicationTimeout = false;
        for (int i = 0; i < 300; ++i) {
            boolean allPrepared = true;
            for (ATParticipant participant : this.getVolatileParticipantsSnapshot()) {
                if (this.isAborting()) {
                    return;
                }
                switch (participant.getState()) {
                    case ACTIVE: {
                        allPrepared = false;
                        try {
                            participant.prepare();
                        }
                        catch (TXException ex) {
                            logger.warning("waitForVolatilePrepareResponse", LocalizationMessages.CAUGHT_TX_EX_DURING_PREPARE_0005(ex.getLocalizedMessage()));
                            this.setAborting();
                        }
                        break;
                    }
                    case PREPARING: {
                        allPrepared = false;
                        if (!communicationTimeout) break;
                        try {
                            participant.prepare();
                        }
                        catch (TXException ex) {
                            logger.warning("waitForVolatilePrepareResponse", LocalizationMessages.CAUGHT_TX_EX_DURING_PREPARE_0005(ex.getLocalizedMessage()));
                            this.setAborting();
                        }
                        break;
                    }
                    case ABORTING: {
                        this.setAborting();
                        return;
                    }
                    case PREPARED: 
                    case PREPARED_SUCCESS: 
                    case COMMITTING: {
                        break;
                    }
                    case NONE: 
                    case COMMITTED: 
                    case ABORTED: 
                    case READONLY: {
                        this.forget(participant);
                    }
                }
            }
            if (this.isAborting()) {
                return;
            }
            if (allPrepared) {
                this.volatileParticipantsState = AT_2PC_State.PREPARED_SUCCESS;
                if (logger.isLogging(Level.FINER)) {
                    logger.exiting("waitForVolatilePrepareResponse", "prepared coordId=" + this.getIdValue() + " state=" + (Object)((Object)this.volatileParticipantsState));
                }
                return;
            }
            try {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("waitForVolatilePrepareResponse", "checking...");
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                logger.warning("waitForVolatilePrepareResponse", ex.getLocalizedMessage());
            }
        }
        if (logger.isLogging(Level.FINE)) {
            this.dumpParticipantsState(this.getVolatileParticipantsSnapshot(), KIND.VOLATILE);
        }
        this.setAborting();
        if (logger.isLogging(Level.FINER)) {
            logger.warning("waitForVolatilePrepareResponse", LocalizationMessages.TIMEOUT_0006(this.getIdValue(), (Object)this.volatileParticipantsState));
        }
    }

    public void initiateDurablePrepare() {
        int numParticipants;
        Collection<ATParticipant> ps = this.getDurableParticipants();
        int n = numParticipants = ps == null ? 0 : ps.size();
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("initializeDurablePrepare", " coordId=" + this.getIdValue() + " numDurableParticipants=" + numParticipants + " volatile participant state=" + (Object)((Object)this.volatileParticipantsState) + " numVolatileParticipants" + this.getVolatileParticipants().size());
        }
        if (this.isAborting()) {
            this.initiateRollback();
            return;
        }
        assert (this.volatileParticipantsState == AT_2PC_State.PREPARED_SUCCESS || this.getVolatileParticipants().size() == 0);
        this.allowNewParticipants = false;
        this.durableParticipantsState = AT_2PC_State.PREPARING;
        this.actionForAllParticipants(this.getDurableParticipantsSnapshot(), ACTION.PREPARE);
    }

    protected void waitForDurablePrepareResponse() {
        boolean allPrepared = false;
        for (int i = 0; i < 300 && !this.isAborting(); ++i) {
            allPrepared = true;
            for (ATParticipant participant : this.getDurableParticipantsSnapshot()) {
                switch (participant.getState()) {
                    case PREPARING: {
                        allPrepared = false;
                        if (!logger.isLogging(Level.FINEST)) break;
                        logger.finest("intitatedurableParticipant", "not prepared, readonly or aborted " + this.getCoordIdPartId(participant) + " state=" + (Object)((Object)participant.getState()));
                        break;
                    }
                    case ACTIVE: 
                    case NONE: {
                        logger.warning("waitForDurablePrepareResponse", LocalizationMessages.INITIATE_ROLLBACK_0007(this.getCoordIdPartId(participant), (Object)participant.getState()));
                        allPrepared = false;
                        this.setAborting();
                        assert (false);
                    }
                    case ABORTING: {
                        this.setAborting();
                        return;
                    }
                    case PREPARED: 
                    case PREPARED_SUCCESS: 
                    case COMMITTING: {
                        break;
                    }
                    case ABORTED: {
                        this.setAborting();
                        participant.forget();
                        break;
                    }
                    case COMMITTED: 
                    case READONLY: {
                        participant.forget();
                    }
                }
            }
            if (this.isAborting()) {
                return;
            }
            if (allPrepared) {
                this.durableParticipantsState = AT_2PC_State.PREPARED_SUCCESS;
                if (logger.isLogging(Level.FINER)) {
                    logger.exiting("waitForDurablePrepare", "coordId=" + this.getIdValue() + "state:" + (Object)((Object)this.durableParticipantsState));
                }
                return;
            }
            try {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("waitForDurablePrepare", "checking...");
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (logger.isLogging(Level.FINE)) {
            this.dumpParticipantsState(this.getDurableParticipantsSnapshot(), KIND.DURABLE);
        }
        this.setAborting();
        logger.warning("waitForDurablePrepare", LocalizationMessages.TIMEOUT_0006(this.getIdValue(), (Object)this.durableParticipantsState));
    }

    private void dumpParticipantsState(Collection<ATParticipant> lst, KIND kind) {
        StringBuffer str = new StringBuffer(100);
        str.append(" " + kind.toString() + " ");
        for (ATParticipant p : lst) {
            str.append("Part: " + p.getIdValue() + " state:" + (Object)((Object)p.getState()));
        }
        if (logger.isLogging(Level.FINE)) {
            logger.fine("dumpParticipantState", "coordId=" + this.getIdValue() + str);
        }
    }

    public void initiateCommit() {
        this.initiateVolatileCommit();
        this.initiateDurableCommit();
    }

    public void initiateDurableCommit() {
        if (this.isAborting()) {
            this.initiateRollback();
            return;
        }
        if (this.durableParticipantsState != AT_2PC_State.PREPARED_SUCCESS) {
            logger.warning("durableVolatileCommit", LocalizationMessages.UNEXPECTED_STATE_0008((Object)this.durableParticipantsState));
        }
        this.durableParticipantsState = AT_2PC_State.COMMITTING;
        this.guardTimeout = true;
        this.actionForAllParticipants(this.getDurableParticipantsSnapshot(), ACTION.COMMIT);
    }

    public void initiateVolatileCommit() {
        if (this.isAborting()) {
            this.initiateRollback();
            return;
        }
        if (this.volatileParticipantsState != AT_2PC_State.PREPARED_SUCCESS && this.getVolatileParticipants().size() != 0) {
            logger.warning("initateVolatileCommit", LocalizationMessages.UNEXPECTED_STATE_0008((Object)this.volatileParticipantsState));
        }
        this.volatileParticipantsState = AT_2PC_State.COMMITTING;
        this.actionForAllParticipants(this.getVolatileParticipantsSnapshot(), ACTION.COMMIT);
    }

    public void initiateRollback() {
        this.initiateVolatileRollback();
        this.initiateDurableRollback();
    }

    public void initiateDurableRollback() {
        this.durableParticipantsState = AT_2PC_State.ABORTING;
        for (ATParticipant durableP : this.getDurableParticipantsSnapshot()) {
            durableP.abort();
        }
    }

    public void initiateVolatileRollback() {
        this.volatileParticipantsState = AT_2PC_State.ABORTING;
        for (ATParticipant volatileP : this.getVolatileParticipantsSnapshot()) {
            volatileP.abort();
        }
    }

    public void beforeCompletion() {
        logger.finest("beforeCompletion", "beforeCompletion called for coordId=" + this.getIdValue());
        if (this.volatileParticipants.size() != 0) {
            this.initiateVolatilePrepare();
            this.waitForVolatilePrepareResponse();
        }
    }

    public void afterCompletion(int i) {
        logger.finest("afterCompletion", "afterCompletion called for coordId=" + this.getIdValue());
        this.forget();
    }

    protected void waitForCommitOrRollbackResponse(Protocol protocol) {
        for (int i = 0; i < 300; ++i) {
            boolean allProcessed = true;
            if (protocol == Protocol.DURABLE) {
                for (ATParticipant participant : this.getDurableParticipantsSnapshot()) {
                    if (participant.getState() == ATParticipant.STATE.COMMITTED || participant.getState() == ATParticipant.STATE.ABORTED || participant.getState() == ATParticipant.STATE.READONLY) {
                        participant.forget();
                        continue;
                    }
                    allProcessed = false;
                    if (!logger.isLogging(Level.FINEST)) continue;
                    logger.finest("waitForCommitRollback", this.getCoordIdPartId(participant) + " state:" + (Object)((Object)participant.getState()));
                }
            } else if (protocol == Protocol.VOLATILE) {
                allProcessed = true;
                for (ATParticipant participant : this.getVolatileParticipantsSnapshot()) {
                    if ((participant.getState() == ATParticipant.STATE.COMMITTED || participant.getState() == ATParticipant.STATE.ABORTED) && participant.getState() == ATParticipant.STATE.READONLY) continue;
                    logger.warning("waitForCommitOrRollbackResponse", LocalizationMessages.FORGETTING_0009((Object)participant.getState(), this.getCoordIdPartId(participant)));
                    participant.forget();
                }
            }
            if (allProcessed) {
                this.guardTimeout = false;
                if (logger.isLogging(Level.FINER)) {
                    logger.exiting("waitForCommitRollback", "coordId=" + this.getIdValue());
                }
                return;
            }
            try {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("waitForCommitRollback", "checking...");
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_prepare(xid=" + xid + ")");
        }
        int result = 0;
        ATCoordinator aTCoordinator = this;
        synchronized (aTCoordinator) {
            this.initiateDurablePrepare();
            this.waitForDurablePrepareResponse();
        }
        if (this.isAborting()) {
            throw new XAException(100);
        }
        result = this.getDurableParticipants().size() == 0 && this.getVolatileParticipants().size() == 0 ? 3 : 0;
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_prepare", result);
        }
        return result;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_commit(xid=" + xid + " ,onePhase=" + onePhase + ")");
        }
        int result = 0;
        if (onePhase) {
            try {
                result = this.prepare(xid);
            }
            catch (XAException e) {
                logger.warning("commit(1PC)", LocalizationMessages.PREPARE_FAILED_0010(e.toString()));
                this.initiateRollback();
                this.waitForCommitOrRollbackResponse(Protocol.DURABLE);
                if (logger.isLogging(Level.FINER)) {
                    logger.exiting("XAResource_commit", e);
                }
                throw e;
            }
        }
        if (result != 3) {
            this.initiateCommit();
            this.waitForCommitOrRollbackResponse(Protocol.DURABLE);
            this.waitForCommitOrRollbackResponse(Protocol.VOLATILE);
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_commit");
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("XAResource_rollback(xid=" + xid + ")");
        }
        this.initiateRollback();
        this.waitForCommitOrRollbackResponse(Protocol.DURABLE);
        this.waitForCommitOrRollbackResponse(Protocol.VOLATILE);
        this.guardTimeout = false;
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("XAResource_rollback");
        }
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        this.setExpires((long)i * 1000L);
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x2000000: {
                break;
            }
            case 0x20000000: {
                this.setAborting();
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        logger.finest("forget", "XAResource.forget(XID) called for coordId=" + this.getIdValue());
        this.forget();
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return (int)(this.getExpires() / 1000L);
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        return false;
    }

    public void prepared(String participantId) {
        this.prepared(participantId, null);
    }

    public void prepared(String participantId, EndpointReference unknownParticipantReplyEPR) {
        ATParticipant participant;
        if (logger.isLogging(Level.FINER)) {
            logger.entering("prepared", this.getCoordIdPartId(participantId));
        }
        if ((participant = (ATParticipant)this.getRegistrant(participantId)) == null) {
            if (unknownParticipantReplyEPR != null) {
                logger.warning("prepared", LocalizationMessages.UNKNOWN_CORD_OR_PART_0011(this.getCoordIdPartId(participantId), unknownParticipantReplyEPR));
                ATParticipant.getATParticipantWS(unknownParticipantReplyEPR, null, false).rollbackOperation(null);
            }
        } else {
            participant.prepared();
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("prepared", this.getCoordIdPartId(participantId));
        }
    }

    public void committed(String participantId) {
        ATParticipant participant;
        if (logger.isLogging(Level.FINER)) {
            logger.entering("committed", this.getCoordIdPartId(participantId));
        }
        if ((participant = (ATParticipant)this.getRegistrant(participantId)) != null) {
            participant.committed();
            participant.forget();
        } else {
            logger.warning("committed", LocalizationMessages.UNKNOWN_PART_0012(this.getCoordIdPartId(participantId)));
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("committed", this.getCoordIdPartId(participantId));
        }
    }

    public void readonly(String participantId) {
        ATParticipant participant;
        if (logger.isLogging(Level.FINER)) {
            logger.entering("readonly", this.getCoordIdPartId(participantId));
        }
        if ((participant = (ATParticipant)this.getRegistrant(participantId)) == null) {
            logger.warning("readonly", LocalizationMessages.UNKNOWN_PART_0012(this.getCoordIdPartId(participantId)));
        } else {
            participant.readonly();
            participant.forget();
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("readonly", this.getCoordIdPartId(participantId));
            }
        }
    }

    public void aborted(String participantId) {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("aborted", this.getCoordIdPartId(participantId));
        }
        this.setAborting();
        ATParticipant participant = (ATParticipant)this.getRegistrant(participantId);
        if (participant == null) {
            if (logger.isLogging(Level.WARNING)) {
                logger.warning("aborted", LocalizationMessages.UNKNOWN_PART_0012(this.getCoordIdPartId(participantId)));
            }
        } else {
            participant.aborted();
            participant.forget();
            if (logger.isLogging(Level.FINER)) {
                logger.exiting("aborted", this.getCoordIdPartId(participantId));
            }
        }
    }

    public void replay(String participantId) {
        String METHOD_NAME = "replay";
        if (logger.isLogging(Level.FINER)) {
            logger.entering("replay", this.getCoordIdPartId(participantId));
        }
        ATParticipant participant = (ATParticipant)this.getRegistrant(participantId);
        ATParticipant.STATE state = participant.getState();
        switch (state) {
            case NONE: {
                if (participant.isDurable()) {
                    participant.abort();
                    break;
                }
                logger.severe("replay", LocalizationMessages.INVALID_STATE_0013(this.getCoordIdPartId(participantId)));
                break;
            }
            case ACTIVE: 
            case PREPARING: 
            case ABORTING: {
                participant.abort();
                break;
            }
            case COMMITTING: {
                try {
                    participant.commit();
                }
                catch (TXException ex) {
                    logger.warning("replay", ex.getLocalizedMessage());
                }
                break;
            }
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("replay", this.getCoordIdPartId(participantId));
        }
    }

    private void registerSynchronization() {
        if (!this.registeredSynchronization) {
            this.registeredSynchronization = true;
            TransactionManagerImpl.getInstance().registerSynchronization(this);
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("registerSynchronization", "Synchronization registered for WS-AT coordinated activity " + this.getIdValue());
            }
        }
    }

    public boolean isSubordinateCoordinator() {
        return false;
    }

    public EndpointReference getParentCoordinatorRegistrationEPR() {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getRootRegistrationService();
    }

    public static WSATCoordinator getWSATCoordinatorService() {
        return wsatCoordinatorService;
    }

    protected String getCoordIdPartId(Registrant registrant) {
        return this.getCoordIdPartId(registrant.getIdValue());
    }

    protected String getCoordIdPartId(String participantId) {
        return " coordId=" + this.getIdValue() + " partId:" + participantId + " ";
    }

    public void forget(ATParticipant part) {
        this.forget(part.getIdValue());
    }

    public void forget(String partId) {
        ATParticipant removed = this.volatileParticipants.remove(partId);
        if (removed != null) {
            if (logger.isLogging(Level.FINE)) {
                logger.fine("forget", "forgot volatile participant " + this.getCoordIdPartId(partId));
            }
            if (!this.hasOutstandingParticipants()) {
                this.forget();
            }
            return;
        }
        removed = this.durableParticipants.remove(partId);
        if (removed != null) {
            if (logger.isLogging(Level.FINE)) {
                logger.fine("forget", "forgot durable participant " + this.getCoordIdPartId(partId));
            }
            if (!this.hasOutstandingParticipants()) {
                this.forget();
            }
            return;
        }
    }

    @Override
    public EndpointReference getCoordinatorProtocolServiceForRegistrant(Registrant r) {
        return localCoordinatorProtocolService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expirationGuard() {
        ATCoordinator aTCoordinator = this;
        synchronized (aTCoordinator) {
            return this.guardTimeout;
        }
    }

    @Override
    public void expire() {
        if (!this.expirationGuard()) {
            this.setAborting();
        }
        super.expire();
    }

    private void foo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget() {
        ATCoordinator aTCoordinator = this;
        synchronized (aTCoordinator) {
            if (this.forgotten) {
                return;
            }
            this.forgotten = true;
            for (ATParticipant participant : this.getDurableParticipantsSnapshot()) {
                participant.forget();
            }
            for (ATParticipant participant : this.getVolatileParticipantsSnapshot()) {
                participant.forget();
            }
            super.forget();
        }
    }

    public void resumeTransaction() throws WebServiceException {
        if (this.transaction != null) {
            try {
                tm.resume(this.transaction);
                logger.finest("resumeTransaction", "successfully resumed txn " + this.transaction);
            }
            catch (Exception ex) {
                String handlerMsg = LocalizationMessages.TXN_MGR_RESUME_FAILED_0032(this.transaction.toString());
                logger.warning("resumeTransaction", handlerMsg, ex);
                throw new WebServiceException(handlerMsg, (Throwable)ex);
            }
        }
    }

    public Transaction suspendTransaction() {
        Transaction tx = null;
        try {
            tx = tm.suspend();
            logger.finest("suspendTransation", tx == null ? "no txn to suspend" : "suspended txn " + tx.toString());
            return tx;
        }
        catch (SystemException ex) {
            String handlerMsg = LocalizationMessages.TXN_MGR_OPERATION_FAILED_0031("suspend");
            logger.warning("suspendTransaction", handlerMsg, ex);
            return tx;
        }
    }

    public boolean hasOutstandingParticipants() {
        return this.getDurableParticipants().size() != 0 || this.getVolatileParticipants().size() != 0;
    }

    static {
        MemberSubmissionEndpointReference epr = new MemberSubmissionEndpointReference();
        epr.addr = new MemberSubmissionEndpointReference.Address();
        epr.addr.uri = localCoordinationProtocolServiceURI.toString();
        localCoordinatorProtocolService = epr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ACTION {
        PREPARE,
        COMMIT,
        ROLLBACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum KIND {
        VOLATILE,
        DURABLE;

    }
}

