/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.ProcessingStateChange;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.XmlFilteringUtils;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public class PrivateElementFilteringStateMachine
implements FilteringStateMachine {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PrivateElementFilteringStateMachine.class);
    private int depth;
    private boolean filteringOn;
    private final QName[] filteredElements;

    public PrivateElementFilteringStateMachine(QName ... filteredElements) {
        if (filteredElements == null) {
            this.filteredElements = new QName[0];
        } else {
            this.filteredElements = new QName[filteredElements.length];
            System.arraycopy(filteredElements, 0, this.filteredElements, 0, filteredElements.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingStateChange getStateChange(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(new Object[]{invocation});
        ProcessingStateChange resultingState = ProcessingStateChange.NO_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.filteringOn) {
                        ++this.depth;
                        break;
                    }
                    this.filteringOn = this.startFiltering(invocation, writer);
                    if (!this.filteringOn) break;
                    resultingState = ProcessingStateChange.START_FILTERING;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (!this.filteringOn) break;
                    if (this.depth == 0) {
                        this.filteringOn = false;
                        resultingState = ProcessingStateChange.STOP_FILTERING;
                        break;
                    }
                    --this.depth;
                    break;
                }
                case CLOSE: {
                    if (!this.filteringOn) break;
                    this.filteringOn = false;
                    resultingState = ProcessingStateChange.STOP_FILTERING;
                }
            }
            ProcessingStateChange processingStateChange = resultingState;
            return processingStateChange;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        QName elementName = XmlFilteringUtils.getElementNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        for (QName filteredElement : this.filteredElements) {
            if (!filteredElement.equals(elementName)) continue;
            return true;
        }
        return false;
    }
}

