/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Properties;

public class MQAddress
implements Serializable {
    public static final String isHostTrusted = "isHostTrusted";
    protected static final String DEFAULT_SCHEME_NAME = "mq";
    protected static final String DEFAULT_HOSTNAME = "localhost";
    protected static final int DEFAULT_PORTMAPPER_PORT = 7676;
    protected static final String DEFAULT_SERVICENAME = "jms";
    private String addr = null;
    protected String schemeName = null;
    protected String addrHost = null;
    protected int port = -1;
    protected String serviceName = null;
    protected boolean isHTTP = false;
    protected Properties props = new Properties();
    protected transient String tostring = null;
    protected transient boolean isSSLHostTrustedSet = false;

    protected MQAddress() {
    }

    protected void initialize(String string) throws MalformedURLException {
        this.addr = string;
        this.init();
        this.parseAndValidate();
    }

    private void init() {
        this.props.setProperty(isHostTrusted, "false");
    }

    protected void parseAndValidate() throws MalformedURLException {
        String string = this.addr;
        this.schemeName = DEFAULT_SCHEME_NAME;
        int n = string.indexOf("://");
        if (n > 0) {
            this.schemeName = string.substring(0, n);
            string = string.substring(n + 3);
        }
        if (this.schemeName.equalsIgnoreCase(DEFAULT_SCHEME_NAME)) {
            n = string.indexOf(63);
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                this.parseQueryString(string2);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(47)) >= 0) {
                this.serviceName = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(58)) >= 0) {
                this.port = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n);
            }
            this.addrHost = string;
            if (this.addrHost == null || this.addrHost.equals("")) {
                this.addrHost = DEFAULT_HOSTNAME;
            }
            if (this.port == -1) {
                this.port = 7676;
            }
            if (this.serviceName == null || this.serviceName.equals("")) {
                this.serviceName = this.getDefaultServiceName();
            }
        } else if (this.schemeName.equalsIgnoreCase("mqssl") || this.schemeName.equalsIgnoreCase("mqtcp")) {
            n = string.indexOf(63);
            if (n >= 0) {
                String string3 = string.substring(n + 1);
                this.parseQueryString(string3);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(47)) >= 0) {
                this.serviceName = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(58)) >= 0) {
                this.port = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n);
            }
            this.addrHost = string;
            if (this.addrHost == null || this.addrHost.equals("")) {
                throw new MalformedURLException("Illegal address. Hostname missing : " + this.addr);
            }
            if (this.port == -1) {
                throw new MalformedURLException("Illegal address. Port missing : " + this.addr);
            }
        } else {
            if (this.schemeName.equalsIgnoreCase("http") || this.schemeName.equalsIgnoreCase("https")) {
                this.isHTTP = true;
                return;
            }
            throw new MalformedURLException("Illegal address. Unknown address scheme : " + this.addr);
        }
    }

    protected void parseQueryString(String string) throws MalformedURLException {
        String string2 = string;
        while (string2.length() > 0) {
            String string3 = string2;
            int n = string2.indexOf(38);
            if (n >= 0) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string2 = "";
            }
            int n2 = string3.indexOf(61);
            if (n2 <= 0) {
                throw new MalformedURLException("Illegal address. Bad query string : " + this.addr);
            }
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            this.props.setProperty(string4, string5);
            if (!isHostTrusted.equals(string4)) continue;
            this.isSSLHostTrustedSet = true;
        }
    }

    public boolean isServicePortFinal() {
        return this.isHTTP || this.schemeName.equalsIgnoreCase("mqtcp") || this.schemeName.equalsIgnoreCase("mqssl");
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public boolean getIsSSLHostTrustedSet() {
        return this.isSSLHostTrustedSet;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getHostName() {
        return this.addrHost;
    }

    public int getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean getIsHTTP() {
        return this.isHTTP;
    }

    public String getURL() {
        return this.addr;
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        if (this.isHTTP) {
            this.tostring = this.addr;
            return this.addr;
        }
        this.tostring = this.schemeName + "://" + this.addrHost + ":" + this.port + "/" + this.serviceName;
        return this.tostring;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MQAddress)) {
            return false;
        }
        return this.toString().equals(((MQAddress)object).toString());
    }

    public String getDefaultServiceName() {
        return DEFAULT_SERVICENAME;
    }

    public static MQAddress getMQAddress(String string) throws MalformedURLException {
        MQAddress mQAddress = new MQAddress();
        mQAddress.initialize(string);
        return mQAddress;
    }
}

