/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.security.jmac.provider.PacketMapMessageInfo;
import com.sun.enterprise.security.jmac.provider.PacketMessageInfo;
import com.sun.enterprise.security.jmac.provider.config.PipeHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceException;

public class ClientSecurityPipe
extends AbstractFilterPipeImpl
implements SecureConversationInitiator {
    protected PipeHelper helper;
    protected static final Logger _logger = LogDomains.getLogger(ClientSecurityPipe.class, (String)"javax.enterprise.system.core.security");
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientSecurityPipe.class);
    private static final String WSIT_CLIENT_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITClientAuthContext";

    public ClientSecurityPipe(Map props, Pipe next) {
        super(next);
        props.put("SECURITY_PIPE", this);
        WSDLPort wsdlModel = (WSDLPort)props.get("WSDL_MODEL");
        if (wsdlModel != null) {
            props.put("WSDL_SERVICE", wsdlModel.getOwner().getName());
        }
        this.helper = new PipeHelper("SOAP", props, null);
    }

    protected ClientSecurityPipe(ClientSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.helper = that.helper;
    }

    public void preDestroy() {
        try {
            Packet request = new Packet();
            PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
            Subject subj = ClientSecurityPipe.getClientSubject(request);
            ClientAuthContext cAC = this.helper.getClientAuthContext(info, subj);
            if (cAC != null && WSIT_CLIENT_AUTH_CONTEXT.equals(cAC.getClass().getName())) {
                cAC.cleanSubject((MessageInfo)info, subj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helper.disable();
    }

    public final Pipe copy(PipeCloner cloner) {
        return new ClientSecurityPipe(this, cloner);
    }

    public PipeHelper getPipeHelper() {
        return this.helper;
    }

    public Packet process(Packet request) {
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        info.getMap().put("javax.xml.ws.wsdl.service", this.helper.getProperty("WSDL_SERVICE"));
        AuthStatus status = AuthStatus.SEND_SUCCESS;
        Subject clientSubject = ClientSecurityPipe.getClientSubject(request);
        ClientAuthContext cAC = null;
        try {
            cAC = this.helper.getClientAuthContext(info, clientSubject);
            if (cAC != null) {
                status = cAC.secureRequest((MessageInfo)info, clientSubject);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_secure_request", e);
            throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantSecureRequst", "Cannot secure request for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e);
        }
        Packet response = null;
        if (status == AuthStatus.FAILURE) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ws.status_secure_request", status);
            }
            response = info.getResponsePacket();
        } else {
            response = this.processSecureRequest(info, cAC, clientSubject);
        }
        return response;
    }

    private Packet processSecureRequest(PacketMessageInfo info, ClientAuthContext cAC, Subject clientSubject) throws WebServiceException {
        Packet response = this.next.process(info.getRequestPacket());
        Message m = response.getMessage();
        if (m != null && cAC != null) {
            AuthStatus status = AuthStatus.SUCCESS;
            info.setResponsePacket(response);
            try {
                status = cAC.validateResponse((MessageInfo)info, clientSubject, null);
            }
            catch (Exception e) {
                throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateResponse", "Cannot validate response for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e);
            }
            response = status == AuthStatus.SEND_CONTINUE ? this.processSecureRequest(info, cAC, clientSubject) : info.getResponsePacket();
        }
        return response;
    }

    private static Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = PipeHelper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }

    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        PacketMapMessageInfo info = new PacketMapMessageInfo(packet, new Packet());
        JAXBElement token = null;
        try {
            Subject clientSubject = ClientSecurityPipe.getClientSubject(packet);
            HashMap<String, PacketMapMessageInfo> map = new HashMap<String, PacketMapMessageInfo>();
            map.put("SECURITY_TOKEN", info);
            this.helper.getSessionToken(map, info, clientSubject);
            Object o = info.getMap().get("SECURITY_TOKEN");
            if (o != null && o instanceof JAXBElement) {
                token = (JAXBElement)o;
            }
        }
        catch (Exception e) {
            if (e instanceof WSSecureConversationException) {
                throw (WSSecureConversationException)e;
            }
            throw new WSSecureConversationException("Secure Conversation failure: ", (Throwable)e);
        }
        return token;
    }
}

