/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.config.WidgetConfigException;
import org.json.JSONException;
import org.json.JSONObject;

public class IOUtil {
    public static JSONObject loadJSONObject(InputStream in) throws JSONException, IOException {
        StringBuffer content = IOUtil.loadResource(in, "UTF-8");
        return new JSONObject(content.toString());
    }

    public static void replace(StringBuffer buff, String target, String replacement) {
        if (buff == null || target == null || replacement == null) {
            return;
        }
        for (int index = 0; index < buff.length() && (index = buff.indexOf(target)) != -1; index += replacement.length() + 1) {
            buff.replace(index, index + target.length(), replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer loadResource(InputStream stream, String encoding) throws IOException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader bufReader = null;
        String curLine = null;
        try {
            InputStreamReader inputStreamReader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            bufReader = new BufferedReader(inputStreamReader);
            while (null != (curLine = bufReader.readLine())) {
                buffer.append(curLine + "\n");
            }
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
        return buffer;
    }

    public static StringBuffer createJavaScriptObject(Map p) {
        return IOUtil.createJavaScriptObject(p, false);
    }

    public static StringBuffer createJavaScriptObject(Map p, boolean json) {
        StringBuffer buff = new StringBuffer("{");
        Iterator it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (val != null && val instanceof Map) {
                val = IOUtil.createJavaScriptObject((Map)val);
            }
            if (json) {
                buff.append("'" + key + "':");
            } else {
                buff.append(key + ":");
            }
            if (val == null) {
                buff.append("null");
            } else if (val instanceof Float || val instanceof Long || val instanceof Integer || val instanceof StringBuffer) {
                buff.append(val.toString());
            } else if (val instanceof String && (((String)val).trim().startsWith("{") || ((String)val).trim().startsWith("["))) {
                buff.append(val.toString());
            } else {
                buff.append("'" + val.toString() + "'");
            }
            if (!it.hasNext()) continue;
            buff.append(",");
        }
        buff.append("}");
        return buff;
    }

    public static String resolvePath(String rootPath, String relativePath) throws WidgetConfigException {
        int numberOfDirUp;
        int relativePos;
        if (rootPath == null || relativePath.startsWith("/") || IOUtil.isExternalUri(relativePath)) {
            return relativePath;
        }
        int relativePathLen = relativePath.length();
        for (relativePos = 0; relativePos < relativePathLen && relativePath.indexOf("../", relativePos) == relativePos; relativePos += 3) {
        }
        int n = numberOfDirUp = relativePos > 0 ? relativePos / 3 : 0;
        if (numberOfDirUp > 0) {
            int positionOfSlash;
            int rootPos = rootPath.length();
            while ((positionOfSlash = rootPath.lastIndexOf(47, rootPos - 1)) > 0 && numberOfDirUp > 0) {
                rootPos = positionOfSlash;
                --numberOfDirUp;
            }
            if (numberOfDirUp > 0) {
                String[] parameter = new String[]{rootPath, relativePath};
                throw new WidgetConfigException(new LocalizedMessage("ERROR_RESOLVE_RELATIVEPATH", parameter));
            }
            return rootPath.substring(0, rootPos) + '/' + relativePath.substring(relativePos);
        }
        return rootPath.endsWith("/") ? rootPath + relativePath : rootPath + '/' + relativePath;
    }

    public static boolean isExternalUri(String uri) {
        return uri.startsWith("http://") || uri.startsWith("https://");
    }

    public static boolean matchURL(String url, String pattern) {
        return pattern.equals(url) || "*".equals(pattern) || pattern.endsWith("*") && pattern.length() > 1 && url.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && pattern.length() > 1 && url.endsWith(pattern.substring(1, pattern.length()));
    }

    public static boolean matchWildcard(CharSequence pattern, CharSequence string) {
        int patpos = 0;
        int patlen = pattern.length();
        int strpos = 0;
        int strlen = string.length();
        int i = 0;
        boolean star = false;
        block4: while (strpos + i < strlen) {
            if (patpos + i < patlen) {
                switch (pattern.charAt(patpos + i)) {
                    case '?': {
                        ++i;
                        continue block4;
                    }
                    case '*': {
                        star = true;
                        strpos += i;
                        patpos += i;
                        do {
                            if (++patpos != patlen) continue;
                            return true;
                        } while (pattern.charAt(patpos) == '*');
                        i = 0;
                        continue block4;
                    }
                }
                if (string.charAt(strpos + i) != pattern.charAt(patpos + i)) {
                    if (!star) {
                        return false;
                    }
                    ++strpos;
                    i = 0;
                    continue;
                }
                ++i;
                continue;
            }
            if (!star) {
                return false;
            }
            ++strpos;
            i = 0;
        }
        do {
            if (patpos + i != patlen) continue;
            return true;
        } while (pattern.charAt(patpos + i++) == '*');
        return false;
    }
}

