/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.config.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.glassfish.appclient.client.acc.config.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML {
    private static final List<String> booleanTrueValues = Arrays.asList("yes", "on", "1", "true");
    private static final List<String> providerTypeValues = Arrays.asList("client", "server", "client-server");

    public static boolean parseBoolean(String booleanText) {
        return XML._parseBoolean(booleanText.trim());
    }

    private static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private static boolean _parseBoolean(CharSequence literal) {
        char ch;
        int i = 0;
        int len = literal.length();
        while (XML.isWhiteSpace(ch = literal.charAt(i++)) && i < len) {
        }
        return booleanTrueValues.contains(literal.subSequence(i, len));
    }

    public static String parseProviderType(String providerType) {
        if (providerTypeValues.contains(providerType)) {
            return providerType;
        }
        throw new IllegalArgumentException(providerType);
    }

    public static Properties toProperties(List<Property> props) {
        Properties result = new Properties();
        for (Property p : props) {
            result.setProperty(p.getName(), p.getValue());
        }
        return result;
    }

    public static class Password {
        private char[] pw;

        private Password(String s) {
            this.pw = s.toCharArray();
        }

        public Password(char[] pw) {
            this.pw = pw;
        }

        public static Password parse(String s) {
            return new Password(s);
        }

        public static String print(Password p) {
            return new String(p.pw);
        }

        public char[] get() {
            return this.pw;
        }
    }
}

