/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.memory.levels;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryLevelHandler;

public class Red
extends MemoryLevelHandler {
    protected static final boolean SWAP_NON_PERSIST = false;
    protected static final int GC_DEFAULT = 10;
    protected static final int GC_ITR_DEFAULT = 10;
    protected int GCCount = 0;
    protected int GCItrCount = 0;

    public Red(String string) {
        super(string);
        this.MEMORY_NAME_KEY = "B0024";
        this.GCCount = Globals.getConfig().getIntProperty("imq." + string + ".gccount", 10);
        this.GCItrCount = Globals.getConfig().getIntProperty("imq." + string + ".gcitr", 10);
    }

    public int getMessageCount(long l, int n) {
        return 0;
    }

    public long getMemory(long l, int n) {
        return 0L;
    }

    public int gcCount() {
        return this.GCCount;
    }

    public int gcIteration() {
        return this.GCItrCount;
    }

    public boolean cleanup(int n) {
        super.cleanup(n);
        switch (n) {
            case 0: {
                this.logger.log(8, "B1089");
                this.logger.log(4, "Broker is swapping all persistent messages");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    public boolean enter(boolean bl) {
        super.enter(bl);
        if (bl) {
            return true;
        }
        MemoryGlobals.setMEM_FREE_P_ALL(true);
        MemoryGlobals.setMEM_DISALLOW_PRODUCERS(true);
        MemoryGlobals.setMEM_DISALLOW_CREATE_DEST(true);
        try {
            Globals.getClusterBroadcast().pauseMessageFlow();
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Got exception in Red", (Throwable)exception);
        }
        return true;
    }

    public boolean leave(boolean bl) {
        super.leave(bl);
        if (bl) {
            return true;
        }
        MemoryGlobals.setMEM_FREE_NP_ALL(true);
        MemoryGlobals.setMEM_FREE_P_ALL(false);
        MemoryGlobals.setMEM_DISALLOW_PRODUCERS(false);
        MemoryGlobals.setMEM_DISALLOW_CREATE_DEST(false);
        try {
            Globals.getClusterBroadcast().resumeMessageFlow();
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Got exception in Red", (Throwable)exception);
        }
        return true;
    }
}

