/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.Map;

public final class TakingoverTracker {
    public static final int BEFORE_GET_LOCK = 0;
    public static final int AFTER_GET_LOCK = 1;
    public static final int BEFORE_TAKE_STORE = 2;
    public static final int BEFORE_DB_SWITCH_OWNER = 3;
    public static final int AFTER_DB_SWITCH_OWNER = 4;
    public static final int AFTER_TAKE_STORE = 5;
    public static final int BEFORE_PROCESSING = 6;
    public static final int AFTER_PROCESSING = 7;
    private String brokerID = null;
    private UID storeSession = null;
    private Thread runner = null;
    private Map msgMap = null;
    private int stage = -1;
    private int substage = -1;

    public TakingoverTracker(HAClusteredBroker hAClusteredBroker, Thread thread) {
        this.brokerID = hAClusteredBroker.getBrokerName();
        this.storeSession = hAClusteredBroker.getStoreSessionUID();
        this.runner = thread;
    }

    public final String getBrokerID() {
        return this.brokerID;
    }

    public final Thread getTakeoverRunner() {
        return this.runner;
    }

    public final int getStage() {
        if (this.substage != -1) {
            return this.substage;
        }
        return this.stage;
    }

    public final void setMessageMap(Map map) throws BrokerException {
        if (Thread.currentThread() != this.runner) {
            throw new BrokerException("Internal Error: TakingoverTracker.setMessageMap() not runner thread");
        }
        if (this.stage < 1 || this.stage > 3) {
            throw new BrokerException("Internal Error: TakingoverTracker.setMessageMap() unexpected stage " + this.stage + "(" + this.substage + ")");
        }
        this.msgMap = map;
    }

    public final boolean containDestination(Destination destination) {
        if (this.msgMap == null) {
            return false;
        }
        return this.msgMap.containsValue(destination.getDestinationUID().toString());
    }

    public final boolean containMessage(Packet packet) {
        if (this.msgMap == null) {
            return false;
        }
        return this.msgMap.containsKey(packet.getSysMessageID().toString());
    }

    public final void setStage_BEFORE_GET_LOCK() {
        this.stage = 0;
    }

    public final void setStage_AFTER_GET_LOCK() {
        this.stage = 1;
    }

    public final void setStage_BEFORE_TAKE_STORE() {
        this.stage = 2;
    }

    public final void setStage_BEFORE_DB_SWITCH_OWNER() {
        this.substage = 3;
    }

    public final void setStage_AFTER_DB_SWITCH_OWNER() {
        this.substage = 4;
    }

    public final void setStage_AFTER_TAKE_STORE() {
        this.stage = 5;
    }

    public final void setStage_BEFORE_PROCESSING() {
        this.stage = 6;
    }

    public final void setStage_AFTER_PROCESSING() {
        this.stage = 7;
    }
}

