/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeHAStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private DBManager dbMgr = DBManager.getDBManager();
    private String brokerID = this.dbMgr.getBrokerID();

    UpgradeHAStore() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            String string = this.br.getKString("B1230", this.brokerID);
            throw new BrokerException(this.br.getKString("B3208", string));
        }
    }

    void upgradeStore(Connection connection) throws BrokerException {
        Object object;
        this.logger.logToAll(8, this.br.getString("B1232", String.valueOf(410), this.brokerID));
        DAOFactory dAOFactory = this.dbMgr.getDAOFactory();
        int n = -1;
        try {
            VersionDAO versionDAO = dAOFactory.getVersionDAO();
            n = versionDAO.getStoreVersion(connection);
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        boolean bl = false;
        if (n == 410) {
            BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
            object = brokerDAO.getBrokerInfo(connection, this.brokerID);
            if (object != null) {
                String string = this.br.getString("B1231", this.brokerID);
                throw new BrokerException(this.br.getKString("B3208", string));
            }
        } else if (n == -1) {
            bl = true;
        } else {
            String string = this.br.getString("B3092", String.valueOf(n), String.valueOf(410));
            throw new BrokerException(this.br.getKString("B3208", string));
        }
        try {
            if (bl) {
                DBTool.createTables(connection);
            }
        }
        catch (Throwable throwable) {
            object = this.dbMgr.getCreateDBURL();
            if (object == null || ((String)object).length() == 0) {
                object = this.dbMgr.getOpenDBURL();
            }
            String string = this.br.getKString("B3073", object);
            this.logger.logToAll(32, string, (Object)throwable);
            throw new BrokerException(string, throwable);
        }
        try {
            connection.setAutoCommit(false);
            this.upgradeStoreSessions(connection);
            this.upgradeDestinations(connection);
            this.upgradeInterests(connection);
            this.upgradeMessages(connection);
            this.upgradeTxns(connection);
            this.logger.logToAll(8, this.br.getString("B1106"));
        }
        catch (Exception exception) {
            this.logger.logToAll(32, "B1233", (Object)this.brokerID);
            try {
                object = dAOFactory.getDestinationDAO();
                object.deleteAll(connection);
                ConsumerDAO consumerDAO = dAOFactory.getConsumerDAO();
                consumerDAO.deleteAll(connection);
                MessageDAO messageDAO = dAOFactory.getMessageDAO();
                messageDAO.deleteAll(connection);
                TransactionDAO transactionDAO = dAOFactory.getTransactionDAO();
                transactionDAO.deleteAll(connection);
            }
            catch (Exception exception2) {
                this.logger.logStack(32, "B4117", (Object)"Failed to clean up after upgrade failed", (Throwable)exception2);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(this.br.getKString("B3208", exception.getMessage()), exception);
        }
    }

    void upgradeStoreSessions(Connection connection) throws BrokerException {
        StoreSessionDAO storeSessionDAO = this.dbMgr.getDAOFactory().getStoreSessionDAO();
        String string = "MQSES41S" + this.brokerID;
        String string2 = new StringBuffer(128).append("INSERT INTO ").append(storeSessionDAO.getTableName()).append(" ( ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(") SELECT ").append("ID").append(", ").append("BROKER_ID").append(", ").append("IS_CURRENT").append(", ").append("CREATED_BY").append(", ").append("CREATED_TS").append(" FROM ").append(string).toString();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                statement.execute(string2);
                connection.commit();
            }
            catch (Exception exception) {
                String string3 = this.br.getKString("B4284");
                this.logger.logStack(32, string3, (Throwable)exception);
                throw new BrokerException(string3, exception);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            Util.close(null, statement, null);
            throw throwable;
        }
        Util.close(null, statement, null);
    }

    void upgradeDestinations(Connection connection) throws BrokerException {
        DestinationDAO destinationDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        String string = "MQDST41S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(", ").append("CREATED_TS").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(destinationDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(destinationDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Destination destination = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string3);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    ConnectionUID connectionUID;
                    Object object = Util.readObject(resultSet, 1);
                    destination = (Destination)object;
                    long l = resultSet.getLong(2);
                    String string4 = destination.getUniqueName();
                    int n = destination.getIsLocal() ? 1 : 0;
                    long l2 = -1L;
                    long l3 = -1L;
                    long l4 = -1L;
                    if (n > 0 && (connectionUID = destination.getConnectionUID()) != null) {
                        l3 = resultSet.getLong(3);
                        l2 = connectionUID.longValue();
                    }
                    l4 = resultSet.getLong(4);
                    try {
                        preparedStatement.setString(1, string4);
                        Util.setObject(preparedStatement, 2, destination);
                        preparedStatement.setInt(3, n);
                        Util.setLong(preparedStatement, 4, l2);
                        Util.setLong(preparedStatement, 5, l3);
                        preparedStatement.setLong(6, l4);
                        preparedStatement.setLong(7, l);
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = DBManager.wrapIOException("[" + string3 + "]", iOException);
                        throw iOException2;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                        throw sQLException2;
                    }
                }
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (Exception exception) {
                String string5 = this.br.getKString("B4162", destination == null ? "loading" : destination.getUniqueName());
                this.logger.logStack(32, string5, (Throwable)exception);
                throw new BrokerException(string5, exception);
            }
            Object var25_25 = null;
        }
        catch (Throwable throwable) {
            Object var25_26 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeInterests(Connection connection) throws BrokerException {
        ConsumerDAO consumerDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        String string = "MQCON41S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(", ").append("CREATED_TS").append(", ").append("ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(consumerDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(consumerDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Consumer consumer = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string3);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    consumer = (Consumer)Util.readObject(resultSet, 1);
                    long l = resultSet.getLong(2);
                    String string4 = null;
                    String string5 = null;
                    if (consumer instanceof Subscription) {
                        Subscription subscription = (Subscription)consumer;
                        string4 = subscription.getDurableName();
                        string5 = subscription.getClientID();
                    }
                    try {
                        preparedStatement.setLong(1, consumer.getConsumerUID().longValue());
                        Util.setObject(preparedStatement, 2, consumer);
                        Util.setString(preparedStatement, 3, string4);
                        Util.setString(preparedStatement, 4, string5);
                        preparedStatement.setLong(5, l);
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = DBManager.wrapIOException("[" + string3 + "]", iOException);
                        throw iOException2;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                        throw sQLException2;
                    }
                }
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (Exception exception) {
                String string6 = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                this.logger.logStack(32, string6, (Throwable)exception);
                throw new BrokerException(string6, exception);
            }
            Object var18_20 = null;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeMessages(Connection connection) throws BrokerException {
        String string = "MQMSG41S" + this.brokerID;
        String string2 = null;
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            block4: {
                try {
                    string2 = "SELECT COUNT(*) FROM " + string;
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string2);
                    if (!resultSet.next()) break block4;
                    n = resultSet.getInt(1);
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4166", (Object)string2, (Throwable)sQLException);
                    throw new BrokerException(this.br.getString("B4166", string2), sQLException);
                }
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(n)));
        this.doUpgradeMsg(connection);
    }

    private void doUpgradeMsg(Connection connection) throws BrokerException {
        String string;
        Object object;
        Object object2;
        MessageDAO messageDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        String string2 = "MQMSG41S" + this.brokerID;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("MESSAGE").append(", ").append("DESTINATION_ID").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(" FROM ").append(string2).toString();
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        Packet packet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    packet = new Packet(false);
                    packet.generateTimestamp(false);
                    packet.generateSequenceNumber(false);
                    object2 = null;
                    object = resultSet.getBlob(2);
                    object2 = object.getBinaryStream();
                    packet.readPacket((InputStream)object2);
                    ((InputStream)object2).close();
                    string = resultSet.getString(3);
                    long l = resultSet.getLong(4);
                    long l2 = resultSet.getLong(5);
                    try {
                        messageDAO.insert(connection, string, packet, null, null, l, l2, true);
                    }
                    catch (BrokerException brokerException) {
                        if (brokerException.getStatusCode() == 409) {
                            this.logger.log(16, brokerException.getMessage() + ": Ignore");
                        }
                        throw brokerException;
                    }
                    hashMap.put(string4, string);
                }
                Object var19_21 = null;
            }
            catch (Exception exception) {
                String string5 = this.br.getKString("B4163", packet == null ? string4 : packet.getSysMessageID().toString());
                this.logger.logStack(32, string5, (Throwable)exception);
                throw new BrokerException(string5, exception);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        object2 = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        object = "MQCONSTATE41S" + this.brokerID;
        string = new StringBuffer(128).append("SELECT ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(" FROM ").append((String)object).append(" WHERE ").append("STATE").append(" <> ").append(2).toString();
        String string6 = new StringBuffer(128).append("INSERT INTO ").append(object2.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        String string7 = null;
        long l = 0L;
        try {
            try {
                preparedStatement = connection.prepareStatement(string6);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    string7 = resultSet.getString(1);
                    l = resultSet.getLong(2);
                    int n = resultSet.getInt(3);
                    long l3 = resultSet.getLong(4);
                    long l4 = resultSet.getLong(5);
                    String string8 = (String)hashMap.get(string7);
                    if (string8 == null) continue;
                    try {
                        preparedStatement.setString(1, string7);
                        preparedStatement.setLong(2, l);
                        preparedStatement.setInt(3, n);
                        if (l3 > 0L) {
                            preparedStatement.setLong(4, l3);
                        } else {
                            preparedStatement.setNull(4, -5);
                        }
                        preparedStatement.setLong(5, l4);
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string6 + "]", sQLException);
                        throw sQLException2;
                    }
                }
                hashMap.clear();
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                String string9 = this.br.getKString("B4163", string7 == null ? "loading" : string7);
                this.logger.logStack(32, string9, (Throwable)sQLException);
                throw new BrokerException(string9, sQLException);
            }
            Object var28_34 = null;
        }
        catch (Throwable throwable) {
            Object var28_35 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }

    private void upgradeTxns(Connection connection) throws BrokerException {
        TransactionDAO transactionDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        String string = "MQTXN41S" + this.brokerID;
        String string2 = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(" FROM ").append(string).append(" WHERE ").append("ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(transactionDAO.getTableName()).append(")").toString();
        String string3 = new StringBuffer(128).append("INSERT INTO ").append(transactionDAO.getTableName()).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean bl = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        TransactionUID transactionUID = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(string3);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    transactionUID = new TransactionUID(l);
                    int n = resultSet.getInt(2);
                    int n2 = resultSet.getInt(3);
                    TransactionState transactionState = (TransactionState)Util.readObject(resultSet, 4);
                    transactionState.setState(n2);
                    BrokerAddress brokerAddress = (BrokerAddress)Util.readObject(resultSet, 5);
                    TransactionBroker[] transactionBrokerArray = (TransactionBroker[])Util.readObject(resultSet, 6);
                    long l2 = resultSet.getLong(7);
                    try {
                        preparedStatement.setLong(1, l);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setInt(3, n2);
                        preparedStatement.setInt(4, transactionState.getType().intValue());
                        JMQXid jMQXid = transactionState.getXid();
                        if (jMQXid != null) {
                            preparedStatement.setString(5, jMQXid.toString());
                        } else {
                            preparedStatement.setNull(5, 12);
                        }
                        Util.setObject(preparedStatement, 6, transactionState);
                        Util.setObject(preparedStatement, 7, brokerAddress);
                        Util.setObject(preparedStatement, 8, transactionBrokerArray);
                        preparedStatement.setLong(9, l2);
                        preparedStatement.setLong(10, transactionState.getExpirationTime());
                        preparedStatement.setLong(11, transactionState.getLastAccessTime());
                        if (bl) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = DBManager.wrapIOException("[" + string3 + "]", iOException);
                        throw iOException2;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                        throw sQLException2;
                    }
                }
                if (bl) {
                    preparedStatement.executeBatch();
                }
                connection.commit();
            }
            catch (Exception exception) {
                String string4 = this.br.getKString("B4172", transactionUID == null ? "loading" : transactionUID.toString());
                this.logger.logStack(32, string4, (Throwable)exception);
                throw new BrokerException(string4, exception);
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            Util.close(resultSet, statement, null);
            Util.close(null, preparedStatement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        Util.close(null, preparedStatement, null);
    }
}

