/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class FilePool {
    public static final int POOL_UNASSIGNED = 0;
    public static final int POOL_L1 = 1;
    public static final int POOL_L2 = 2;
    public static final int POOL_L3 = 3;
    int L1allocated = 0;
    int L2allocated = 0;
    int L3allocated = 0;
    int L1capacity = 0;
    ArrayList L1pool = null;
    int L2capacity = 0;
    ArrayList L2pool = null;
    ArrayList L3pool = null;
    Hashtable active = null;
    RandomAccessStore store;
    Logger logger = Globals.getLogger();

    FilePool(RandomAccessStore randomAccessStore, int n, int n2) {
        this.L1capacity = n;
        this.L1pool = new ArrayList(this.L1capacity);
        this.L2capacity = n2;
        this.L2pool = new ArrayList(this.L2capacity);
        this.L3pool = new ArrayList();
        this.store = randomAccessStore;
        this.active = new Hashtable(this.L1capacity);
        if (Store.getDEBUG()) {
            this.logger.log(4, this.getClass().getName() + ": Created new file pool: L1capacity=" + n + ", L2capacity=" + n2);
        }
    }

    synchronized File getFile() {
        File file = null;
        FilePoolEntry filePoolEntry = null;
        Object var3_3 = null;
        if (!this.L1pool.isEmpty()) {
            filePoolEntry = (FilePoolEntry)this.L1pool.remove(this.L1pool.size() - 1);
        } else if (!this.L2pool.isEmpty()) {
            filePoolEntry = (FilePoolEntry)this.L2pool.remove(this.L2pool.size() - 1);
        } else if (!this.L3pool.isEmpty()) {
            filePoolEntry = (FilePoolEntry)this.L3pool.remove(this.L3pool.size() - 1);
        } else {
            int n;
            if (this.store.low > 0) {
                n = this.store.low = this.store.low - 1;
            } else {
                int n2 = this.store.high;
                n = n2;
                this.store.high = n2 + 1;
            }
            int n3 = n;
            if (Store.getDEBUG()) {
                this.logger.log(1, "new number used for file name: " + n3);
            }
            file = new File(this.store.directory, String.valueOf(n3));
            filePoolEntry = new FilePoolEntry(file);
            this.assignEntryToPool(filePoolEntry);
        }
        this.active.put(filePoolEntry.getFile(), filePoolEntry);
        return filePoolEntry.getFile();
    }

    private void assignEntryToPool(FilePoolEntry filePoolEntry) {
        if (this.L1allocated < this.L1capacity) {
            ++this.L1allocated;
            filePoolEntry.setPool(1);
        } else if (this.L2allocated < this.L2capacity) {
            ++this.L2allocated;
            filePoolEntry.setPool(2);
        } else {
            ++this.L3allocated;
            filePoolEntry.setPool(3);
        }
    }

    synchronized void putFile(File file, boolean bl) {
        FilePoolEntry filePoolEntry = (FilePoolEntry)this.active.remove(file);
        RandomAccessFile randomAccessFile = null;
        if (filePoolEntry == null) {
            filePoolEntry = new FilePoolEntry(file);
            this.assignEntryToPool(filePoolEntry);
        }
        switch (filePoolEntry.getPool()) {
            case 1: {
                this.L1pool.add(filePoolEntry);
                try {
                    if (file.length() <= 0L) break;
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.writeUTF("FREE");
                    if (bl) {
                        if (Store.getDEBUG_SYNC()) {
                            String string = "FilePool putFile sync() " + file;
                            this.logger.log(4, string);
                        }
                        randomAccessFile.getChannel().force(false);
                    }
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    file.delete();
                    if (!Store.getDEBUG()) break;
                    this.logger.log(4, "Failed to tag free file " + file, (Throwable)iOException);
                }
                break;
            }
            case 2: {
                this.L2pool.add(filePoolEntry);
                try {
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.setLength(0L);
                    if (bl) {
                        if (Store.getDEBUG_SYNC()) {
                            String string = "FilePool putFile sync() " + file;
                            this.logger.log(4, string);
                        }
                        randomAccessFile.getChannel().force(false);
                    }
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    file.delete();
                    if (!Store.getDEBUG()) break;
                    this.logger.log(4, "Failed to truncate free file " + file, (Throwable)iOException);
                }
                break;
            }
            case 3: {
                this.L3pool.add(filePoolEntry);
                if (file.delete() || !Store.getDEBUG()) break;
                this.logger.log(4, "Failed to delete file " + file);
                break;
            }
        }
    }

    void clear() {
        this.L1pool.clear();
        this.L2pool.clear();
        this.L3pool.clear();
        this.L1allocated = 0;
        this.L2allocated = 0;
        this.L3allocated = 0;
        this.active.clear();
    }

    public void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(4, "FilePool.close() called; cleanup = " + bl);
        }
        if (!bl) {
            return;
        }
        Iterator iterator = this.L1pool.iterator();
        FilePoolEntry filePoolEntry = null;
        File file = null;
        RandomAccessFile randomAccessFile = null;
        while (iterator.hasNext()) {
            filePoolEntry = (FilePoolEntry)iterator.next();
            file = filePoolEntry.getFile();
            if (file == null || file.length() == 0L) continue;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.setLength(0L);
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                this.logger.log(4, "Could not truncate file: " + file, (Throwable)iOException);
            }
        }
    }

    public String toString() {
        return "L1 capacity=" + this.L1capacity + "  allocated=" + this.L1allocated + "  free=" + this.L1pool.size() + "\n" + "L2 capacity=" + this.L2capacity + "  allocated=" + this.L2allocated + "  free=" + this.L2pool.size() + "\n" + "L3 capacity=unlimited" + "  allocated=" + this.L3allocated + "  free=" + this.L3pool.size();
    }

    void printFileInfo(PrintStream printStream) {
        printStream.println(this.toString());
    }

    void printStatistics() {
        if (Store.getDEBUG()) {
            this.logger.log(4, this.toString());
        }
    }

    public int getNumFreeFiles() {
        return this.L1pool.size() + this.L2pool.size();
    }

    public void dumpPool(PrintStream printStream) {
        File file;
        printStream.println(this.getClass().getName() + ": ");
        printStream.println(this.toString());
        printStream.print(">>>L1: ");
        for (FilePoolEntry filePoolEntry : this.L1pool) {
            file = filePoolEntry.getFile();
            printStream.print(file.getName() + ",");
        }
        printStream.print("\n>>>L2: ");
        for (FilePoolEntry filePoolEntry : this.L2pool) {
            file = filePoolEntry.getFile();
            printStream.print(file.getName() + ",");
        }
        printStream.print("\n>>>L3: ");
        for (FilePoolEntry filePoolEntry : this.L3pool) {
            file = filePoolEntry.getFile();
            printStream.print(file.getName() + ",");
        }
        printStream.print("\n");
    }

    public class FilePoolEntry {
        private File file = null;
        private int pool = 0;

        FilePoolEntry(File file) {
            this.file = file;
            this.pool = 0;
        }

        public void setPool(int n) {
            this.pool = n;
        }

        public int getPool() {
            return this.pool;
        }

        public File getFile() {
            return this.file;
        }
    }
}

