/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class ClusterBrokerInfoReply {
    private static boolean DEBUG = false;
    private BrokerInfo brokerInfo = null;
    private int status = 0;
    private GPacket pkt = null;

    private ClusterBrokerInfoReply(BrokerInfo brokerInfo, int n) {
        this.brokerInfo = brokerInfo;
        this.status = n;
    }

    private ClusterBrokerInfoReply(GPacket gPacket) throws Exception {
        assert (gPacket.getType() == 46);
        this.pkt = gPacket;
        this.status = (Integer)gPacket.getProp((Object)"S");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gPacket.getPayload().array());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.brokerInfo = (BrokerInfo)objectInputStream.readObject();
    }

    public static ClusterBrokerInfoReply newInstance(BrokerInfo brokerInfo, int n) {
        return new ClusterBrokerInfoReply(brokerInfo, n);
    }

    public static ClusterBrokerInfoReply newInstance(GPacket gPacket) throws Exception {
        return new ClusterBrokerInfoReply(gPacket);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)46);
        gPacket.setBit(1, false);
        gPacket.putProp((Object)"S", (Object)new Integer(this.status));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.brokerInfo);
        objectOutputStream.flush();
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        return gPacket;
    }

    public int getStatus() {
        return this.status;
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public boolean isTakingover() {
        return this.getStatus() == 1;
    }

    public boolean sendAndClose() {
        return this.isTakingover();
    }
}

