/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;

class DetachedTransactionReaper {
    static final long DEFAULT_TIMEOUT = 0L;
    List txns = null;
    TimerTask mytimer = null;
    TransactionList translist = null;
    private static MQTimer timer = Globals.getTimer();
    boolean destroyed = false;

    public DetachedTransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
        this.txns = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetachedTID(TransactionUID transactionUID) {
        long l = Globals.getConfig().getLongProperty("imq.transaction.detachedTimeout", 0L);
        if (l <= 0L) {
            return;
        }
        DetachedTransactionReaper detachedTransactionReaper = this;
        synchronized (detachedTransactionReaper) {
            this.txns.add(transactionUID);
            if (this.mytimer == null || this.txns.size() == 1) {
                this.addTimer(l);
            }
        }
    }

    public synchronized void removeDetachedTID(TransactionUID transactionUID) {
        boolean bl = this.txns.remove(transactionUID);
        if (bl && this.txns.isEmpty()) {
            this.removeTimer();
        }
    }

    public synchronized TransactionUID[] getDetachedTIDs() {
        return this.txns.toArray(new TransactionUID[0]);
    }

    public synchronized void destroy() {
        this.destroyed = true;
        if (this.mytimer != null) {
            this.removeTimer();
        }
        this.txns.clear();
    }

    private void addTimer(long l) {
        assert (Thread.holdsLock(this));
        assert (this.mytimer == null);
        this.mytimer = new DetachedTransactionTimerTask(l);
        try {
            long l2 = l * 1000L;
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1281", l));
            timer.schedule(this.mytimer, l2, l2);
        }
        catch (IllegalStateException illegalStateException) {
            Globals.getLogger().logStack(8, "B3100", (Object)("Failed to schedule detached-transaction reaper " + this), (Throwable)illegalStateException);
        }
    }

    private void removeTimer() {
        assert (Thread.holdsLock(this));
        try {
            if (this.mytimer != null) {
                this.mytimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Globals.getLogger().logStack(4, "Failed to cancel detached-transaction reaper timer ", (Throwable)illegalStateException);
        }
        this.mytimer = null;
    }

    class DetachedTransactionTimerTask
    extends TimerTask {
        private long timeout;

        public DetachedTransactionTimerTask(long l) {
            this.timeout = l * 1000L;
        }

        public void run() {
            TransactionHandler transactionHandler = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
            long l = System.currentTimeMillis();
            TransactionUID[] transactionUIDArray = DetachedTransactionReaper.this.getDetachedTIDs();
            for (int i = 0; i < transactionUIDArray.length && !DetachedTransactionReaper.this.destroyed; ++i) {
                long l2;
                TransactionState transactionState = DetachedTransactionReaper.this.translist.retrieveState(transactionUIDArray[i]);
                if (transactionState == null || !transactionState.isDetachedFromConnection() || transactionState.getState() != 3 && transactionState.getState() != 4) {
                    DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                    continue;
                }
                if (this.timeout == 0L || l <= (l2 = transactionState.getDetachedTime() + this.timeout)) continue;
                try {
                    Object[] objectArray = new String[]{transactionUIDArray[i] + "[" + TransactionState.toString(transactionState.getState()) + "]", String.valueOf(transactionState.getCreationTime()), String.valueOf(transactionState.getDetachedTime())};
                    Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2185", objectArray));
                    transactionHandler.doRollback(transactionUIDArray[i], transactionState.getXid(), null, transactionState, null, null, RollbackReason.TIMEOUT);
                    DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2186", transactionUIDArray[i] + "[" + TransactionState.toString(transactionState.getState()) + "]"), (Throwable)exception);
                }
            }
        }
    }
}

